/*
* Copyright 2005,2006 WSO2, Inc. http://wso2.com
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
*
*/
package org.wso2.throttle.module;


import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.*;
import org.apache.axis2.modules.Module;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.wso2.throttle.Throttle;
import org.wso2.throttle.ThrottleConstants;
import org.wso2.throttle.ThrottleException;
import org.wso2.throttle.ThrottlePolicyProcessor;

public class ThrottleModule implements Module {

    private static Log log = LogFactory.getLog(ThrottleModule.class.getName());

    /** The QName of the module   */
    private String name;

    /**
     * initialize the module
     */
    public void init(ConfigurationContext configContext, AxisModule module) throws AxisFault {
        Throttle throttle;
        try {
            this.name = module.getName();
            PolicyInclude policyInclude = module.getPolicyInclude();
            if (policyInclude != null) {
                Policy policy = module.getPolicyInclude().getEffectivePolicy();
                throttle = ThrottlePolicyProcessor.processPolicy(policy);
                if (throttle != null) {
                    Parameter globalParameter = new Parameter();
                    globalParameter.setName(ThrottleConstants.GLOBAL_IP_BASED_THROTTLE_KEY);
                    globalParameter.setValue(throttle);
                    configContext.getAxisConfiguration().addParameter(globalParameter);
                }
            }
        }
        catch (ThrottleException e) {
            throw new AxisFault(e.getMessage());
        }

    }

    public void engageNotify(AxisDescription axisDescription) throws AxisFault {

        String currentServiceName;
        if (axisDescription instanceof AxisService) {
            Throttle throttle;
            AxisService currentService = ((AxisService) axisDescription);
            AxisModule module = currentService.getAxisConfiguration().getModule(this.name);
            PolicyInclude policyInclude = currentService.getPolicyInclude();
            if (policyInclude != null) {
                try {
                    Policy currentPolicy = policyInclude.getPolicy();
                    if (currentPolicy == null) {
                        currentPolicy = policyInclude.getEffectivePolicy();
                        if (currentPolicy == null) {
                            policyInclude = module.getPolicyInclude();
                            if (policyInclude != null) {
                                currentPolicy = policyInclude.getEffectivePolicy();
                            }
                        }
                    }
                    throttle = ThrottlePolicyProcessor.processPolicy(currentPolicy);
                    if (throttle != null) {

                        Parameter service_throttle_Parameter = new Parameter();
                        service_throttle_Parameter.setName(currentService.getName());
                        service_throttle_Parameter.setValue(throttle);
                        axisDescription.getAxisConfiguration().addParameter(service_throttle_Parameter);
                    }
                }
                catch (ThrottleException e) {
                    throw new AxisFault(e.getMessage());
                }
            }
        } else if (axisDescription instanceof AxisOperation) {
            Throttle throttle;
            AxisOperation currentOperation = ((AxisOperation) axisDescription);
            currentServiceName = ((AxisService) currentOperation.getParent()).getName();
            AxisModule module = currentOperation.getAxisConfiguration().getModule(this.name);
            PolicyInclude policyInclude = currentOperation.getPolicyInclude();
            if (policyInclude != null) {
                try {
                    Policy currentPolicy = policyInclude.getPolicy();
                    if (currentPolicy == null) {
                        currentPolicy = policyInclude.getEffectivePolicy();
                        if (currentPolicy == null) {
                            policyInclude = module.getPolicyInclude();
                            if (policyInclude != null) {
                                currentPolicy = policyInclude.getEffectivePolicy();
                            }
                        }
                    }
                    throttle = ThrottlePolicyProcessor.processPolicy(currentPolicy);
                    if (throttle != null) {

                        Parameter operation_throttle_Parameter = new Parameter();
                        operation_throttle_Parameter.setName(currentServiceName + currentOperation.getName());
                        operation_throttle_Parameter.setValue(throttle);
                        axisDescription.getAxisConfiguration().addParameter(operation_throttle_Parameter);
                    }
                }
                catch (ThrottleException e) {
                    throw new AxisFault(e.getMessage());
                }
            }
        }
    }

    public void shutdown(ConfigurationContext configurationContext) throws AxisFault {
        //Todo
    }

    public void applyPolicy(Policy policy, AxisDescription axisDescription) throws AxisFault {

        // TODO
    }

    public boolean canSupportAssertion(Assertion assertion) {
        // TODO
        return true;
    }
}