/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle.impl.ipbase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.throttle.AccessController;
import org.wso2.throttle.Caller;
import org.wso2.throttle.CallerConfiguration;
import org.wso2.throttle.ThrottleConfiguration;
import org.wso2.throttle.ThrottleContext;
import org.wso2.throttle.ThrottleException;
import org.wso2.throttle.factory.CallerFactory;

public class IPBaseAccessController
implements AccessController {
    private static Log log = LogFactory.getLog((String)IPBaseAccessController.class.getName());
    private static final String ACCESS_DENIED = "You cannot access this service since you have exceeded the allocated quota.";

    public boolean canAccess(ThrottleContext throttleContext, Object callerID) throws ThrottleException {
        ThrottleConfiguration throttleConfigurationBean = throttleContext.getThrottleConfiguration();
        String remoteIP = null;
        if (callerID instanceof String) {
            remoteIP = (String)callerID;
        } else {
            log.debug((Object)"Caller ID should instance of String for IPBASE Throttle");
        }
        if (remoteIP == null) {
            log.warn((Object)"Caller IP not found!");
            return false;
        }
        CallerConfiguration configuration = throttleContext.getThrottleConfiguration().getCallerConfiguration(remoteIP);
        if (configuration == null) {
            log.warn((Object)("Throttle configuration not be found for IP address " + remoteIP));
            return false;
        }
        if (configuration.getAccessState() == 1) {
            log.info((Object)ACCESS_DENIED);
            return false;
        }
        if (configuration.getAccessState() == 2) {
            return true;
        }
        if (configuration.getAccessState() == 0) {
            Object correctedEPR;
            Caller caller = throttleContext.getCaller(remoteIP);
            if (caller == null && (correctedEPR = throttleConfigurationBean.getConfigurationKeyOfCaller(remoteIP)) != null) {
                caller = CallerFactory.createCaller(0, correctedEPR);
            }
            if (caller != null) {
                long currentTime = System.currentTimeMillis();
                if (!caller.canAccess(throttleContext, currentTime)) {
                    log.info((Object)ACCESS_DENIED);
                    throttleContext.processCleanList(currentTime);
                    return false;
                }
                log.debug((Object)("Access  from IP address " + remoteIP + "is successful."));
                return true;
            }
            log.warn((Object)("Caller IP not found! " + remoteIP));
            return false;
        }
        return true;
    }
}

