/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle.impl.ipbase;

import java.io.Serializable;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.throttle.CallerConfiguration;
import org.wso2.throttle.ThrottleConfiguration;
import org.wso2.throttle.impl.ipbase.IPBaseCallerConfiguration;

public class IPBaseThrottleConfiguration
implements Serializable,
ThrottleConfiguration {
    private static Log log = LogFactory.getLog((String)IPBaseThrottleConfiguration.class.getName());
    private String keyOfOther;
    private CallerConfiguration defaultCallerConfiguration;
    private TreeMap configurationsMap = new TreeMap();

    public CallerConfiguration getCallerConfiguration(Object ID) {
        if (ID.equals("Other")) {
            return this.defaultCallerConfiguration;
        }
        String key = (String)this.getConfigurationKeyOfCaller(ID);
        if (key != null) {
            if (key.equals("Other")) {
                return this.defaultCallerConfiguration;
            }
            return (IPBaseCallerConfiguration)this.configurationsMap.get(key);
        }
        return null;
    }

    public TreeMap getConfigurations() {
        return this.configurationsMap;
    }

    public void setConfigurations(TreeMap map) {
        this.configurationsMap = map;
    }

    public void addCallerConfiguration(CallerConfiguration configuration) {
        IPBaseCallerConfiguration ipBaseCallerConfiguration = (IPBaseCallerConfiguration)configuration;
        String key = ipBaseCallerConfiguration.getFirstPartOfIPRange();
        if (key.equals("Other")) {
            this.keyOfOther = "Other";
            this.defaultCallerConfiguration = ipBaseCallerConfiguration;
        } else {
            this.configurationsMap.put(key, ipBaseCallerConfiguration);
        }
    }

    public Object getConfigurationKeyOfCaller(Object callerID) {
        String ip = (String)callerID;
        if (this.configurationsMap.containsKey(ip)) {
            return ip;
        }
        SortedMap map = this.configurationsMap.headMap(ip);
        if (map != null && map.size() > 0) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                IPBaseCallerConfiguration ipBaseCallerConfiguration = (IPBaseCallerConfiguration)iterator.next();
                if (ipBaseCallerConfiguration.getSecondPartOfIPRange() == null || ipBaseCallerConfiguration.getSecondPartOfIPRange().compareTo(ip) <= 0) continue;
                return ipBaseCallerConfiguration.getFirstPartOfIPRange();
            }
        }
        return this.keyOfOther;
    }

    public int getType() {
        return 0;
    }
}

