/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle.module;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.modules.Module;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.wso2.throttle.Throttle;
import org.wso2.throttle.ThrottleException;
import org.wso2.throttle.ThrottlePolicyProcessor;

public class ThrottleModule
implements Module {
    private static Log log = LogFactory.getLog((String)ThrottleModule.class.getName());
    private String name;

    public void init(ConfigurationContext configContext, AxisModule module) throws AxisFault {
        try {
            Policy policy;
            Throttle throttle;
            this.name = module.getName();
            PolicyInclude policyInclude = module.getPolicyInclude();
            if (policyInclude != null && (throttle = ThrottlePolicyProcessor.processPolicy(policy = module.getPolicyInclude().getEffectivePolicy())) != null) {
                Parameter globalParameter = new Parameter();
                globalParameter.setName("Key_of_global_ip_based_Throttle");
                globalParameter.setValue((Object)throttle);
                configContext.getAxisConfiguration().addParameter(globalParameter);
            }
        }
        catch (ThrottleException e) {
            throw new AxisFault(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void engageNotify(AxisDescription axisDescription) throws AxisFault {
        if (axisDescription instanceof AxisService) {
            AxisService currentService = (AxisService)axisDescription;
            AxisModule module = currentService.getAxisConfiguration().getModule(this.name);
            PolicyInclude policyInclude = currentService.getPolicyInclude();
            if (policyInclude == null) return;
            try {
                Throttle throttle;
                Policy currentPolicy = policyInclude.getPolicy();
                if (currentPolicy == null && (currentPolicy = policyInclude.getEffectivePolicy()) == null && (policyInclude = module.getPolicyInclude()) != null) {
                    currentPolicy = policyInclude.getEffectivePolicy();
                }
                if ((throttle = ThrottlePolicyProcessor.processPolicy(currentPolicy)) == null) return;
                Parameter service_throttle_Parameter = new Parameter();
                service_throttle_Parameter.setName(currentService.getName());
                service_throttle_Parameter.setValue((Object)throttle);
                axisDescription.getAxisConfiguration().addParameter(service_throttle_Parameter);
                return;
            }
            catch (ThrottleException e) {
                throw new AxisFault(e.getMessage());
            }
        }
        if (!(axisDescription instanceof AxisOperation)) return;
        AxisOperation currentOperation = (AxisOperation)axisDescription;
        String currentServiceName = ((AxisService)currentOperation.getParent()).getName();
        AxisModule module = currentOperation.getAxisConfiguration().getModule(this.name);
        PolicyInclude policyInclude = currentOperation.getPolicyInclude();
        if (policyInclude == null) return;
        try {
            Throttle throttle;
            Policy currentPolicy = policyInclude.getPolicy();
            if (currentPolicy == null && (currentPolicy = policyInclude.getEffectivePolicy()) == null && (policyInclude = module.getPolicyInclude()) != null) {
                currentPolicy = policyInclude.getEffectivePolicy();
            }
            if ((throttle = ThrottlePolicyProcessor.processPolicy(currentPolicy)) == null) return;
            Parameter operation_throttle_Parameter = new Parameter();
            operation_throttle_Parameter.setName(currentServiceName + currentOperation.getName());
            operation_throttle_Parameter.setValue((Object)throttle);
            axisDescription.getAxisConfiguration().addParameter(operation_throttle_Parameter);
            return;
        }
        catch (ThrottleException e) {
            throw new AxisFault(e.getMessage());
        }
    }

    public void shutdown(ConfigurationContext configurationContext) throws AxisFault {
    }

    public void applyPolicy(Policy policy, AxisDescription axisDescription) throws AxisFault {
    }

    public boolean canSupportAssertion(Assertion assertion) {
        return true;
    }
}

