/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle.module.handler;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.throttle.AccessController;
import org.wso2.throttle.Throttle;
import org.wso2.throttle.ThrottleContext;
import org.wso2.throttle.ThrottleException;
import org.wso2.throttle.factory.AccessControllerFactory;

public abstract class ThrottleHandler
extends AbstractHandler {
    private static Log log = LogFactory.getLog((String)ThrottleHandler.class.getName());

    protected abstract int getThrottleType();

    /*
     * WARNING - void declaration
     */
    public Throttle loadThrottle(MessageContext messageContext, int throttleType) throws AxisFault, ThrottleException {
        void var5_5;
        Throttle throttle = null;
        ConfigurationContext configContext = messageContext.getConfigurationContext();
        switch (throttleType) {
            case 0: {
                Parameter throttleObjectParameter = configContext.getAxisConfiguration().getParameter("Key_of_global_ip_based_Throttle");
                break;
            }
            case 2: {
                Parameter throttleObjectParameter;
                AxisOperation axisOperation = messageContext.getAxisOperation();
                if (axisOperation != null) {
                    String currentServiceName = ((AxisService)axisOperation.getParent()).getName();
                    throttleObjectParameter = configContext.getAxisConfiguration().getParameter(currentServiceName + axisOperation.getName().getLocalPart());
                    break;
                }
                throw new AxisFault("Axis operation cannot be null");
            }
            case 1: {
                Parameter throttleObjectParameter;
                AxisService axisService = messageContext.getAxisService();
                if (axisService != null) {
                    throttleObjectParameter = configContext.getAxisConfiguration().getParameter(axisService.getName());
                    break;
                }
                throw new AxisFault("Axis service cannot be null");
            }
            default: {
                throw new ThrottleException("Unsupported Throttle type");
            }
        }
        if (var5_5 != null) {
            Object throttleObject = var5_5.getValue();
            if (throttleObject instanceof Throttle) {
                throttle = (Throttle)throttleObject;
            } else {
                throw new ThrottleException("Incompatible object for IPBaseThrottleConfiguration");
            }
        }
        return throttle;
    }

    public void process(Throttle throttle, MessageContext messageContext) throws ThrottleException, AxisFault {
        Object remoteIP = messageContext.getProperty("REMOTE_ADDR");
        if (remoteIP == null) {
            throw new AxisFault("Could not find the IP address of the caller - Currently only support caller-IP base access control");
        }
        ThrottleContext throttleContext = throttle.getThrottleContext("Key_of_ip_based_Throttle");
        AccessController accessController = AccessControllerFactory.createAccessControler(0);
        if (!accessController.canAccess(throttleContext, remoteIP)) {
            throw new AxisFault("You cannot access this service since you have exceeded the allocated quota.");
        }
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        try {
            Throttle throttle = this.loadThrottle(msgContext, this.getThrottleType());
            if (throttle != null) {
                this.process(throttle, msgContext);
            } else {
                log.warn((Object)"Cannot find throttle configuration.");
            }
        }
        catch (ThrottleException e) {
            log.error((Object)e.getMessage());
            throw new AxisFault(e.getMessage());
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

