/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle.module;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.modules.Module;
import org.apache.axis2.util.PolicyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.xml.XmlPrimtiveAssertion;
import org.wso2.throttle.ConcurrentAccessController;
import org.wso2.throttle.Throttle;
import org.wso2.throttle.ThrottleConstants;
import org.wso2.throttle.ThrottleException;
import org.wso2.throttle.ThrottleFactory;

public class ThrottleModule
implements Module {
    private static Log log = LogFactory.getLog((String)ThrottleModule.class.getName());
    private Policy defaultPolicy = null;
    private Throttle defaultThrottle = null;
    private ConfigurationContext configctx;

    public void init(ConfigurationContext configContext, AxisModule module) throws AxisFault {
        ArrayList list;
        Policy policy;
        this.configctx = configContext;
        this.initDefaultPolicy();
        this.initDefaultThrottle();
        PolicySubject policySubject = module.getPolicySubject();
        if (policySubject != null && (policy = PolicyUtil.getMergedPolicy(list = new ArrayList(policySubject.getAttachedPolicyComponents()), null)) != null) {
            Throttle throttle;
            try {
                throttle = ThrottleFactory.createModuleThrottle((Policy)policy);
            }
            catch (ThrottleException e) {
                log.error((Object)("Error was occurred when initiating throttle module " + e.getMessage()));
                log.info((Object)"Throttling will occur using default module policy");
                String id = policy.getId();
                policySubject.detachPolicyComponent(id);
                this.defaultPolicy.setId(id);
                policySubject.attachPolicy(this.defaultPolicy);
                throttle = this.defaultThrottle;
            }
            if (throttle != null) {
                HashMap<String, Throttle> throttles = (HashMap<String, Throttle>)this.configctx.getPropertyNonReplicable("local_throttle_map");
                if (throttles == null) {
                    throttles = new HashMap<String, Throttle>();
                    this.configctx.setNonReplicableProperty("local_throttle_map", throttles);
                }
                throttle.setId("id_of_global_throttle_");
                throttles.put("key_of_global_throttle", throttle);
                ConcurrentAccessController cac = throttle.getConcurrentAccessController();
                if (cac != null) {
                    String cacKey = "throttle_id_of_global_throttle__cac_key";
                    this.configctx.setProperty(cacKey, (Object)cac);
                }
            }
        }
    }

    public void engageNotify(AxisDescription axisDescription) throws AxisFault {
        if (axisDescription instanceof AxisService) {
            Throttle throttle = null;
            AxisService currentService = (AxisService)axisDescription;
            PolicySubject policySubject = currentService.getPolicySubject();
            if (policySubject != null) {
                try {
                    ArrayList policies = new ArrayList(policySubject.getAttachedPolicyComponents());
                    Policy currentPolicy = PolicyUtil.getMergedPolicy(policies, (AxisService)currentService);
                    if (currentPolicy != null) {
                        throttle = ThrottleFactory.createServiceThrottle((Policy)currentPolicy);
                    } else {
                        AxisConfiguration axisConfig = MessageContext.getCurrentMessageContext().getConfigurationContext().getAxisConfiguration();
                        AxisModule throttleModule = axisConfig.getModule("wso2throttle");
                        policySubject = throttleModule.getPolicySubject();
                        if (policySubject != null && (currentPolicy = this.getThrottlePolicy(policySubject.getAttachedPolicyComponents())) != null) {
                            throttle = ThrottleFactory.createModuleThrottle((Policy)currentPolicy);
                        }
                    }
                }
                catch (ThrottleException e) {
                    log.error((Object)("Error was occurred when engaging throttle module for the service :" + currentService.getName() + e.getMessage()));
                    log.info((Object)"Throttling will occur using default module policy");
                    throttle = this.defaultThrottle;
                }
                if (throttle != null) {
                    HashMap<String, Throttle> throttles = (HashMap<String, Throttle>)this.configctx.getPropertyNonReplicable("local_throttle_map");
                    if (throttles == null) {
                        throttles = new HashMap<String, Throttle>();
                        this.configctx.setNonReplicableProperty("local_throttle_map", throttles);
                    }
                    String serviceName = currentService.getName();
                    throttle.setId(serviceName);
                    throttles.put(serviceName, throttle);
                    ConcurrentAccessController cac = throttle.getConcurrentAccessController();
                    if (cac != null) {
                        String cacKey = "throttle_" + serviceName + "_cac_key";
                        this.configctx.setProperty(cacKey, (Object)cac);
                    }
                }
            }
        } else if (axisDescription instanceof AxisOperation) {
            Throttle throttle = null;
            AxisOperation currentOperation = (AxisOperation)axisDescription;
            AxisService axisService = (AxisService)currentOperation.getParent();
            if (axisService != null) {
                String currentServiceName = axisService.getName();
                PolicySubject policySubject = currentOperation.getPolicySubject();
                if (policySubject != null) {
                    try {
                        ArrayList policies = new ArrayList(policySubject.getAttachedPolicyComponents());
                        Policy currentPolicy = PolicyUtil.getMergedPolicy(policies, (AxisDescription)currentOperation);
                        if (currentPolicy != null) {
                            throttle = ThrottleFactory.createOperationThrottle((Policy)currentPolicy);
                        }
                    }
                    catch (ThrottleException e) {
                        log.error((Object)("Error was occurred when engaging throttle module for operation : " + currentOperation.getName() + " in the service :" + currentServiceName + e.getMessage()));
                        log.info((Object)"Throttling will occur using default module policy");
                        throttle = this.defaultThrottle;
                    }
                    if (throttle != null) {
                        QName opQName;
                        HashMap<String, Throttle> throttles = (HashMap<String, Throttle>)this.configctx.getPropertyNonReplicable("local_throttle_map");
                        if (throttles == null) {
                            throttles = new HashMap<String, Throttle>();
                            this.configctx.setNonReplicableProperty("local_throttle_map", throttles);
                        }
                        if ((opQName = currentOperation.getName()) != null) {
                            String opName = opQName.getLocalPart();
                            String key = currentServiceName + opName;
                            throttle.setId(key);
                            throttles.put(key, throttle);
                            ConcurrentAccessController cac = throttle.getConcurrentAccessController();
                            if (cac != null) {
                                String cacKey = "throttle_" + key + "_cac_key";
                                this.configctx.setProperty(cacKey, (Object)cac);
                            }
                        }
                    }
                }
            }
        }
    }

    public void shutdown(ConfigurationContext configurationContext) throws AxisFault {
    }

    public void applyPolicy(Policy policy, AxisDescription axisDescription) throws AxisFault {
    }

    public boolean canSupportAssertion(Assertion assertion) {
        return true;
    }

    private void initDefaultPolicy() throws AxisFault {
        InputStream inputStream = this.getClass().getResourceAsStream("/resources/policy/default_module_policy.xml");
        if (inputStream == null) {
            throw new AxisFault("Couldn't load the default throttle policy.The module is invalid ");
        }
        this.defaultPolicy = PolicyEngine.getPolicy((InputStream)inputStream);
    }

    private void initDefaultThrottle() throws AxisFault {
        block4: {
            try {
                if (this.defaultPolicy != null) {
                    this.defaultThrottle = ThrottleFactory.createModuleThrottle((Policy)this.defaultPolicy);
                    if (this.defaultThrottle == null) {
                        throw new AxisFault("Couldn't create the default throttle.The module is invalid ");
                    }
                    break block4;
                }
                throw new AxisFault("Couldn't find the default throttle policy .the module is invalid ");
            }
            catch (ThrottleException e) {
                String msg = "Error during processing default throttle policy + system will not works" + e.getMessage();
                log.error((Object)msg);
                throw new AxisFault(msg);
            }
        }
    }

    private Policy getThrottlePolicy(Collection components) throws AxisFault {
        Iterator i = components.iterator();
        while (i.hasNext()) {
            Object comp = i.next();
            Policy policy = (Policy)comp;
            Iterator iterator = policy.getAlternatives();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof List)) continue;
                List list = (List)object;
                Iterator j = list.iterator();
                while (j.hasNext()) {
                    XmlPrimtiveAssertion primitiveAssertion;
                    QName assertionName;
                    Object assertObj = j.next();
                    if (!(assertObj instanceof XmlPrimtiveAssertion) || !(assertionName = (primitiveAssertion = (XmlPrimtiveAssertion)assertObj).getName()).equals(ThrottleConstants.SERVICE_THROTTLE_ASSERTION_QNAME) && !assertionName.equals(ThrottleConstants.MODULE_THROTTLE_ASSERTION_QNAME)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Existing ThrottleAssertion found");
                    }
                    return policy;
                }
            }
        }
        return null;
    }
}

