/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle.module.handler;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.state.Replicator;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.throttle.AccessInformation;
import org.wso2.throttle.AccessRateController;
import org.wso2.throttle.ConcurrentAccessController;
import org.wso2.throttle.Throttle;
import org.wso2.throttle.ThrottleConfiguration;
import org.wso2.throttle.ThrottleContext;
import org.wso2.throttle.ThrottleException;

public abstract class ThrottleHandler
extends AbstractHandler {
    private static Log log = LogFactory.getLog((String)ThrottleHandler.class.getName());
    private AccessRateController accessRateController;
    private boolean debugOn = log.isDebugEnabled();

    public ThrottleHandler() {
        this.accessRateController = new AccessRateController();
    }

    protected abstract int getThrottleType();

    public Throttle loadThrottle(MessageContext messageContext, int throttleType) throws ThrottleException {
        Throttle throttle = null;
        ConfigurationContext configContext = messageContext.getConfigurationContext();
        Map throttles = (Map)configContext.getPropertyNonReplicable("local_throttle_map");
        if (throttles == null) {
            if (this.debugOn) {
                log.debug((Object)"Couldn't find throttles object map .. thottlling will not be occurred ");
            }
            return null;
        }
        switch (throttleType) {
            case 0: {
                throttle = (Throttle)throttles.get("key_of_global_throttle");
                break;
            }
            case 2: {
                AxisOperation axisOperation = messageContext.getAxisOperation();
                if (axisOperation != null) {
                    String currentServiceName;
                    AxisService service;
                    QName opName = axisOperation.getName();
                    if (opName == null || (service = (AxisService)axisOperation.getParent()) == null || (currentServiceName = service.getName()) == null) break;
                    throttle = (Throttle)throttles.get(currentServiceName + opName.getLocalPart());
                    break;
                }
                if (this.debugOn) {
                    log.debug((Object)"Couldn't find axis operation ");
                }
                return null;
            }
            case 1: {
                AxisService axisService = messageContext.getAxisService();
                if (axisService != null) {
                    throttle = (Throttle)throttles.get(axisService.getName());
                    break;
                }
                if (this.debugOn) {
                    log.debug((Object)"Couldn't find axis service ");
                }
                return null;
            }
            default: {
                throw new ThrottleException("Unsupported Throttle type");
            }
        }
        return throttle;
    }

    public void process(Throttle throttle, MessageContext messageContext) throws ThrottleException, AxisFault {
        ConcurrentAccessController cac;
        String throttleId = throttle.getId();
        ConfigurationContext cc = messageContext.getConfigurationContext();
        boolean isClusteringEnable = false;
        ClusteringAgent clusteringAgent = cc.getAxisConfiguration().getClusteringAgent();
        if (clusteringAgent != null && clusteringAgent.getStateManager() != null) {
            isClusteringEnable = true;
        }
        String key = null;
        if (isClusteringEnable) {
            key = "throttle_" + throttleId + "_cac_key";
            cac = (ConcurrentAccessController)cc.getProperty(key);
        } else {
            cac = throttle.getConcurrentAccessController();
        }
        boolean canAccess = this.doConcurrentThrottling(cac, messageContext);
        if (canAccess) {
            if (messageContext.getFLOW() == 1) {
                String domain = null;
                HttpServletRequest request = (HttpServletRequest)messageContext.getPropertyNonReplicable(HTTPConstants.MC_HTTP_SERVLETREQUEST);
                if (request != null) {
                    domain = request.getRemoteHost();
                }
                String callerId = null;
                if (domain != null) {
                    ThrottleConfiguration config;
                    ThrottleContext context = throttle.getThrottleContext("key_of_domain_based_throttle");
                    if (context != null && (config = context.getThrottleConfiguration()) != null) {
                        callerId = config.getConfigurationKeyOfCaller(domain);
                        if (callerId != null) {
                            AccessInformation infor;
                            if (isClusteringEnable) {
                                context.setConfigurationContext(cc);
                                context.setThrottleId(throttleId);
                            }
                            if (!(infor = this.accessRateController.canAccess(context, callerId, 1)).isAccessAllowed()) {
                                if (cac != null) {
                                    cac.incrementAndGet();
                                    if (isClusteringEnable) {
                                        cc.setProperty(key, (Object)cac);
                                        try {
                                            if (this.debugOn) {
                                                log.debug((Object)("Going to replicates the states of the ConcurrentAccessController with key : " + key));
                                            }
                                            Replicator.replicate((AbstractContext)cc, (String[])new String[]{key});
                                        }
                                        catch (ClusteringFault clusteringFault) {
                                            log.error((Object)"Error during replicating states ", (Throwable)clusteringFault);
                                        }
                                    }
                                }
                                throw new AxisFault(" Access deny for a caller with Domain " + domain + " " + " : Reason : " + infor.getFaultReason());
                            }
                        } else if (this.debugOn) {
                            log.debug((Object)("Could not find the Throttle Context for domain-Based Throttling for domain name " + domain + " Throttling for this " + "domain name may not be configured from policy"));
                        }
                    }
                } else if (this.debugOn) {
                    log.debug((Object)"Could not find the domain of the caller - IP-based throttling may occur");
                }
                if (callerId == null) {
                    String ip = (String)messageContext.getProperty("REMOTE_ADDR");
                    if (ip != null) {
                        ThrottleContext context = throttle.getThrottleContext("key_of_ip_based_throttle");
                        if (context != null) {
                            ThrottleConfiguration config = context.getThrottleConfiguration();
                            if (config != null && (callerId = config.getConfigurationKeyOfCaller(ip)) != null) {
                                AccessInformation infor;
                                if (isClusteringEnable) {
                                    context.setConfigurationContext(cc);
                                    context.setThrottleId(throttleId);
                                }
                                if (!(infor = this.accessRateController.canAccess(context, callerId, 1)).isAccessAllowed()) {
                                    if (cac != null) {
                                        cac.incrementAndGet();
                                        if (isClusteringEnable) {
                                            cc.setProperty(key, (Object)cac);
                                            try {
                                                if (this.debugOn) {
                                                    log.debug((Object)("Going to replicates the states of the ConcurrentAccessController with key : " + key));
                                                }
                                                Replicator.replicate((AbstractContext)cc, (String[])new String[]{key});
                                            }
                                            catch (ClusteringFault clusteringFault) {
                                                log.error((Object)"Error during replicating states ", (Throwable)clusteringFault);
                                            }
                                        }
                                    }
                                    throw new AxisFault(" Access deny for a caller with IP " + ip + " " + " : Reason : " + infor.getFaultReason());
                                }
                            }
                        } else if (this.debugOn) {
                            log.debug((Object)"Could not find the throttle Context for IP-Based throttling");
                        }
                    } else if (this.debugOn) {
                        log.debug((Object)"Could not find the IP address of the caller - throttling will not occur");
                    }
                }
            }
            if (isClusteringEnable && cac != null) {
                try {
                    if (this.debugOn) {
                        log.debug((Object)("Going to replicates the states of the ConcurrentAccessController with key : " + key));
                    }
                    Replicator.replicate((AbstractContext)cc, (String[])new String[]{key});
                }
                catch (ClusteringFault clusteringFault) {
                    log.error((Object)"Error during replicating states ", (Throwable)clusteringFault);
                }
            }
        } else {
            if (isClusteringEnable) {
                try {
                    if (this.debugOn) {
                        log.debug((Object)("Going to replicates the states of the ConcurrentAccessController with key : " + key));
                    }
                    Replicator.replicate((AbstractContext)cc, (String[])new String[]{key});
                }
                catch (ClusteringFault clusteringFault) {
                    log.error((Object)"Error during replicating states ", (Throwable)clusteringFault);
                }
            }
            throw new AxisFault("Access has currently been denied since  maximum concurrent access have exceeded");
        }
    }

    private boolean doConcurrentThrottling(ConcurrentAccessController concurrentAccessController, MessageContext messageContext) {
        boolean canAccess = true;
        if (concurrentAccessController != null) {
            if (messageContext.getFLOW() == 1) {
                int available = concurrentAccessController.getAndDecrement();
                boolean bl = canAccess = available > 0;
                if (this.debugOn) {
                    log.debug((Object)("Concurrency Throttle : Access " + (canAccess ? "allowed" : "denied") + " :: " + available + " of available of " + concurrentAccessController.getLimit() + " connections"));
                }
                if (this.debugOn && !canAccess) {
                    log.debug((Object)"Concurrency Throttle : Access has currently been denied since allowed maximum concurrent access have exceeded");
                }
            } else if (messageContext.getFLOW() == 2) {
                int available = concurrentAccessController.incrementAndGet();
                if (this.debugOn) {
                    log.debug((Object)("Concurrency Throttle : Connection returned :: " + available + " of available of " + concurrentAccessController.getLimit() + " connections"));
                }
            }
        }
        return canAccess;
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        try {
            Throttle throttle = this.loadThrottle(msgContext, this.getThrottleType());
            if (throttle != null) {
                this.process(throttle, msgContext);
            }
        }
        catch (ThrottleException e) {
            log.error((Object)e.getMessage());
            throw new AxisFault(e.getMessage());
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

