/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle.module.utils;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.wso2.throttle.AccessInformation;
import org.wso2.throttle.module.utils.impl.DummyHandler;

public class StatCollector {
    private Map statsPerUser = new ConcurrentHashMap();
    private Map statsPerDomain = new ConcurrentHashMap();
    private Map statsPerIP = new ConcurrentHashMap();
    private AtomicLong stTime_User = new AtomicLong(-1L);
    private AtomicLong stTime_IP = new AtomicLong(-1L);
    private AtomicLong stTime_DOMAIN = new AtomicLong(-1L);
    private long startTime = System.nanoTime();
    public static long statCollectionPeriod = 0L;
    public static long statDisplayWindow = 0L;
    private static volatile StatCollector instance = null;
    public static boolean enableStatCollection = false;

    private StatCollector() {
    }

    private void storeStats(AccessInformation accessInfo, String callerID, int throttleType) {
        long timeStamp = System.nanoTime();
        System.out.println(timeStamp);
        if (1 == throttleType) {
            this.stTime_DOMAIN.compareAndSet(-1L, timeStamp);
            this.statsPerDomain.put(new Long(timeStamp), new StatDO(accessInfo.isAccessAllowed(), callerID, new Long(timeStamp)));
        } else if (0 == throttleType) {
            this.stTime_IP.compareAndSet(-1L, timeStamp);
            this.statsPerIP.put(new Long(timeStamp), new StatDO(accessInfo.isAccessAllowed(), callerID, new Long(timeStamp)));
        } else if (2 == throttleType) {
            this.stTime_User.compareAndSet(-1L, timeStamp);
            this.statsPerUser.put(new Long(timeStamp), new StatDO(accessInfo.isAccessAllowed(), callerID, new Long(timeStamp)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatCollector getInstance() {
        if (instance != null) return instance;
        Class<StatCollector> clazz = StatCollector.class;
        synchronized (StatCollector.class) {
            if (instance != null) return instance;
            instance = new StatCollector();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void setStatCollectionPeriod(long period) {
        statCollectionPeriod = period;
    }

    public static void setStatDisplayWindow(long period) {
        statDisplayWindow = period;
    }

    public static void collect(AccessInformation accessInfo, String callerID, int type) {
        if (!enableStatCollection) {
            return;
        }
        StatCollector.getInstance().storeStats(accessInfo, callerID, type);
    }

    private void flushAll() {
        this.statsPerDomain.clear();
        this.statsPerUser.clear();
        this.statsPerIP.clear();
        this.stTime_User = new AtomicLong(-1L);
        this.stTime_IP = new AtomicLong(-1L);
        this.stTime_DOMAIN = new AtomicLong(-1L);
        statCollectionPeriod = 0L;
        statDisplayWindow = 0L;
        this.startTime = 0L;
    }

    public static void flushStats() {
        StatCollector.getInstance().flushAll();
    }

    public static void displayStats(int throttleType) {
        StatCollector collector = StatCollector.getInstance();
        Map sortedMap = null;
        if (1 == throttleType) {
            System.out.println("Start Time : Domain Base Throttling ::" + collector.stTime_DOMAIN);
            sortedMap = StatCollector.sortByComparator(collector.statsPerDomain);
        } else if (0 == throttleType) {
            System.out.println("Start Time : IP Base Throttling ::" + collector.stTime_IP);
            sortedMap = StatCollector.sortByComparator(collector.statsPerIP);
        } else if (2 == throttleType) {
            System.out.println("Start Time : Role Base Throttling ::" + collector.stTime_User);
            sortedMap = StatCollector.sortByComparator(collector.statsPerUser);
        }
        Set set = sortedMap.entrySet();
        Iterator iterator = set.iterator();
        String prevCallerID = null;
        boolean prevAccessState = false;
        Long phaseStartTimestamp = null;
        Long phaseEndTimestamp = null;
        Long prevTimestamp = null;
        String callerID = null;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Long timestamp = (Long)entry.getKey();
            callerID = ((StatDO)entry.getValue()).getCallerID();
            boolean currAccessState = ((StatDO)entry.getValue()).isAccessAllowed();
            if (prevCallerID == null || callerID.equals(prevCallerID)) {
                if (prevCallerID != null && prevAccessState != currAccessState) {
                    phaseEndTimestamp = prevTimestamp;
                    System.out.println("Access Phase change for :" + callerID + "  duration of this phase :" + (double)(phaseEndTimestamp - phaseStartTimestamp) / 1000.0 + " ms");
                    phaseStartTimestamp = timestamp;
                } else if (phaseStartTimestamp == null) {
                    phaseStartTimestamp = timestamp;
                }
            } else {
                phaseStartTimestamp = timestamp;
            }
            prevCallerID = callerID;
            prevAccessState = currAccessState;
            prevTimestamp = timestamp;
        }
        for (Map.Entry entry : set) {
            System.out.println("Timestamp : " + entry.getKey() + " CallerID : " + ((StatDO)entry.getValue()).getCallerID() + " Role : " + DummyHandler.apiKey2roleMap.get(((StatDO)entry.getValue()).getCallerID()) + (((StatDO)entry.getValue()).isAccessAllowed() ? " --> Allowed" : "--> Denied"));
        }
    }

    private static Map sortByComparator(Map unsortMap) {
        LinkedList list = new LinkedList(unsortMap.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Comparable)((Map.Entry)o1).getValue()).compareTo(((Map.Entry)o2).getValue());
            }
        });
        LinkedHashMap sortedMap = new LinkedHashMap();
        for (Map.Entry entry : list) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

    public static void main(String[] args) {
        AccessInformation acAllwd = new AccessInformation();
        acAllwd.setAccessAllowed(true);
        AccessInformation acDenied = new AccessInformation();
        acDenied.setAccessAllowed(false);
        StatCollector.collect(acAllwd, "nq21LN39VlKe6OezcOndBx", 2);
        StatCollector.collect(acAllwd, "nq21LN39VlKe6OezcOndBx", 2);
        StatCollector.collect(acAllwd, "nq21LN39VlKe6OezcOndBx", 2);
        StatCollector.collect(acAllwd, "nq21LN39VlKe6OezcOndBx", 2);
        StatCollector.collect(acAllwd, "asdadsadg33332424Gasdad", 2);
        StatCollector.collect(acAllwd, "asdadsadg33332424Gasdad", 2);
        StatCollector.collect(acAllwd, "asdadsadg33332424Gasdad", 2);
        StatCollector.collect(acAllwd, "asdadsadg33332424Gasdad", 2);
        StatCollector.collect(acDenied, "nq21LN39VlKe6OezcOndBx", 2);
        StatCollector.collect(acDenied, "nq21LN39VlKe6OezcOndBx", 2);
        StatCollector.collect(acDenied, "asdadsadg33332424Gasdad", 2);
        StatCollector.collect(acDenied, "asdadsadg33332424Gasdad", 2);
        StatCollector.collect(acAllwd, "asdadsadg33332424Gasdad", 2);
        StatCollector.displayStats(2);
    }

    private class StatDO
    implements Comparable {
        private boolean accessAllowed = false;
        private String callerID = "";
        private Long timestamp;

        public StatDO(boolean accessAllowed, String callerID, Long timestamp) {
            this.accessAllowed = accessAllowed;
            this.callerID = callerID;
            this.timestamp = timestamp;
        }

        public boolean isAccessAllowed() {
            return this.accessAllowed;
        }

        public String getCallerID() {
            return this.callerID;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public int compareTo(Object o) {
            int result = 0;
            result = this.callerID.compareTo(((StatDO)o).getCallerID());
            if (result != 0) {
                return result;
            }
            return this.timestamp.compareTo(((StatDO)o).getTimestamp());
        }
    }
}

