/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.ServerConfigurationException;

public class ServerConfiguration {
    public static final String AXIS2_CONFIG_REPO_LOCATION = "Axis2Config.RepositoryLocation";
    public static final String HTTP_PORT = "HTTP.Port";
    public static final String COMMAND_LISTENER_PORT = "CommandListener.Port";
    private static Log log = LogFactory.getLog((Class)ServerConfiguration.class);
    private OMElement documentElement;
    private Map configuration = new HashMap();
    private static ServerConfiguration instance = new ServerConfiguration();

    public static ServerConfiguration getInstance() {
        return instance;
    }

    private ServerConfiguration() {
    }

    public synchronized void init(InputStream xmlInputStream) throws ServerConfigurationException {
        try {
            this.documentElement = new StAXOMBuilder(xmlInputStream).getDocumentElement();
        }
        catch (XMLStreamException e) {
            log.fatal((Object)"Problem in parsing the configuration file ", (Throwable)e);
            throw new ServerConfigurationException(e);
        }
        Stack nameStack = new Stack();
        this.readChildElements(this.documentElement, nameStack);
    }

    public synchronized void init(String configurationXMLLocation) throws ServerConfigurationException {
        InputStream xmlInputStream;
        if (configurationXMLLocation == null) {
            configurationXMLLocation = "conf/server.xml";
        }
        try {
            URL urlXMLLocation = new URL(configurationXMLLocation);
            xmlInputStream = urlXMLLocation.openStream();
        }
        catch (MalformedURLException e) {
            File f = new File(configurationXMLLocation);
            try {
                xmlInputStream = new FileInputStream(f);
            }
            catch (FileNotFoundException e1) {
                ClassLoader cl = ServerConfiguration.class.getClassLoader();
                xmlInputStream = cl.getResourceAsStream(configurationXMLLocation);
                if (xmlInputStream == null) {
                    log.fatal((Object)("Configuration File cannot be loaded from " + configurationXMLLocation), (Throwable)e1);
                    throw new ServerConfigurationException(e1);
                }
            }
        }
        catch (IOException e) {
            log.fatal((Object)("Configuration File cannot be loaded from " + configurationXMLLocation), (Throwable)e);
            throw new ServerConfigurationException(e);
        }
        this.init(xmlInputStream);
    }

    private void readChildElements(OMElement serverConfig, Stack nameStack) {
        Iterator childElements = serverConfig.getChildElements();
        while (childElements.hasNext()) {
            OMElement element = (OMElement)childElements.next();
            nameStack.push(element.getLocalName());
            if (this.elementHasText(element)) {
                String key = this.getKey(nameStack);
                Object currentObject = this.configuration.get(key);
                String value = this.replaceSystemProperty(element.getText());
                if (currentObject == null) {
                    this.configuration.put(key, value);
                } else if (currentObject instanceof ArrayList) {
                    ArrayList list = (ArrayList)currentObject;
                    if (!list.contains(value)) {
                        list.add(value);
                    }
                } else if (!value.equals(currentObject)) {
                    ArrayList<Object> arrayList = new ArrayList<Object>(2);
                    arrayList.add(currentObject);
                    arrayList.add(value);
                    this.configuration.put(key, arrayList);
                }
            }
            this.readChildElements(element, nameStack);
            nameStack.pop();
        }
    }

    private String replaceSystemProperty(String text) {
        String sysProp;
        String propValue;
        int indexOfClosingBrace;
        int indexOfStartingChars = text.indexOf("${");
        if (indexOfStartingChars != -1 && (indexOfClosingBrace = text.indexOf("}")) != -1 && (propValue = System.getProperty(sysProp = text.substring(indexOfStartingChars + 2, indexOfClosingBrace))) != null) {
            text = text.substring(0, indexOfStartingChars) + propValue + text.substring(indexOfClosingBrace + 1);
        }
        return text;
    }

    public void setConfigurationProperty(String key, String value) {
        this.configuration.put(key, value);
        StringTokenizer tokenizer = new StringTokenizer(key, ".");
        OMElement ele = this.documentElement;
        String token = "";
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (ele == null) break;
            ele = ele.getFirstChildWithName(new QName("", token, ""));
        }
        if (ele != null) {
            ele.getFirstOMChild().detach();
            ele.setText(token);
        }
    }

    private String getKey(Stack nameStack) {
        StringBuffer key = new StringBuffer();
        for (int i = 0; i < nameStack.size(); ++i) {
            String name = (String)nameStack.elementAt(i);
            key.append(name).append(".");
        }
        key.deleteCharAt(key.lastIndexOf("."));
        return key.toString();
    }

    private boolean elementHasText(OMElement element) {
        String text = element.getText();
        return text != null && text.trim().length() != 0;
    }

    public String getFirstProperty(String key) {
        Object value = this.configuration.get(key);
        if (value instanceof ArrayList) {
            return (String)((ArrayList)value).get(0);
        }
        return (String)value;
    }

    public String[] getProperties(String key) {
        Object values = this.configuration.get(key);
        String[] properties = new String[]{};
        if (values instanceof ArrayList) {
            properties = ((ArrayList)values).toArray(new String[((ArrayList)values).size()]);
        } else if (values instanceof String) {
            properties = new String[]{(String)values};
        }
        return properties;
    }

    public OMElement getDocumentElement() {
        return this.documentElement;
    }
}

