/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.utils.security;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import javax.crypto.Cipher;
import org.apache.axis2.util.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.wso2.utils.i18n.Messages;
import org.wso2.utils.security.CryptoException;

public class CryptoUtil {
    private String storeLocation;
    private String storePass;
    private String keyAlias;
    private String keyPass;
    private String storeType;

    public CryptoUtil(String storeLocation, String storePass, String keyAlias, String keyPass, String storeType) {
        this.storeLocation = storeLocation;
        this.storePass = storePass;
        this.keyAlias = keyAlias;
        this.keyPass = keyPass;
        this.storeType = storeType;
    }

    public byte[] encrypt(byte[] plainTextBytes) throws CryptoException {
        try {
            KeyStore keyStore = KeyStore.getInstance(this.storeType != null ? this.storeType : "PKCS12");
            FileInputStream fis = new FileInputStream(this.storeLocation);
            keyStore.load(fis, this.storePass.toCharArray());
            Certificate[] certs = keyStore.getCertificateChain(this.keyAlias);
            Cipher cipher = Cipher.getInstance("RSA", "BC");
            cipher.init(1, certs[0]);
            return cipher.doFinal(plainTextBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CryptoException(Messages.getMessage("erorDuringEncryption"), e);
        }
    }

    public String encryptAndBase64Encode(byte[] plainText) throws CryptoException {
        return Base64.encode((byte[])this.encrypt(plainText));
    }

    public byte[] decrypt(byte[] cipherTextBytes) throws CryptoException {
        try {
            KeyStore keyStore = KeyStore.getInstance(this.storeType != null ? this.storeType : "JKS");
            FileInputStream fis = new FileInputStream(this.storeLocation);
            keyStore.load(fis, this.storePass.toCharArray());
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(this.keyAlias, this.keyPass.toCharArray());
            Cipher cipher = Cipher.getInstance("RSA", "BC");
            cipher.init(2, privateKey);
            return cipher.doFinal(cipherTextBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CryptoException("errorDuringDecryption", e);
        }
    }

    public byte[] base64DecodeAndDecrypt(String base64CipherText) throws CryptoException {
        return this.decrypt(Base64.decode((String)base64CipherText));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

