/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.utils.transport;

import java.net.SocketException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.TransportListener;
import org.wso2.utils.NetworkUtils;
import org.wso2.utils.SessionContextUtil;

public abstract class AbstractTransportListener
implements TransportListener {
    protected ConfigurationContext configurationContext;
    protected int port;
    protected int proxyPort = -1;
    protected TransportInDescription tInDescription;

    public void init(ConfigurationContext configContext, TransportInDescription transportIn) throws AxisFault {
        this.configurationContext = configContext;
        this.port = Integer.parseInt(transportIn.getParameter("port").getValue().toString().trim());
        this.tInDescription = transportIn;
        Parameter proxyParam = transportIn.getParameter("proxyPort");
        if (proxyParam != null) {
            this.proxyPort = Integer.parseInt(proxyParam.getValue().toString().trim());
        }
    }

    public void stop() throws AxisFault {
    }

    public EndpointReference getEPR(String protocol, String serviceName, String ip) throws AxisFault {
        if (this.configurationContext == null) {
            return null;
        }
        String serviceContextPath = this.configurationContext.getServiceContextPath();
        if (serviceContextPath == null) {
            throw new AxisFault("couldn't find service path");
        }
        return this.genEpr(protocol, ip, serviceContextPath, serviceName);
    }

    public EndpointReference getEPR(String protocol, String serviceName, String ip, String contextPath) throws AxisFault {
        if (this.configurationContext == null) {
            return null;
        }
        return this.genEpr(protocol, ip, this.configurationContext.getServiceContextPath(), serviceName);
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        return SessionContextUtil.createSessionContext(messageContext);
    }

    public void destroy() {
        this.configurationContext = null;
    }

    protected EndpointReference genEpr(String protocol, String ip, String serviceContextPath, String serviceName) throws AxisFault {
        try {
            if (ip == null) {
                ip = NetworkUtils.getLocalHostname();
            }
            String tmp = protocol + "://" + ip;
            if (this.proxyPort == 80 || this.proxyPort == 443) {
                tmp = tmp + serviceContextPath + "/" + serviceName;
                return new EndpointReference(tmp);
            }
            if (this.proxyPort > -1) {
                tmp = tmp + ":" + this.proxyPort + serviceContextPath + "/" + serviceName;
                return new EndpointReference(tmp);
            }
            tmp = tmp + ":" + this.port + serviceContextPath + "/" + serviceName;
            return new EndpointReference(tmp);
        }
        catch (SocketException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }
}

