/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.utils.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.log.Log;
import org.mortbay.util.IO;

public class FaviconProvider {
    private long faviconModified = System.currentTimeMillis() / 1000L * 1000L;
    private byte[] favicon;
    private boolean serveIcon = true;

    public void setFavIconFromResource(String relativePath) throws IOException {
        try {
            URL fav = this.getClass().getClassLoader().getResource(relativePath);
            if (fav != null) {
                this.favicon = IO.readBytes((InputStream)fav.openStream());
            }
        }
        catch (IOException e) {
            Log.warn((Throwable)e);
            throw e;
        }
    }

    public boolean provideFavIcon(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String method = request.getMethod();
        if (this.serveIcon && this.favicon != null && method.equals("GET") && request.getRequestURI().equals("/favicon.ico")) {
            if (request.getDateHeader("If-Modified-Since") == this.faviconModified) {
                response.setStatus(304);
            } else {
                response.setStatus(200);
                response.setContentType("image/x-icon");
                response.setContentLength(this.favicon.length);
                response.setDateHeader("Last-Modified", this.faviconModified);
                response.getOutputStream().write(this.favicon);
            }
            return true;
        }
        return false;
    }
}

