/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.utils.transport.http;

import java.net.SocketException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.TransportListener;
import org.wso2.utils.NetworkUtils;
import org.wso2.utils.SessionContextUtil;

public class GenericHttpsTransportListener
implements TransportListener {
    private ConfigurationContext configurationContext;
    private int port = -1;

    public GenericHttpsTransportListener() {
    }

    public GenericHttpsTransportListener(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public void init(ConfigurationContext configContext, TransportInDescription transportIn) throws AxisFault {
        this.configurationContext = configContext;
        Parameter portParam = transportIn.getParameter("port");
        if (portParam != null) {
            this.port = Integer.parseInt(portParam.getValue().toString().trim());
        }
    }

    public void start() throws AxisFault {
    }

    public void stop() throws AxisFault {
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        String serviceContextPath = this.configurationContext.getServiceContextPath();
        if (serviceContextPath == null) {
            throw new AxisFault("service Context path cannot be null");
        }
        return new EndpointReference("https://" + ip + ":" + this.port + serviceContextPath + "/" + serviceName);
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        try {
            ip = NetworkUtils.getLocalHostname();
        }
        catch (SocketException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        return new EndpointReference[]{this.getEPRForService(serviceName, ip)};
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        return SessionContextUtil.createSessionContext(messageContext);
    }

    public void destroy() {
        this.configurationContext = null;
    }
}

