/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.utils.transport.http;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mortbay.jetty.Server;

public final class HttpServerManager {
    private static Map serverMap = new HashMap();

    public static Server getServer(String serverKey) {
        Server server;
        Object obj = serverMap.get(serverKey);
        if (obj == null) {
            server = new Server();
            serverMap.put(serverKey, server);
        } else {
            server = (Server)obj;
        }
        return server;
    }

    public static void startServer(String serverKey) throws Exception {
        Server server = HttpServerManager.getServer(serverKey);
        if (!server.isStarted()) {
            server.start();
        }
    }

    public static void stopServer(String serverKey) throws Exception {
        Server server = HttpServerManager.getServer(serverKey);
        server.stop();
        serverMap.remove(serverKey);
    }

    public static void stopAllServers() throws Exception {
        Iterator iter = serverMap.values().iterator();
        while (iter.hasNext()) {
            Server httpServer = (Server)iter.next();
            httpServer.stop();
        }
        serverMap.clear();
    }
}

