/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.utils.xml;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.xml.StringUtils;

public class XMLPrettyPrinter {
    private InputStream in;
    private boolean xmlFormat;
    private boolean numericEnc;
    private boolean done = false;
    private String encoding = "UTF-8";
    private static Log log = LogFactory.getLog((Class)XMLPrettyPrinter.class);

    public XMLPrettyPrinter(InputStream in, boolean format, boolean numeric, String encoding) {
        this.in = in;
        this.xmlFormat = format;
        this.numericEnc = numeric;
        if (encoding != null) {
            this.encoding = encoding;
        }
    }

    public XMLPrettyPrinter(InputStream in) {
        this(in, true, false, null);
    }

    public XMLPrettyPrinter(InputStream in, String encoding) {
        this(in, true, false, encoding);
    }

    public String xmlFormat() {
        StringBuffer out;
        block24: {
            out = new StringBuffer();
            try {
                byte[] buffer = new byte[4096];
                byte[] tmpbuffer = new byte[8192];
                String message = null;
                int saved = 0;
                boolean reqSaved = false;
                int tabWidth = 3;
                boolean atMargin = true;
                int thisIndent = -1;
                int nextIndent = -1;
                int previousIndent = -1;
                while (!this.done) {
                    int len = buffer.length;
                    if (len == 0) {
                        len = buffer.length;
                    }
                    if (saved + len > buffer.length) {
                        len = buffer.length - saved;
                    }
                    int len1 = 0;
                    while (len1 == 0) {
                        try {
                            len1 = this.in.read(buffer, saved, len);
                        }
                        catch (Exception ex) {
                            if (!this.done || saved != 0) {
                                len1 = -1;
                                break;
                            }
                            break block24;
                        }
                    }
                    if ((len = len1) != -1 || saved != 0) {
                        int i;
                        if (len == -1) {
                            this.done = true;
                        }
                        if (!this.xmlFormat) continue;
                        boolean inXML = false;
                        int bufferLen = saved;
                        if (len != -1) {
                            bufferLen += len;
                        }
                        int i2 = 0;
                        saved = 0;
                        for (int i1 = 0; i1 < bufferLen; ++i1) {
                            if (len != -1 && i1 + 1 == bufferLen) {
                                saved = 1;
                                break;
                            }
                            thisIndent = -1;
                            if (buffer[i1] == 60 && buffer[i1 + 1] != 47) {
                                previousIndent = nextIndent++;
                                thisIndent = nextIndent;
                                inXML = true;
                            }
                            if (buffer[i1] == 60 && buffer[i1 + 1] == 47) {
                                if (previousIndent > nextIndent) {
                                    thisIndent = nextIndent;
                                }
                                --nextIndent;
                                inXML = true;
                            }
                            if (buffer[i1] == 47 && buffer[i1 + 1] == 62) {
                                --nextIndent;
                                inXML = true;
                            }
                            if (thisIndent != -1) {
                                if (thisIndent > 0) {
                                    tmpbuffer[i2++] = 10;
                                }
                                for (i = tabWidth * thisIndent; i > 0; --i) {
                                    tmpbuffer[i2++] = 32;
                                }
                            }
                            boolean bl = atMargin = buffer[i1] == 10 || buffer[i1] == 13;
                            if (inXML && atMargin) continue;
                            tmpbuffer[i2++] = buffer[i1];
                        }
                        message = new String(tmpbuffer, 0, i2, this.encoding);
                        if (this.numericEnc) {
                            out.append(StringUtils.escapeNumericChar(message));
                        } else {
                            out.append(StringUtils.unescapeNumericChar(message));
                        }
                        for (i = 0; i < saved; ++i) {
                            buffer[i] = buffer[bufferLen - saved + i];
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                log.error((Object)t);
            }
        }
        return out.toString();
    }
}

