/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.javascript.xmlimpl;

import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.wso2.javascript.xmlimpl.AxiomNodeMatcher;
import org.wso2.javascript.xmlimpl.Namespace;
import org.wso2.javascript.xmlimpl.XML;
import org.wso2.javascript.xmlimpl.XMLLibImpl;
import org.wso2.javascript.xmlimpl.XMLList;
import org.wso2.javascript.xmlimpl.XMLName;

public class AxiomNode {
    private OMNode omNode;
    private OMAttribute omAttribute;
    private boolean isOMNode = false;
    private boolean isOMAttribute = false;
    private boolean isOMElement = false;
    private boolean isOMComment = false;
    private boolean isOMText = false;
    private boolean isOMPI = false;
    private AxiomNode parentNode;
    XML xmlObject;
    private OMFactory omFactory = null;
    private AxiomNodeMatcher nodeMatcher = null;
    private static AxiomNodeComparator axiomNodeComparator = new AxiomNodeComparator();
    public static final int APPEND_CHILD = 1;
    public static final int PREPEND_CHILD = 2;
    public static final String UNSUPPORTED_OP = "Operation is supported only for XML Elements";
    public static final String INVALID_CHILD_INDEX = "Invalid child index";
    public static final String NODE_MATCHER = "NodeMatcher";
    public static final String DESCENDENT_CHILDREN_MATCHER = "DescendantChildrenMatcher";
    public static final String DESCENDEN_ATTRIBUTE_MATCHER = "DescendantAttributeMatcher";
    public static final HashMap matcherMap = new HashMap(3);

    private AxiomNode(Object value) {
        if (value instanceof OMNode) {
            this.omNode = (OMNode)value;
            this.isOMNode = true;
            if (this.omNode instanceof OMElement) {
                this.isOMElement = true;
            } else if (this.omNode instanceof OMText) {
                this.isOMText = true;
            } else if (this.omNode instanceof OMComment) {
                this.isOMComment = true;
            } else if (this.omNode instanceof OMProcessingInstruction) {
                this.isOMPI = true;
            }
        } else if (value instanceof OMAttribute) {
            this.omAttribute = (OMAttribute)value;
            this.isOMAttribute = true;
        }
    }

    public void addInScopeNamespace(Namespace value) {
        if (!this.isElement()) {
            throw ScriptRuntime.typeError((String)UNSUPPORTED_OP);
        }
        OMElement element = this.getOMElement();
        if (value != null) {
            OMNamespace ns = this.getOMFactory().createOMNamespace(value.uri(), value.prefix());
            element.declareNamespace(ns);
        }
    }

    private void addToList(AxiomNode tmpAxiomNode, XMLList xmlList) {
        if (!tmpAxiomNode.isText() || tmpAxiomNode.getOMText().getTextCharacters()[0] != '\n') {
            xmlList.addAxiomNode(tmpAxiomNode);
        }
    }

    public AxiomNode childAt(int index) {
        if (!this.isOMElement) {
            throw ScriptRuntime.typeError((String)UNSUPPORTED_OP);
        }
        if (index < 0) {
            throw ScriptRuntime.typeError((String)INVALID_CHILD_INDEX);
        }
        int length = 0;
        Iterator iterator = this.getOMElement().getChildren();
        while (iterator.hasNext()) {
            OMNode result = (OMNode)iterator.next();
            if (result.getType() == 4 && ((OMText)result).getTextCharacters()[0] == '\n') {
                --length;
            }
            if (length == index) {
                return AxiomNode.buildAxiomNode(result, this);
            }
            ++length;
        }
        return null;
    }

    public OMNode cloneOMNode() {
        if (this.isOMElement) {
            return this.getOMElement().cloneOMElement();
        }
        if (this.isOMText) {
            return this.getOMFactory().createOMText(this.getOMText().getText());
        }
        if (this.isOMComment) {
            System.out.println("clonning comments is not implemented;");
        } else if (this.isOMPI) {
            System.out.println("Clonning PI is not implemented");
        }
        return null;
    }

    public boolean detach() {
        block5: {
            try {
                if (this.isOMNode) {
                    if (this.omNode.getParent() != null) {
                        this.omNode.detach();
                    }
                    break block5;
                }
                if (this.isOMAttribute) {
                    OMElement parentElement = this.getParentNode().getOMElement();
                    parentElement.removeAttribute(this.omAttribute);
                    break block5;
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public XMLList getChildElements(XMLName xmlName, XMLList xmlList) {
        block5: {
            if (!this.isElement()) {
                return null;
            }
            QName qname = new QName(xmlName.uri(), xmlName.localName());
            if (!this.isElement()) break block5;
            if (xmlName.localName().equals("*")) {
                Iterator iterator = this.getOMElement().getChildElements();
                while (iterator.hasNext()) {
                    xmlList.addAxiomNode(AxiomNode.buildAxiomNode(iterator.next(), this));
                }
            } else {
                Iterator iterator = this.getOMElement().getChildElements();
                while (iterator.hasNext()) {
                    AxiomNode tmpAxiomNode = AxiomNode.buildAxiomNode(iterator.next(), this);
                    if (!qname.equals(((OMElement)tmpAxiomNode.getOMNode()).getQName())) continue;
                    xmlList.addAxiomNode(tmpAxiomNode);
                }
            }
        }
        return xmlList;
    }

    public int getChildIndex() {
        int childIndex = -1;
        AxiomNode parentNode = this.getParentNode();
        if (parentNode == null || this.isAttribute()) {
            return childIndex;
        }
        if (parentNode.isElement()) {
            OMElement omElement = parentNode.getOMElement();
            Iterator iterator = omElement.getChildren();
            while (iterator.hasNext()) {
                OMNode omNode = (OMNode)iterator.next();
                if (omNode.getType() == 4 && AxiomNode.isNewlineCharacter((OMText)omNode)) continue;
                ++childIndex;
                if (omNode != this.getOMNode()) continue;
                break;
            }
            return childIndex;
        }
        return childIndex;
    }

    public XML getElemetFromText(XMLLibImpl lib, XMLName xmlName, String value) {
        OMElement omElement = this.getOMFactory().createOMElement(xmlName.localName(), xmlName.uri(), "");
        omElement.setText(value);
        XML xml = XML.toXML(lib, omElement.toString());
        return xml;
    }

    public Object[] getInScopeNamespace(XMLLibImpl lib) {
        ObjArray nsDeclarations = new ObjArray();
        OMElement omElement = this.getOMElement();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        while (omElement != null) {
            Iterator iterator = omElement.getAllDeclaredNamespaces();
            while (iterator.hasNext()) {
                OMNamespace ns = (OMNamespace)iterator.next();
                Namespace namespace = new Namespace(lib, ns.getPrefix(), ns.getNamespaceURI());
                if (nsMap.get(ns.getPrefix()) != null) continue;
                nsDeclarations.add((Object)namespace);
                nsMap.put(ns.getPrefix(), "IN");
            }
            if (!(omElement.getParent() instanceof OMDocument)) {
                omElement = (OMElement)omElement.getParent();
                continue;
            }
            omElement = null;
        }
        nsMap = null;
        return nsDeclarations.toArray();
    }

    public OMAttribute getOMAttribute() {
        return this.isAttribute() ? this.omAttribute : null;
    }

    public OMComment getOMComment() {
        return this.isOMComment ? (OMComment)this.omNode : null;
    }

    public OMElement getOMElement() {
        return this.isOMElement ? (OMElement)this.omNode : null;
    }

    public OMFactory getOMFactory() {
        this.omFactory = this.isOMAttribute ? this.omAttribute.getOMFactory() : (this.omNode != null ? this.omNode.getOMFactory() : OMAbstractFactory.getOMFactory());
        return this.omFactory;
    }

    public OMNode getOMNode() {
        return this.omNode;
    }

    public OMProcessingInstruction getOMProcessingInstruction() {
        return this.isProcessingInstruction() ? (OMProcessingInstruction)this.omNode : null;
    }

    public OMText getOMText() {
        return this.isOMText ? (OMText)this.omNode : null;
    }

    public AxiomNode getParentNode() {
        return this.parentNode;
    }

    public QName getQName() {
        QName qname = null;
        if (this.isText() || this.isComment()) {
            return null;
        }
        if (this.isElement()) {
            qname = this.getOMElement().getQName();
        } else if (this.isAttribute()) {
            qname = this.getOMAttribute().getQName();
        } else if (this.isProcessingInstruction()) {
            qname = null;
        }
        return qname;
    }

    public XML getXMLObject(XMLLibImpl lib) {
        if (this.xmlObject == null) {
            this.xmlObject = new XML(lib, this);
        }
        return this.xmlObject;
    }

    private void insertChild(AxiomNode nodeToInsert, int mode) {
        AxiomNode refNode;
        if (!this.isElement()) {
            return;
        }
        if (mode == 2 && (refNode = this.childAt(0)) != null) {
            this.insertChild(refNode, nodeToInsert, mode);
            return;
        }
        this.getOMElement().addChild(nodeToInsert.cloneOMNode());
    }

    public void insertChild(AxiomNode refNode, AxiomNode nodeToInsert, int mode) {
        if (refNode == null) {
            this.insertChild(nodeToInsert, mode);
        } else if (refNode.getOMNode() != null && nodeToInsert.getOMNode() != null) {
            switch (mode) {
                case 2: {
                    OMNode prevSibling = refNode.getOMNode().getPreviousOMSibling();
                    if (prevSibling == null) {
                        refNode.getOMElement().insertSiblingBefore(nodeToInsert.cloneOMNode());
                        nodeToInsert.getOMNode().insertSiblingAfter(refNode.getOMNode());
                        break;
                    }
                    prevSibling.insertSiblingAfter(nodeToInsert.cloneOMNode());
                    break;
                }
                default: {
                    refNode.getOMNode().insertSiblingAfter(nodeToInsert.cloneOMNode());
                }
            }
        }
    }

    void insertAttribute(XMLName xmlName, Object value) {
        String uri = xmlName.uri();
        String localName = xmlName.localName();
        if (uri == null || localName.equals("*")) {
            throw ScriptRuntime.typeError((String)"@* assignment not supported.");
        }
        String strValue = ScriptRuntime.toString((Object)value);
        if (this.isElement()) {
            OMElement omElement = this.getOMElement();
            OMNamespace omNamespace = omElement.getOMFactory().createOMNamespace(uri, "");
            OMAttribute at = omElement.getOMFactory().createOMAttribute(localName, omNamespace, strValue);
            omElement.addAttribute(at);
        }
    }

    public boolean isAttribute() {
        return this.isOMAttribute;
    }

    public boolean isComment() {
        return this.isOMComment;
    }

    public boolean isElement() {
        return this.isOMElement;
    }

    public boolean isNull() {
        return this.isOMAttribute || this.isOMNode;
    }

    public boolean isOMNode() {
        return this.isOMNode;
    }

    public boolean isProcessingInstruction() {
        return this.isOMPI;
    }

    public boolean isText() {
        return this.isOMText;
    }

    public XMLList matchNodes(XMLName xmlName, XMLList xmlList, int type) {
        if (!this.isElement()) {
            return null;
        }
        xmlList = xmlName.localName().equals("*") && xmlName.uri() == null ? this.nodeMatcher.matchAnyQName(this, xmlList, type) : (xmlName.localName().equals("*") ? this.nodeMatcher.matchAnyLocalName(this, xmlList, type, xmlName.uri()) : (xmlName.uri() == null || xmlName.uri().equals("") ? this.nodeMatcher.matchAnyNamespace(this, xmlList, type, xmlName.localName(), xmlName.uri()) : this.nodeMatcher.matchQName(this, xmlList, type, new QName(xmlName.uri(), xmlName.localName()))));
        return xmlList;
    }

    public void removeChild(AxiomNode axiomNode) {
        if (!this.isElement()) {
            throw ScriptRuntime.typeError((String)UNSUPPORTED_OP);
        }
        if (axiomNode.getOMNode() == null) {
            System.out.println(" remove Child null Omnode");
            return;
        }
        if (axiomNode.isAttribute()) {
            this.getOMElement().removeAttribute(axiomNode.getOMAttribute());
        } else if (axiomNode.getOMNode() != null) {
            axiomNode.detach();
        }
    }

    public void setNodeMatcher(String matcherName) {
        AxiomNodeMatcher nodeMatcher = (AxiomNodeMatcher)matcherMap.get(matcherName);
        if (nodeMatcher == null) {
            if (matcherName.equals(NODE_MATCHER)) {
                nodeMatcher = new NodeMatcher();
            } else if (matcherName.equals(DESCENDENT_CHILDREN_MATCHER)) {
                nodeMatcher = new DescendantChildrenMatcher();
            } else if (matcherName.equals(DESCENDEN_ATTRIBUTE_MATCHER)) {
                nodeMatcher = new DescendantAttributeMatcher();
            }
            matcherMap.put(matcherName, nodeMatcher);
        }
        this.nodeMatcher = nodeMatcher;
    }

    public void setParentNode(AxiomNode parentNode) {
        this.parentNode = parentNode;
    }

    static AxiomNode buildAxiomNode(Object value, AxiomNode parent) {
        AxiomNode axiomNode = new AxiomNode(value);
        if (parent != null && parent.isOMElement) {
            axiomNode.setParentNode(parent);
        }
        return axiomNode;
    }

    static boolean equivalentAxiomNode(AxiomNode refNode, AxiomNode targetNode) {
        return AxiomNodeComparator.isOMNodesEqual(refNode, targetNode);
    }

    static boolean isNewlineCharacter(OMText omText) {
        return omText.getTextCharacters()[0] == '\n';
    }

    private static class AxiomNodeComparator {
        private AxiomNodeComparator() {
        }

        public static boolean isOMNodesEqual(AxiomNode refNode, AxiomNode targetNode) {
            boolean result = false;
            if (refNode.isOMAttribute && targetNode.isOMAttribute) {
                result = AxiomNodeComparator.isOMAttributesEqual(refNode.getOMAttribute(), targetNode.getOMAttribute());
            } else if (refNode.isOMElement && targetNode.isOMElement) {
                result = AxiomNodeComparator.isOMElementsEqual(refNode.getOMElement(), targetNode.getOMElement());
            } else if (refNode.isOMText && targetNode.isOMText) {
                result = AxiomNodeComparator.isOMTextsEqual(refNode.getOMText(), targetNode.getOMText());
            } else if (refNode.isOMPI && targetNode.isOMPI) {
                result = AxiomNodeComparator.isOMPIsEqual(refNode.getOMProcessingInstruction(), targetNode.getOMProcessingInstruction());
            } else if (refNode.isOMComment && targetNode.isOMComment) {
                result = AxiomNodeComparator.isOMCommentsEqual(refNode.getOMComment(), targetNode.getOMComment());
            }
            return result;
        }

        private static boolean isOMAttributesEqual(OMAttribute refAttr, OMAttribute targetAttr) {
            return targetAttr.getAttributeValue().equals(refAttr.getAttributeValue());
        }

        private static boolean isOMTextsEqual(OMText refText, OMText targetText) {
            return targetText.getText().equals(refText.getText());
        }

        private static boolean isOMPIsEqual(OMProcessingInstruction refPI, OMProcessingInstruction targetPI) {
            return targetPI.getValue().equals(refPI.getValue());
        }

        private static boolean isOMCommentsEqual(OMComment refComment, OMComment targetComment) {
            return targetComment.getValue().equals(refComment.getValue());
        }

        private static boolean isOMElementsEqual(OMElement refElement, OMElement targetElement) {
            boolean result;
            block7: {
                result = false;
                if (!AxiomNodeComparator.isQNamesEqual(refElement.getQName(), targetElement.getQName())) {
                    return false;
                }
                if (!AxiomNodeComparator.isAttributeListEqual(refElement, targetElement)) {
                    return false;
                }
                Iterator refChildIterator = refElement.getChildren();
                Iterator targetChildIterator = targetElement.getChildren();
                OMNode targetChildNode = null;
                do {
                    OMNode refChildNode = AxiomNodeComparator.getValidNode(refChildIterator);
                    targetChildNode = AxiomNodeComparator.getValidNode(targetChildIterator);
                    if (refChildNode != null && targetChildNode != null) {
                        if (refChildNode.getType() == 1 && targetChildNode.getType() == 1) {
                            result = AxiomNodeComparator.isOMElementsEqual((OMElement)refChildNode, (OMElement)targetChildNode);
                            continue;
                        }
                        if (refChildNode.getType() == 4 && targetChildNode.getType() == 4) {
                            result = AxiomNodeComparator.isOMTextsEqual((OMText)refChildNode, (OMText)targetChildNode);
                            continue;
                        }
                        if (refChildNode.getType() == 5 && targetChildNode.getType() == 5) {
                            result = AxiomNodeComparator.isOMCommentsEqual((OMComment)refChildNode, (OMComment)targetChildNode);
                            continue;
                        }
                        if (refChildNode.getType() != 3 || targetChildNode.getType() != 3) continue;
                        result = AxiomNodeComparator.isOMPIsEqual((OMProcessingInstruction)refChildNode, (OMProcessingInstruction)targetChildNode);
                        continue;
                    }
                    if (refChildNode == null && targetChildNode == null) break block7;
                    result = false;
                } while (result);
                return false;
            }
            result = true;
            return true;
        }

        private static boolean isAttributeListEqual(OMElement refElement, OMElement targetElement) {
            boolean result = false;
            HashMap refAttrMap = AxiomNodeComparator.getAttributeMap(refElement);
            HashMap targetAttrMap = AxiomNodeComparator.getAttributeMap(targetElement);
            if (refAttrMap.size() == 0 && targetAttrMap.size() == 0) {
                return true;
            }
            if (refAttrMap.size() != targetAttrMap.size()) {
                return false;
            }
            Iterator keyIterator = refAttrMap.keySet().iterator();
            while (keyIterator.hasNext()) {
                String attrValue = (String)keyIterator.next();
                if (targetAttrMap.containsKey(attrValue)) {
                    QName targetQName;
                    QName refQName = (QName)refAttrMap.get(attrValue);
                    if (AxiomNodeComparator.isQNamesEqual(refQName, targetQName = (QName)targetAttrMap.get(attrValue))) {
                        result = true;
                        continue;
                    }
                    return false;
                }
                return false;
            }
            return result;
        }

        private static HashMap getAttributeMap(OMElement element) {
            HashMap<String, QName> attrMap = new HashMap<String, QName>();
            Iterator attrIterator = element.getAllAttributes();
            while (attrIterator.hasNext()) {
                OMAttribute attribute = (OMAttribute)attrIterator.next();
                attrMap.put(attribute.getAttributeValue(), attribute.getQName());
            }
            return attrMap;
        }

        private static boolean isQNamesEqual(QName refQName, QName targetQName) {
            boolean result = false;
            return refQName.getNamespaceURI().equals(targetQName.getNamespaceURI()) && refQName.getLocalPart().equals(targetQName.getLocalPart()) || result;
        }

        private static OMNode getValidNode(Iterator iterator) {
            while (iterator.hasNext()) {
                OMNode validNode = (OMNode)iterator.next();
                if (validNode.getType() == 4 && AxiomNode.isNewlineCharacter((OMText)validNode)) continue;
                return validNode;
            }
            return null;
        }
    }

    private static class DescendantAttributeMatcher
    implements AxiomNodeMatcher {
        private DescendantAttributeMatcher() {
        }

        public XMLList matchAnyQName(AxiomNode thisAxiomNode, XMLList xmlList, int type) {
            this.matchAnyQNameRec(xmlList, thisAxiomNode);
            return xmlList;
        }

        public XMLList matchAnyLocalName(AxiomNode thisAxiomNode, XMLList xmlList, int type, String namespaceURI) {
            this.matchAnyLocalNameRec(xmlList, namespaceURI, thisAxiomNode);
            return xmlList;
        }

        public XMLList matchAnyNamespace(AxiomNode thisAxiomNode, XMLList xmlList, int type, String localName, String namespaceURI) {
            this.matchAnyNamespaceRec(xmlList, localName, namespaceURI, thisAxiomNode);
            return xmlList;
        }

        public XMLList matchQName(AxiomNode thisAxiomNode, XMLList xmlList, int type, QName qname) {
            this.matchQNameRec(xmlList, qname, thisAxiomNode);
            return xmlList;
        }

        private void matchAnyQNameRec(XMLList xmlList, AxiomNode axiomNode) {
            AxiomNode tmpAxiomNode;
            Iterator iteratoAtr = axiomNode.getOMElement().getAllAttributes();
            while (iteratoAtr.hasNext()) {
                tmpAxiomNode = AxiomNode.buildAxiomNode(iteratoAtr.next(), axiomNode);
                xmlList.addAxiomNode(tmpAxiomNode);
            }
            Iterator iteratorEle = axiomNode.getOMElement().getChildElements();
            while (iteratorEle.hasNext()) {
                tmpAxiomNode = AxiomNode.buildAxiomNode(iteratorEle.next(), axiomNode);
                this.matchAnyQNameRec(xmlList, tmpAxiomNode);
            }
        }

        private void matchAnyLocalNameRec(XMLList xmlList, String namespaceURI, AxiomNode axiomNode) {
            AxiomNode tmpAxiomNode;
            Iterator iterator = axiomNode.getOMElement().getAllAttributes();
            while (iterator.hasNext()) {
                tmpAxiomNode = AxiomNode.buildAxiomNode(iterator.next(), axiomNode);
                QName qname = tmpAxiomNode.getQName();
                if (qname == null || !qname.getNamespaceURI().equals(namespaceURI)) continue;
                xmlList.addAxiomNode(tmpAxiomNode);
            }
            Iterator iteratorEle = axiomNode.getOMElement().getChildElements();
            while (iteratorEle.hasNext()) {
                tmpAxiomNode = AxiomNode.buildAxiomNode(iteratorEle.next(), axiomNode);
                this.matchAnyLocalNameRec(xmlList, namespaceURI, tmpAxiomNode);
            }
        }

        private void matchAnyNamespaceRec(XMLList xmlList, String localName, String namespaceURI, AxiomNode axiomNode) {
            AxiomNode tmpAxiomNode;
            Iterator iterator = axiomNode.getOMElement().getAllAttributes();
            while (iterator.hasNext()) {
                tmpAxiomNode = AxiomNode.buildAxiomNode(iterator.next(), axiomNode);
                QName qname = tmpAxiomNode.getQName();
                if (qname == null || !localName.equals(qname.getLocalPart())) continue;
                if (namespaceURI == null) {
                    xmlList.addAxiomNode(tmpAxiomNode);
                    continue;
                }
                if (!qname.getNamespaceURI().equals(namespaceURI)) continue;
                xmlList.addAxiomNode(tmpAxiomNode);
            }
            Iterator iteratorEle = axiomNode.getOMElement().getChildElements();
            while (iteratorEle.hasNext()) {
                tmpAxiomNode = AxiomNode.buildAxiomNode(iteratorEle.next(), axiomNode);
                this.matchAnyNamespaceRec(xmlList, localName, namespaceURI, tmpAxiomNode);
            }
        }

        private void matchQNameRec(XMLList xmlList, QName qname, AxiomNode axiomNode) {
            AxiomNode tmpAxiomNode;
            OMAttribute omAttribute = axiomNode.getOMElement().getAttribute(qname);
            if (omAttribute != null) {
                tmpAxiomNode = AxiomNode.buildAxiomNode(omAttribute, axiomNode);
                xmlList.addAxiomNode(tmpAxiomNode);
            }
            Iterator iterator = axiomNode.getOMElement().getChildElements();
            while (iterator.hasNext()) {
                tmpAxiomNode = AxiomNode.buildAxiomNode(iterator.next(), axiomNode);
                this.matchQNameRec(xmlList, qname, tmpAxiomNode);
            }
        }
    }

    private static class DescendantChildrenMatcher
    implements AxiomNodeMatcher {
        private DescendantChildrenMatcher() {
        }

        public synchronized XMLList matchAnyQName(AxiomNode thisAxiomNode, XMLList xmlList, int type) {
            this.matchAnyQNameRec(thisAxiomNode, xmlList, thisAxiomNode);
            return xmlList;
        }

        public synchronized XMLList matchAnyLocalName(AxiomNode thisAxiomNode, XMLList xmlList, int type, String namespaceURI) {
            this.matchAnyLocalNameRec(thisAxiomNode, xmlList, namespaceURI, thisAxiomNode);
            return xmlList;
        }

        public synchronized XMLList matchAnyNamespace(AxiomNode thisAxiomNode, XMLList xmlList, int type, String localName, String namespaceURI) {
            this.matchAnyNamespaceRec(thisAxiomNode, xmlList, localName, namespaceURI, thisAxiomNode);
            return xmlList;
        }

        public synchronized XMLList matchQName(AxiomNode thisAxiomNode, XMLList xmlList, int type, QName qname) {
            this.matchQNameRec(thisAxiomNode, xmlList, qname, thisAxiomNode);
            return xmlList;
        }

        private void matchAnyQNameRec(AxiomNode thisAxiomNode, XMLList xmlList, AxiomNode axiomNode) {
            Iterator iterator = axiomNode.getOMElement().getChildren();
            while (iterator.hasNext()) {
                AxiomNode tmpAxiomNode = AxiomNode.buildAxiomNode(iterator.next(), axiomNode);
                thisAxiomNode.addToList(tmpAxiomNode, xmlList);
                if (!tmpAxiomNode.isOMElement) continue;
                this.matchAnyQNameRec(thisAxiomNode, xmlList, tmpAxiomNode);
            }
        }

        private void matchAnyLocalNameRec(AxiomNode thisAxiomNode, XMLList xmlList, String namespaceURI, AxiomNode axiomNode) {
            Iterator iterator = axiomNode.getOMElement().getChildren();
            while (iterator.hasNext()) {
                AxiomNode tmpAxiomNode = AxiomNode.buildAxiomNode(iterator.next(), axiomNode);
                QName qname = tmpAxiomNode.getQName();
                if (namespaceURI.equals("") || qname != null && qname.getNamespaceURI().equals(namespaceURI) || tmpAxiomNode.isText()) {
                    thisAxiomNode.addToList(tmpAxiomNode, xmlList);
                }
                if (!tmpAxiomNode.isElement()) continue;
                this.matchAnyLocalNameRec(thisAxiomNode, xmlList, namespaceURI, tmpAxiomNode);
            }
        }

        private void matchAnyNamespaceRec(AxiomNode thisAxiomNode, XMLList xmlList, String localName, String namespaceURI, AxiomNode axiomNode) {
            Iterator iterator = axiomNode.getOMElement().getChildren();
            while (iterator.hasNext()) {
                AxiomNode tmpAxiomNode = AxiomNode.buildAxiomNode(iterator.next(), axiomNode);
                QName qname = tmpAxiomNode.getQName();
                if (qname != null && localName.equals(tmpAxiomNode.getQName().getLocalPart()) && (namespaceURI == null || qname.getNamespaceURI().equals(namespaceURI))) {
                    thisAxiomNode.addToList(tmpAxiomNode, xmlList);
                }
                if (!tmpAxiomNode.isElement()) continue;
                this.matchAnyNamespaceRec(thisAxiomNode, xmlList, localName, namespaceURI, tmpAxiomNode);
            }
        }

        private void matchQNameRec(AxiomNode thisAxiomNode, XMLList xmlList, QName qname, AxiomNode axiomNode) {
            Iterator iterator = axiomNode.getOMElement().getChildren();
            while (iterator.hasNext()) {
                AxiomNode tmpAxiomNode = AxiomNode.buildAxiomNode(iterator.next(), axiomNode);
                QName tmpQName = tmpAxiomNode.getQName();
                if (tmpQName != null && qname.equals(tmpQName)) {
                    thisAxiomNode.addToList(tmpAxiomNode, xmlList);
                }
                if (!tmpAxiomNode.isElement()) continue;
                this.matchQNameRec(thisAxiomNode, xmlList, qname, tmpAxiomNode);
            }
        }
    }

    private static class NodeMatcher
    implements AxiomNodeMatcher {
        private NodeMatcher() {
        }

        public synchronized XMLList matchAnyQName(AxiomNode thisAxiomNode, XMLList xmlList, int type) {
            Iterator iterator = null;
            if (type == 1) {
                iterator = thisAxiomNode.getOMElement().getChildren();
            } else if (type == 0) {
                iterator = thisAxiomNode.getOMElement().getAllAttributes();
            }
            while (iterator.hasNext()) {
                AxiomNode tmpAxiomNode = AxiomNode.buildAxiomNode(iterator.next(), thisAxiomNode);
                thisAxiomNode.addToList(tmpAxiomNode, xmlList);
            }
            return xmlList;
        }

        public synchronized XMLList matchAnyLocalName(AxiomNode thisAxiomNode, XMLList xmlList, int type, String namespaceURI) {
            Iterator iterator = null;
            if (type == 1) {
                iterator = thisAxiomNode.getOMElement().getChildren();
            } else if (type == 0) {
                iterator = thisAxiomNode.getOMElement().getAllAttributes();
            }
            while (iterator.hasNext()) {
                AxiomNode tmpAxiomNode = AxiomNode.buildAxiomNode(iterator.next(), thisAxiomNode);
                QName qname = tmpAxiomNode.getQName();
                if (!namespaceURI.equals("") && (qname == null || !qname.getNamespaceURI().equals(namespaceURI)) && !tmpAxiomNode.isText()) continue;
                thisAxiomNode.addToList(tmpAxiomNode, xmlList);
            }
            return xmlList;
        }

        public synchronized XMLList matchAnyNamespace(AxiomNode thisAxiomNode, XMLList xmlList, int type, String localName, String namespaceURI) {
            Iterator iterator = null;
            if (type == 1) {
                iterator = thisAxiomNode.getOMElement().getChildren();
            } else if (type == 0) {
                iterator = thisAxiomNode.getOMElement().getAllAttributes();
            }
            while (iterator.hasNext()) {
                AxiomNode tmpAxiomNode = AxiomNode.buildAxiomNode(iterator.next(), thisAxiomNode);
                QName qname = tmpAxiomNode.getQName();
                if (qname == null || !qname.getLocalPart().equals(localName) || namespaceURI != null && !qname.getNamespaceURI().equals(namespaceURI)) continue;
                thisAxiomNode.addToList(tmpAxiomNode, xmlList);
            }
            return xmlList;
        }

        public synchronized XMLList matchQName(AxiomNode thisAxiomNode, XMLList xmlList, int type, QName qname) {
            block3: {
                block2: {
                    if (type != 1) break block2;
                    Iterator iterator = thisAxiomNode.getOMElement().getChildrenWithName(qname);
                    while (iterator.hasNext()) {
                        AxiomNode tmpAxiomNode = AxiomNode.buildAxiomNode(iterator.next(), thisAxiomNode);
                        thisAxiomNode.addToList(tmpAxiomNode, xmlList);
                    }
                    break block3;
                }
                if (type != 0) break block3;
                Iterator iterator = thisAxiomNode.getOMElement().getAllAttributes();
                while (iterator.hasNext()) {
                    AxiomNode tmpAxiomNode = AxiomNode.buildAxiomNode(iterator.next(), thisAxiomNode);
                    if (!qname.equals(tmpAxiomNode.getOMAttribute().getQName())) continue;
                    thisAxiomNode.addToList(tmpAxiomNode, xmlList);
                }
            }
            return xmlList;
        }
    }
}

