/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.javascript.xmlimpl;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.wso2.javascript.xmlimpl.AxiomNode;
import org.wso2.javascript.xmlimpl.Namespace;
import org.wso2.javascript.xmlimpl.QName;
import org.wso2.javascript.xmlimpl.XMLLibImpl;
import org.wso2.javascript.xmlimpl.XMLList;
import org.wso2.javascript.xmlimpl.XMLName;
import org.wso2.javascript.xmlimpl.XMLObjectImpl;

public class XML
extends XMLObjectImpl {
    private AxiomNode axiomNode;

    XML(XMLLibImpl lib, AxiomNode axiomNode) {
        super(lib, lib.xmlPrototype);
        this.axiomNode = axiomNode;
        this.axiomNode.xmlObject = this;
    }

    protected Object jsConstructor(Context cx, boolean inNewExpr, Object[] args) {
        XML xml;
        if (args.length == 0) {
            xml = XML.toXML(this.lib, "");
        } else {
            if (!inNewExpr && args[0] instanceof XML) {
                xml = (XML)((Object)args[0]);
            }
            xml = XML.toXML(this.lib, args[0]);
        }
        return xml;
    }

    public Scriptable getExtraMethodSource(Context cx) {
        if (this.hasSimpleContent()) {
            String src = this.toString();
            return ScriptRuntime.toObjectOrNull((Context)cx, (Object)src);
        }
        return null;
    }

    public String getClassName() {
        return "XML";
    }

    boolean ecmaHasImpl(XMLName xmlName) {
        boolean result = false;
        if (this.prototypeFlag) {
            String name = xmlName.localName();
            if (this.getMethod(name) != NOT_FOUND) {
                result = true;
            }
        } else {
            String name = xmlName.localName();
            if (((XMLList)((Object)this.ecmaGetImpl(xmlName))).length() > 0 || this.getMethod(name) != NOT_FOUND) {
                result = true;
            }
        }
        return result;
    }

    Object ecmaGetImpl(XMLName xmlName) {
        XMLList xmlList = new XMLList(this.lib);
        if (xmlName.isDescendants() && xmlName.isAttributeName()) {
            this.axiomNode.setNodeMatcher("DescendantAttributeMatcher");
            this.axiomNode.matchNodes(xmlName, xmlList, 0);
        } else if (xmlName.isDescendants() && !xmlName.isAttributeName()) {
            this.axiomNode.setNodeMatcher("DescendantChildrenMatcher");
            this.axiomNode.matchNodes(xmlName, xmlList, 1);
        } else if (xmlName.isAttributeName()) {
            this.axiomNode.setNodeMatcher("NodeMatcher");
            this.axiomNode.matchNodes(xmlName, xmlList, 0);
        } else {
            javax.xml.namespace.QName qname = new javax.xml.namespace.QName(xmlName.uri(), xmlName.localName());
            xmlList.setTargets(this, qname);
            this.axiomNode.setNodeMatcher("NodeMatcher");
            this.axiomNode.matchNodes(xmlName, xmlList, 1);
        }
        return xmlList;
    }

    void ecmaPutImpl(XMLName xmlName, Object value) {
        if (!this.prototypeFlag) {
            if (value == null || value instanceof Undefined) {
                throw ScriptRuntime.typeError((String)"value is null or undefined..");
            }
            if (xmlName.isAttributeName()) {
                this.axiomNode.insertAttribute(xmlName, value);
            } else if (xmlName.uri() == null && xmlName.localName().equals("*")) {
                this.setChildren(value);
            } else {
                XMLList matches;
                XMLObjectImpl xmlValue;
                if (value instanceof XML) {
                    xmlValue = (XML)((Object)value);
                    if (((XML)xmlValue).getAxiomNode().isAttribute()) {
                        xmlValue = this.axiomNode.getElemetFromText(this.lib, xmlName, xmlValue.toString());
                    }
                } else if (value instanceof XMLList) {
                    xmlValue = (XMLList)((Object)value);
                    for (int i = 0; i < xmlValue.length(); ++i) {
                        XML xml = ((XMLList)xmlValue).getFromAxiomNodeList(i);
                        if (!xml.axiomNode.isAttribute()) continue;
                        ((XMLList)xmlValue).replace(i, this.axiomNode.getElemetFromText(this.lib, xmlName, xmlValue.toString()));
                    }
                } else {
                    xmlValue = this.axiomNode.getElemetFromText(this.lib, xmlName, ScriptRuntime.toString((Object)value));
                }
                if ((matches = (XMLList)((Object)this.ecmaGetImpl(xmlName))).length() == 0) {
                    this.appendChild((Object)xmlValue);
                } else {
                    for (int i = 1; i < matches.length(); ++i) {
                        this.removeChild(matches.getFromAxiomNodeList((int)i).axiomNode);
                    }
                    for (int i = 0; i < xmlValue.length(); ++i) {
                        XML xmlToAdd = xmlValue instanceof XMLList ? ((XMLList)xmlValue).getFromAxiomNodeList(i) : (XML)xmlValue;
                        if (xmlToAdd.getAxiomNode().isAttribute() || xmlToAdd.getAxiomNode().isText()) {
                            xmlToAdd = this.axiomNode.getElemetFromText(this.lib, xmlName, xmlToAdd.toString());
                        }
                        if (i == 0) {
                            this.replaceChild(matches.getFromAxiomNodeList(0).getAxiomNode(), xmlToAdd.getAxiomNode());
                            continue;
                        }
                        XMLList tmpMatches = (XMLList)((Object)this.ecmaGetImpl(xmlName));
                        this.insertChild(tmpMatches.getFromAxiomNodeList(i - 1).getAxiomNode(), (Object)xmlToAdd, 1);
                    }
                }
            }
        }
    }

    void ecmaDeleteImpl(XMLName name) {
        if (this.axiomNode.isElement()) {
            XMLList matches = (XMLList)((Object)this.ecmaGetImpl(name));
            matches.remove();
        }
    }

    boolean equivalentXml(Object target) {
        boolean result = false;
        if (target instanceof XML) {
            AxiomNode refNode = this.getAxiomNode();
            AxiomNode targetNode = ((XML)((Object)target)).getAxiomNode();
            result = refNode.isAttribute() || refNode.isText() || targetNode.isAttribute() || targetNode.isText() ? this.toString().equals(target.toString()) : AxiomNode.equivalentAxiomNode(refNode, targetNode);
        } else if (target instanceof XMLList) {
            XMLList otherList = (XMLList)((Object)target);
            if (otherList.length() == 1) {
                result = this.equivalentXml((Object)otherList.getFromAxiomNodeList(0));
            }
        } else if (this.hasSimpleContent()) {
            String otherStr = ScriptRuntime.toString((Object)target);
            result = this.toString().equals(otherStr);
        }
        return result;
    }

    public Object get(int index, Scriptable start) {
        if (index == 0) {
            return this;
        }
        return Scriptable.NOT_FOUND;
    }

    public boolean has(int index, Scriptable start) {
        return index == 0;
    }

    public void put(int index, Scriptable start, Object value) {
        throw ScriptRuntime.typeError((String)"Assignment to indexed XML is not allowed");
    }

    public void delete(int index) {
        if (index == 0) {
            this.remove();
        }
    }

    XML addNamespace(Namespace ns) {
        this.axiomNode.addInScopeNamespace(ns);
        return this;
    }

    XML appendChild(Object value) {
        return this.insertChild(null, value, 1);
    }

    XMLList attribute(XMLName xmlName) {
        return (XMLList)((Object)this.ecmaGetImpl(xmlName));
    }

    XMLList attributes() {
        XMLName xmlName = XMLName.formStar();
        xmlName.setAttributeName();
        return (XMLList)((Object)this.ecmaGetImpl(xmlName));
    }

    XMLList child(long index) {
        XMLList xmlList = new XMLList(this.lib);
        xmlList.addAxiomNode(this.axiomNode.childAt((int)index));
        return xmlList;
    }

    XMLList child(XMLName xmlName) {
        return (XMLList)((Object)this.ecmaGetImpl(xmlName));
    }

    int childIndex() {
        return this.axiomNode.getChildIndex();
    }

    XMLList children() {
        return (XMLList)((Object)this.ecmaGetImpl(XMLName.formStar()));
    }

    XMLList descendants(XMLName xmlName) {
        if (!xmlName.isDescendants()) {
            xmlName.setIsDescendants();
        }
        return (XMLList)((Object)this.ecmaGetImpl(xmlName));
    }

    XMLList elements(XMLName xmlName) {
        if (xmlName.isDescendants() || xmlName.isAttributeName()) {
            throw ScriptRuntime.typeError((String)"Argument is not a valid argument");
        }
        XMLList xmlList = new XMLList(this.lib);
        return this.axiomNode.getChildElements(xmlName, xmlList);
    }

    boolean hasComplexContent() {
        if (this.axiomNode.isElement()) {
            return this.axiomNode.getOMElement().getFirstElement() != null;
        }
        return false;
    }

    boolean hasSimpleContent() {
        if (this.axiomNode.isComment() || this.axiomNode.isProcessingInstruction()) {
            return false;
        }
        return !this.axiomNode.isElement() || this.axiomNode.getOMElement().getFirstElement() == null;
    }

    Object[] inScopeNamespaces() {
        return this.axiomNode.getInScopeNamespace(this.lib);
    }

    XML insertChildAfter(Object child, Object value) {
        XML childXML;
        if (child == null) {
            this.appendChild(value);
        } else if (child instanceof XML) {
            XML childXML2 = (XML)((Object)child);
            if (childXML2.getAxiomNode().getOMNode() != null) {
                this.insertChild(childXML2.getAxiomNode(), value, 1);
            }
        } else if (child instanceof XMLList && (childXML = ((XMLList)((Object)child)).getFromAxiomNodeList(0)).getAxiomNode().getOMNode() != null) {
            this.insertChild(childXML.getAxiomNode(), value, 1);
        }
        return this;
    }

    XML insertChildBefore(Object child, Object value) {
        XML childXML;
        if (child == null) {
            this.prependChild(value);
        } else if (child instanceof XML) {
            XML childXML2 = (XML)((Object)child);
            if (childXML2.getAxiomNode().getOMNode() != null) {
                this.insertChild(childXML2.getAxiomNode(), value, 2);
            }
        } else if (child instanceof XMLList && (childXML = ((XMLList)((Object)child)).getFromAxiomNodeList(0)).getAxiomNode().getOMNode() != null) {
            this.insertChild(childXML.getAxiomNode(), value, 2);
        }
        return this;
    }

    int length() {
        return 1;
    }

    String localName() {
        QName name = this.name();
        if (name == null) {
            return null;
        }
        return name.localName();
    }

    QName name() {
        javax.xml.namespace.QName qname = this.axiomNode.getQName();
        QName resultQName = new QName(this.lib, qname.getNamespaceURI(), qname.getLocalPart(), qname.getPrefix());
        return resultQName;
    }

    Object namespace(String prefix) {
        Object namespace = Undefined.instance;
        if (!this.axiomNode.isElement()) {
            return namespace;
        }
        OMElement omElement = this.axiomNode.getOMElement();
        if (prefix == null) {
            javax.xml.namespace.QName qname = omElement.getQName();
            if (qname.getNamespaceURI() != "") {
                namespace = new Namespace(this.lib, qname.getPrefix(), qname.getNamespaceURI());
            }
        } else {
            OMNamespace ns = omElement.findNamespaceURI(prefix);
            if (ns != null) {
                namespace = new Namespace(this.lib, ns.getPrefix(), ns.getNamespaceURI());
            }
        }
        return namespace;
    }

    Object[] namespaceDeclarations() {
        ArrayList<Namespace> nsList = new ArrayList<Namespace>();
        if (this.axiomNode.isElement()) {
            OMElement element = this.axiomNode.getOMElement();
            Iterator iterator = element.getAllDeclaredNamespaces();
            while (iterator.hasNext()) {
                OMNamespace ns = (OMNamespace)iterator.next();
                Namespace namespace = new Namespace(this.lib, ns.getPrefix(), ns.getNamespaceURI());
                nsList.add(namespace);
            }
        }
        Object[] list = new Object[nsList.size()];
        for (int i = 0; i < nsList.size(); ++i) {
            Namespace namespace = (Namespace)((Object)nsList.get(i));
            list[i] = namespace;
        }
        return list;
    }

    String nodeKind() {
        String nodeKind = this.axiomNode.isAttribute() ? "attribute" : (this.axiomNode.isText() ? "text" : (this.axiomNode.isComment() ? "comment" : (this.axiomNode.isProcessingInstruction() ? "processing-instruction" : (this.axiomNode.isElement() ? "element" : "text"))));
        return nodeKind;
    }

    Object parent() {
        AxiomNode parentNode = this.axiomNode.getParentNode();
        if (parentNode != null) {
            return parentNode.getXMLObject(this.lib);
        }
        return null;
    }

    XML prependChild(Object value) {
        this.insertChild(null, value, 2);
        return this;
    }

    boolean propertyIsEnumerable(Object member) {
        double x;
        boolean result = member instanceof Integer ? (Integer)member == 0 : (member instanceof Number ? (x = ((Number)member).doubleValue()) == 0.0 && 1.0 / x > 0.0 : ScriptRuntime.toString((Object)member).equals("0"));
        return result;
    }

    XML removeNamespace(Namespace ns) {
        throw ScriptRuntime.typeError((String)"Unsupported operation");
    }

    XML replace(long index, Object value) {
        AxiomNode nodeToRemove = this.axiomNode.childAt((int)index);
        if (nodeToRemove != null) {
            this.replaceChild(nodeToRemove, value);
        }
        return this;
    }

    XML replace(XMLName name, Object value) {
        XMLList xmlList;
        if (this.axiomNode.isElement() && (xmlList = (XMLList)((Object)this.ecmaGetImpl(name))).length() > 0) {
            this.ecmaPutImpl(name, value);
        }
        return this;
    }

    XML setChildren(Object xml) {
        XMLName xmlName = XMLName.formStar();
        XMLList matches = (XMLList)((Object)this.ecmaGetImpl(xmlName));
        matches.remove();
        this.appendChild(xml);
        return this;
    }

    void setLocalName(String localName) {
        if (this.axiomNode.isAttribute()) {
            this.axiomNode.getOMAttribute().setLocalName(localName);
        } else if (this.axiomNode.isElement()) {
            this.axiomNode.getOMElement().setLocalName(localName);
        }
    }

    void setName(QName qname) {
        if (this.lib.isXMLName(Context.getCurrentContext(), qname.localName())) {
            if (this.axiomNode.isElement()) {
                OMElement omElement = this.axiomNode.getOMElement();
                OMNamespace omNS = this.axiomNode.getOMFactory().createOMNamespace(qname.uri(), qname.prefix());
                omElement.setLocalName(qname.localName());
                omElement.setNamespace(omNS);
            } else if (this.axiomNode.isAttribute()) {
                OMAttribute omAttr = this.axiomNode.getOMAttribute();
                OMNamespace omNS = this.axiomNode.getOMFactory().createOMNamespace(qname.uri(), qname.prefix());
                omAttr.setLocalName(qname.localName());
                omAttr.setOMNamespace(omNS);
            } else if (this.axiomNode.isProcessingInstruction()) {
                // empty if block
            }
        } else {
            throw ScriptRuntime.typeError((String)"QName is not valid");
        }
    }

    void setNamespace(Namespace ns) {
        if (this.axiomNode.isAttribute()) {
            OMAttribute omAttr = this.axiomNode.getOMAttribute();
            OMNamespace omNamespace = this.axiomNode.getOMFactory().createOMNamespace(ns.uri(), ns.prefix());
            omAttr.setOMNamespace(omNamespace);
        } else if (this.axiomNode.isElement()) {
            OMElement omEle = this.axiomNode.getOMElement();
            OMNamespace omNamespace = this.axiomNode.getOMFactory().createOMNamespace(ns.uri(), ns.prefix());
            omEle.setNamespace(omNamespace);
        }
    }

    XMLList text() {
        XMLList xmlList = new XMLList(this.lib);
        if (this.axiomNode.isElement()) {
            Iterator iterator = this.axiomNode.getOMElement().getChildren();
            while (iterator.hasNext()) {
                OMNode tmpNode = (OMNode)iterator.next();
                if (tmpNode.getType() != 4) continue;
                xmlList.addAxiomNode(AxiomNode.buildAxiomNode(tmpNode, this.axiomNode));
            }
        }
        return xmlList;
    }

    public String toString() {
        try {
            if (this.axiomNode.isAttribute()) {
                return this.axiomNode.getOMAttribute().getAttributeValue();
            }
            if (this.axiomNode.isText()) {
                return this.axiomNode.getOMText().getText();
            }
            if (this.hasSimpleContent()) {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.axiomNode.getOMNode() != null) {
                    Iterator iterator = this.axiomNode.getOMElement().getChildren();
                    while (iterator.hasNext()) {
                        Object obj = iterator.next();
                        if (!(obj instanceof OMText)) continue;
                        stringBuffer.append(((OMText)obj).getText());
                    }
                }
                return stringBuffer.toString();
            }
            return this.toXMLString(0);
        }
        catch (OMException e) {
            throw ScriptRuntime.typeError((String)e.getMessage());
        }
        catch (Throwable e) {
            throw ScriptRuntime.typeError((String)e.getMessage());
        }
    }

    String toXMLString(int indent) {
        try {
            String str = "";
            if (this.axiomNode.isElement()) {
                str = this.axiomNode.getOMNode().toString();
            } else if (this.axiomNode.isAttribute()) {
                str = this.axiomNode.getOMAttribute().getAttributeValue();
            } else if (this.axiomNode.isText()) {
                str = this.axiomNode.getOMText().getText();
            } else {
                if (this.axiomNode.isComment()) {
                    str = this.axiomNode.getOMComment().getValue();
                    return "comment is not handled " + str;
                }
                if (this.axiomNode.isProcessingInstruction()) {
                    str = this.axiomNode.getOMProcessingInstruction().getTarget();
                    return "PI is not handled " + str;
                }
            }
            return str;
        }
        catch (OMException e) {
            throw ScriptRuntime.typeError((String)e.getMessage());
        }
        catch (Throwable e) {
            throw ScriptRuntime.typeError((String)e.getMessage());
        }
    }

    Object valueOf() {
        return this;
    }

    Object getXmlObject() {
        if (this.axiomNode.isOMNode()) {
            return this.axiomNode.getOMNode();
        }
        if (this.axiomNode.isAttribute()) {
            return this.axiomNode.getOMAttribute();
        }
        return null;
    }

    protected void removeChild(AxiomNode axiomNode) {
        this.axiomNode.removeChild(axiomNode);
    }

    void remove() {
        this.axiomNode.detach();
    }

    static XML getFromAxiomNode(XMLLibImpl lib, AxiomNode axiomNode) {
        if (axiomNode.xmlObject == null) {
            axiomNode.xmlObject = new XML(lib, axiomNode);
        }
        return axiomNode.xmlObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static XML toXML(XMLLibImpl lib, Object value) {
        String xmlString;
        AxiomNode axiomNode = null;
        if (value == null || value == Undefined.instance) {
            throw ScriptRuntime.typeError((String)"value == null || value == undefined.instance");
        }
        if (value instanceof XMLObjectImpl) {
            if (!(value instanceof XML)) throw ScriptRuntime.typeError((String)"Invalid argument ");
            xmlString = ((XML)((Object)value)).toXMLString(0);
        } else if (value instanceof String || value instanceof Number || value instanceof Boolean) {
            xmlString = ScriptRuntime.toString((Object)value);
        } else {
            Object wrapped;
            if (value instanceof OMNode) {
                axiomNode = AxiomNode.buildAxiomNode(value, null);
                return new XML(lib, axiomNode);
            }
            if (value instanceof Wrapper && (wrapped = ((Wrapper)value).unwrap()) instanceof OMNode) {
                axiomNode = AxiomNode.buildAxiomNode(wrapped, null);
                return new XML(lib, axiomNode);
            }
            xmlString = ScriptRuntime.toString((Object)value);
        }
        if (xmlString.trim().startsWith("<>")) {
            throw ScriptRuntime.typeError((String)"Invalid use of XML object anonymous tags <></>.");
        }
        Context cx = Context.getCurrentContext();
        Namespace defaultNamespace = cx == null ? lib.namespacePrototype : lib.getDefaultNamespace(cx);
        try {
            OMText omNode;
            OMFactory omFactory = OMAbstractFactory.getOMFactory();
            if (xmlString.equals("")) {
                omNode = omFactory.createOMText("");
            } else {
                XMLStreamReader parser2 = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xmlString));
                StAXOMBuilder builder2 = new StAXOMBuilder(parser2);
                omNode = builder2.getDocumentElement();
            }
            OMElement parent = omFactory.createOMElement(new javax.xml.namespace.QName(defaultNamespace.uri(), "parent"));
            parent.addChild((OMNode)omNode);
            omNode = parent.getFirstOMChild();
            axiomNode = AxiomNode.buildAxiomNode(omNode, null);
            return new XML(lib, axiomNode);
        }
        catch (XMLStreamException e) {
            throw ScriptRuntime.typeError((String)e.getMessage());
        }
        catch (OMException e) {
            throw ScriptRuntime.typeError((String)e.getMessage());
        }
        catch (Throwable e) {
            throw ScriptRuntime.typeError((String)e.getMessage());
        }
    }

    public OMNode getAxiomFromXML() {
        Object object = this.getXmlObject();
        if (object instanceof OMAttribute) {
            OMAttribute omAttribute = (OMAttribute)object;
            return this.axiomNode.getOMFactory().createOMText(omAttribute.getAttributeValue());
        }
        return (OMNode)object;
    }

    AxiomNode getAxiomNode() {
        return this.axiomNode;
    }

    void setAxiomNode(AxiomNode axiomNode) {
        this.axiomNode = axiomNode;
    }

    public XML insertChild(AxiomNode refNode, Object value, int mode) {
        if (!(value instanceof Undefined)) {
            if (value instanceof XML) {
                XML xmlValue = (XML)((Object)value);
                this.axiomNode.insertChild(refNode, xmlValue.getAxiomNode(), mode);
            } else if (value instanceof XMLList) {
                XMLList list = (XMLList)((Object)value);
                for (int i = 0; i < list.length(); ++i) {
                    XML xmlValue = list.getFromAxiomNodeList(i);
                    this.insertChild(refNode, (Object)xmlValue, mode);
                }
            } else {
                String xmlStr = ScriptRuntime.toString((Object)value);
                XML xmlValue = XML.toXML(this.lib, xmlStr);
                this.insertChild(refNode, (Object)xmlValue, mode);
            }
        }
        return this;
    }

    private void replaceChild(AxiomNode nodeToReplace, Object value) {
        if (nodeToReplace.getOMNode() != null) {
            this.insertChild(nodeToReplace, value, 2);
            nodeToReplace.detach();
        }
    }

    private void replaceChild(AxiomNode nodeToReplace, AxiomNode nodeToAdd) {
        if (nodeToReplace.getOMNode() != null) {
            this.axiomNode.insertChild(nodeToReplace, nodeToAdd, 2);
            nodeToReplace.detach();
        }
    }

    public void replaceAll(XML targetXML) {
        AxiomNode targetNode = AxiomNode.buildAxiomNode(targetXML.getAxiomNode().cloneOMNode(), this.axiomNode.getParentNode());
        if (this.axiomNode.getOMNode() != null) {
            this.axiomNode.insertChild(this.axiomNode, targetNode, 2);
            this.axiomNode.detach();
            this.axiomNode = targetNode;
        }
    }
}

