/*
 * Decompiled with CFR 0.152.
 */
package org.xins.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.HashSet;
import java.util.Set;
import org.xins.client.AbstractCAPICallRequest;
import org.xins.client.AbstractCAPIErrorCodeException;
import org.xins.client.Library;
import org.xins.client.Log;
import org.xins.client.UnacceptableErrorCodeXINSCallException;
import org.xins.client.UnacceptableRequestException;
import org.xins.client.XINSCallConfig;
import org.xins.client.XINSCallException;
import org.xins.client.XINSCallRequest;
import org.xins.client.XINSCallResult;
import org.xins.client.XINSCallResultData;
import org.xins.client.XINSServiceCaller;
import org.xins.common.MandatoryArgumentChecker;
import org.xins.common.Utils;
import org.xins.common.collections.InvalidPropertyValueException;
import org.xins.common.collections.MissingRequiredPropertyException;
import org.xins.common.collections.PropertyReader;
import org.xins.common.http.HTTPCallException;
import org.xins.common.service.Descriptor;
import org.xins.common.service.DescriptorBuilder;
import org.xins.common.service.GenericCallException;
import org.xins.common.service.ServiceCaller;
import org.xins.common.service.TargetDescriptor;
import org.xins.common.service.UnsupportedProtocolException;
import org.xins.common.spec.APISpec;
import org.xins.common.spec.InvalidSpecificationException;
import org.xins.common.text.TextUtils;

public abstract class AbstractCAPI {
    private static final String CLASSNAME = (class$org$xins$client$AbstractCAPI == null ? (class$org$xins$client$AbstractCAPI = AbstractCAPI.class$("org.xins.client.AbstractCAPI")) : class$org$xins$client$AbstractCAPI).getName();
    private static final Set VERSION_COMPARISIONS_DONE = new HashSet();
    private final String _apiName;
    private final XINSServiceCaller _caller;
    private APISpec _apiSpecification;
    static /* synthetic */ Class class$org$xins$client$AbstractCAPI;

    protected AbstractCAPI(Descriptor descriptor, XINSCallConfig callConfig) throws IllegalArgumentException, UnsupportedProtocolException {
        MandatoryArgumentChecker.check((String)"descriptor", (Object)descriptor);
        this._caller = new XINSServiceCaller(descriptor, callConfig);
        this._caller.setCAPI(this);
        this._apiName = this.determineAPIName();
        this.checkXINSVersion();
    }

    protected AbstractCAPI(Descriptor descriptor) throws IllegalArgumentException, UnsupportedProtocolException {
        this(descriptor, null);
    }

    protected AbstractCAPI(PropertyReader properties, String apiName) throws IllegalArgumentException, MissingRequiredPropertyException, InvalidPropertyValueException {
        MandatoryArgumentChecker.check((String)"properties", (Object)properties, (String)"apiName", (Object)apiName);
        String propName = "capis." + apiName;
        this._caller = new XINSServiceCaller();
        Descriptor descriptor = DescriptorBuilder.build((ServiceCaller)this._caller, (PropertyReader)properties, (String)propName);
        this._caller.setDescriptor(descriptor);
        this._caller.setCAPI(this);
        this._apiName = this.determineAPIName();
        this.checkXINSVersion();
    }

    private final String determineAPIName() {
        try {
            String s = this.getAPINameImpl();
            if (!TextUtils.isEmpty((String)s)) {
                return s;
            }
        }
        catch (Throwable exception) {
            Utils.logProgrammingError((String)CLASSNAME, (String)"determineAPIName()", (String)this.getClass().getName(), (String)"getAPINameImpl()", null, (Throwable)exception);
        }
        String className = this.getClass().getName();
        int index = className.lastIndexOf(".capi.");
        if (index > 0) {
            String s = className.substring(0, index);
            index = s.lastIndexOf(46);
            if (!TextUtils.isEmpty((String)(s = s.substring(index + 1)))) {
                return s;
            }
        }
        return null;
    }

    public final String getAPIName() {
        if (this._apiName == null) {
            return "<unknown>";
        }
        return this._apiName;
    }

    protected String getAPINameImpl() {
        return null;
    }

    public final APISpec getAPISpecification() throws InvalidSpecificationException {
        if (this._apiSpecification == null) {
            URL specsURL;
            block6: {
                specsURL = null;
                CodeSource source = this.getClass().getProtectionDomain().getCodeSource();
                if (source != null) {
                    URL sourceURL = source.getLocation();
                    try {
                        if (sourceURL.getPath().endsWith(".jar")) {
                            specsURL = new URL("jar:" + sourceURL.toExternalForm() + "!/specs/");
                            break block6;
                        }
                        specsURL = new URL(sourceURL.toExternalForm() + "/specs/");
                    }
                    catch (MalformedURLException murlex) {
                        Log.log_2116(murlex, this.getAPIName());
                        specsURL = this.getClass().getResource("/specs/");
                    }
                } else {
                    specsURL = this.getClass().getResource("/specs/");
                }
            }
            this._apiSpecification = new APISpec(this.getClass(), specsURL.toExternalForm());
        }
        return this._apiSpecification;
    }

    public final void setXINSCallConfig(XINSCallConfig config) {
        this._caller.setXINSCallConfig(config);
    }

    public final XINSCallConfig getXINSCallConfig() {
        return this._caller.getXINSCallConfig();
    }

    protected XINSServiceCaller getCaller() {
        return this._caller;
    }

    private void checkXINSVersion() {
        Class<?> clazz = this.getClass();
        if (!VERSION_COMPARISIONS_DONE.contains(clazz)) {
            String runtimeVersion;
            String buildVersion = this.getXINSVersion();
            if (!buildVersion.equals(runtimeVersion = Library.getVersion())) {
                Log.log_2114(this._apiName, buildVersion, runtimeVersion);
            }
            VERSION_COMPARISIONS_DONE.add(clazz);
        }
    }

    public abstract String getXINSVersion();

    protected final XINSCallResult callImpl(AbstractCAPICallRequest request) throws IllegalArgumentException, UnacceptableRequestException, GenericCallException, HTTPCallException, XINSCallException {
        MandatoryArgumentChecker.check((String)"request", (Object)request);
        UnacceptableRequestException unacceptable = request.checkParameters();
        if (unacceptable != null) {
            throw unacceptable;
        }
        return this._caller.call(request.xinsCallRequest());
    }

    protected AbstractCAPIErrorCodeException createErrorCodeException(XINSCallRequest request, TargetDescriptor target, long duration, XINSCallResultData resultData) throws IllegalArgumentException, UnacceptableErrorCodeXINSCallException {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

