/*
 * Decompiled with CFR 0.152.
 */
package org.xins.client;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xins.client.UnacceptableRequestException;
import org.xins.client.XINSCallConfig;
import org.xins.client.XINSCallRequest;
import org.xins.common.MandatoryArgumentChecker;
import org.xins.common.xml.Element;
import org.xins.common.xml.ElementBuilder;

public abstract class AbstractCAPICallRequest
implements Serializable {
    private final String _functionName;
    private XINSCallConfig _callConfig;
    private Map _parameterValues;
    private Element _dataSection;
    private ElementBuilder _dataElementBuilder;

    protected AbstractCAPICallRequest(String functionName) throws IllegalArgumentException {
        MandatoryArgumentChecker.check((String)"functionName", (Object)functionName);
        this._functionName = functionName;
    }

    protected final void parameterValue(String name, String value) throws IllegalArgumentException {
        MandatoryArgumentChecker.check((String)"name", (Object)name);
        if (value == null) {
            if (this._parameterValues != null) {
                this._parameterValues.remove(name);
            }
        } else {
            if (this._parameterValues == null) {
                this._parameterValues = new HashMap();
            }
            this._parameterValues.put(name, value);
        }
    }

    final XINSCallRequest xinsCallRequest() {
        Element dataSection;
        XINSCallRequest request = new XINSCallRequest(this._functionName);
        if (this._parameterValues != null && this._parameterValues.size() > 0) {
            Iterator iterator = this._parameterValues.keySet().iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                String value = (String)this._parameterValues.get(name);
                request.setParameter(name, value);
            }
        }
        if ((dataSection = this.getDataElement()) != null) {
            request.setDataSection(dataSection);
        }
        if (this._callConfig != null) {
            request.setXINSCallConfig(this._callConfig);
        }
        return request;
    }

    public final void configure(XINSCallConfig config) {
        this._callConfig = config;
    }

    public final XINSCallConfig configuration() {
        return this._callConfig;
    }

    protected final String getParameter(String parameterName) {
        if (this._parameterValues == null) {
            return null;
        }
        return (String)this._parameterValues.get(parameterName);
    }

    protected final void putDataSection(Element dataSection) {
        this._dataSection = dataSection;
        this._dataElementBuilder = null;
    }

    public final String functionName() {
        return this._functionName;
    }

    protected void add(Element element) {
        if (this._dataElementBuilder == null) {
            this._dataElementBuilder = new ElementBuilder("data");
            this._dataSection = null;
        }
        this._dataElementBuilder.addChild(element);
    }

    protected Element getDataElement() {
        if (this._dataElementBuilder != null) {
            return this._dataElementBuilder.createElement();
        }
        return this._dataSection;
    }

    public abstract UnacceptableRequestException checkParameters();
}

