/*
 * Decompiled with CFR 0.152.
 */
package org.xins.client;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.xins.client.Log;
import org.xins.common.MandatoryArgumentChecker;
import org.xins.common.Utils;
import org.xins.common.collections.PropertyReader;
import org.xins.common.collections.PropertyReaderUtils;
import org.xins.common.http.HTTPCallConfig;
import org.xins.common.http.HTTPCallException;
import org.xins.common.http.HTTPCallRequest;
import org.xins.common.http.HTTPCallResult;
import org.xins.common.http.HTTPCallResultData;
import org.xins.common.http.HTTPStatusCodeVerifier;
import org.xins.common.http.StatusCodeHTTPCallException;
import org.xins.common.service.CallConfig;
import org.xins.common.service.CallException;
import org.xins.common.service.CallExceptionList;
import org.xins.common.service.CallRequest;
import org.xins.common.service.CallResult;
import org.xins.common.service.Descriptor;
import org.xins.common.service.GenericCallException;
import org.xins.common.service.IOCallException;
import org.xins.common.service.ServiceCaller;
import org.xins.common.service.TargetDescriptor;
import org.xins.common.service.UnsupportedProtocolException;
import org.xins.common.servlet.container.LocalServletHandler;
import org.xins.common.servlet.container.XINSServletResponse;
import org.xins.common.text.FastStringBuffer;
import org.xins.common.text.URLEncoding;
import org.xins.logdoc.LogdocSerializable;

class FileServiceCaller
extends ServiceCaller {
    private static HashMap SERVLETS = new HashMap();

    public FileServiceCaller(Descriptor descriptor, HTTPCallConfig callConfig) throws IllegalArgumentException, UnsupportedProtocolException {
        super(descriptor, (CallConfig)callConfig);
    }

    public FileServiceCaller(Descriptor descriptor) throws IllegalArgumentException, UnsupportedProtocolException {
        this(descriptor, null);
    }

    protected CallConfig getDefaultCallConfig() {
        return new HTTPCallConfig();
    }

    protected CallResult createCallResult(CallRequest request, TargetDescriptor succeededTarget, long duration, CallExceptionList exceptions, Object result) throws ClassCastException {
        return new HTTPCallResult((HTTPCallRequest)request, succeededTarget, duration, exceptions, (HTTPCallResultData)result);
    }

    protected boolean isProtocolSupportedImpl(String protocol) {
        return "file".equalsIgnoreCase(protocol);
    }

    public Object doCallImpl(CallRequest request, CallConfig callConfig, TargetDescriptor target) throws ClassCastException, IllegalArgumentException, CallException {
        long start = System.currentTimeMillis();
        LocalServletHandler servletHandler = (LocalServletHandler)SERVLETS.get(target);
        if (servletHandler == null) {
            String fileLocation = target.getURL();
            File warFile = new File(fileLocation.substring(7).replace('/', File.separatorChar));
            try {
                servletHandler = new LocalServletHandler(warFile);
                SERVLETS.put(target, servletHandler);
            }
            catch (ServletException sex) {
                Log.log_2117(sex);
            }
        }
        PropertyReader parameters = ((HTTPCallRequest)request).getParameters();
        LogdocSerializable params = PropertyReaderUtils.serialize((PropertyReader)parameters, (String)"", (String)"?", null);
        String url = target.getURL();
        FastStringBuffer query = new FastStringBuffer(255);
        Iterator keys = parameters.getNames();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = parameters.get(key);
            if (value == null) {
                value = "";
            }
            if (key == null) continue;
            if (query.getLength() > 0) {
                query.append("&");
            }
            query.append(URLEncoding.encode((String)key));
            query.append("=");
            query.append(URLEncoding.encode((String)value));
        }
        XINSServletResponse response = null;
        try {
            response = servletHandler.query(query.toString());
        }
        catch (IOException exception) {
            long duration = System.currentTimeMillis() - start;
            org.xins.common.Log.log_1109((Throwable)exception, (String)url, (LogdocSerializable)params, (long)duration);
            throw new IOCallException(request, target, duration, exception);
        }
        HTTPCallResultDataHandler data = null;
        try {
            String result = response.getResult();
            byte[] resultData = null;
            if (result != null) {
                resultData = result.getBytes(response.getCharacterEncoding());
            }
            data = new HTTPCallResultDataHandler(response.getStatus(), resultData);
        }
        catch (UnsupportedEncodingException ueex) {
            throw Utils.logProgrammingError((Throwable)ueex);
        }
        int code = data.getStatusCode();
        long duration = System.currentTimeMillis() - start;
        HTTPStatusCodeVerifier verifier = ((HTTPCallRequest)request).getStatusCodeVerifier();
        if (verifier != null && !verifier.isAcceptable(code)) {
            org.xins.common.Log.log_1108((String)url, (LogdocSerializable)params, (long)duration, (int)code);
            throw new StatusCodeHTTPCallException((HTTPCallRequest)request, target, duration, code);
        }
        org.xins.common.Log.log_1107((String)url, (LogdocSerializable)params, (long)duration, (int)code);
        return new HTTPCallResult((HTTPCallRequest)request, target, duration, null, (HTTPCallResultData)data);
    }

    public HTTPCallResult call(HTTPCallRequest request, HTTPCallConfig callConfig) throws IllegalArgumentException, GenericCallException, HTTPCallException {
        CallResult callResult;
        MandatoryArgumentChecker.check((String)"request", (Object)request);
        try {
            callResult = this.doCall((CallRequest)request, (CallConfig)callConfig);
        }
        catch (GenericCallException exception) {
            throw exception;
        }
        catch (HTTPCallException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw Utils.logProgrammingError((Throwable)exception);
        }
        return (HTTPCallResult)callResult;
    }

    public HTTPCallResult call(HTTPCallRequest request) throws IllegalArgumentException, GenericCallException, HTTPCallException {
        return this.call(request, null);
    }

    private static final class HTTPCallResultDataHandler
    implements HTTPCallResultData {
        private final int _code;
        private final byte[] _data;

        HTTPCallResultDataHandler(int code, byte[] data) {
            this._code = code;
            this._data = data;
        }

        public int getStatusCode() {
            return this._code;
        }

        public byte[] getData() {
            return this._data;
        }
    }
}

