/*
 * Decompiled with CFR 0.152.
 */
package org.xins.client;

import java.util.List;
import org.xins.client.DataElement;
import org.xins.client.StandardErrorCodeException;
import org.xins.client.XINSCallRequest;
import org.xins.client.XINSCallResultData;
import org.xins.common.MandatoryArgumentChecker;
import org.xins.common.service.TargetDescriptor;
import org.xins.common.text.FastStringBuffer;

public class InvalidRequestException
extends StandardErrorCodeException {
    private static final String determineDetail(XINSCallResultData result) throws IllegalArgumentException {
        MandatoryArgumentChecker.check((String)"result", (Object)result);
        String errorCode = result.getErrorCode();
        if (errorCode == null) {
            throw new IllegalArgumentException("result.getErrorCode() == null");
        }
        DataElement element = result.getDataElement();
        return InvalidRequestException.createMessage(element);
    }

    static String createMessage(DataElement element) {
        List paramComboElements;
        String typeName;
        List invalidValueElements;
        if (element == null) {
            return null;
        }
        FastStringBuffer detail = new FastStringBuffer(250);
        List missingParamElements = element.getChildElements("missing-param");
        if (missingParamElements != null) {
            int size = missingParamElements.size();
            for (int i = 0; i < size; ++i) {
                DataElement e = (DataElement)missingParamElements.get(i);
                String paramName = e.getAttribute("param");
                String elementName = e.getAttribute("element");
                if (elementName == null && paramName != null && paramName.length() >= 1) {
                    detail.append("No value given for required parameter \"" + paramName + "\". ");
                    continue;
                }
                if (elementName == null || elementName.length() < 1 || paramName == null || paramName.length() < 1) continue;
                detail.append("No value given for required attribute \"" + paramName + "\" in the element \"" + elementName + "\". ");
            }
        }
        if ((invalidValueElements = element.getChildElements("invalid-value-for-type")) != null) {
            int size = invalidValueElements.size();
            for (int i = 0; i < size; ++i) {
                DataElement e = (DataElement)invalidValueElements.get(i);
                String paramName = e.getAttribute("param");
                typeName = e.getAttribute("type");
                String elementName = e.getAttribute("element");
                if (paramName != null && paramName.length() >= 1) {
                    detail.append("The value for parameter \"" + paramName + "\" is considered invalid for the type \"" + typeName + "\". ");
                    continue;
                }
                if (elementName == null || elementName.length() < 1 || paramName == null || paramName.length() < 1) continue;
                detail.append("The value for attribute \"" + paramName + "\" in the element \"" + elementName + "\" is considered invalid for the type \"" + typeName + "\". ");
            }
        }
        if ((paramComboElements = element.getChildElements("param-combo")) != null) {
            int size = paramComboElements.size();
            for (int i = 0; i < size; ++i) {
                List paramList;
                DataElement e = (DataElement)paramComboElements.get(i);
                typeName = e.getAttribute("type");
                if (typeName == null || typeName.trim().length() < 1 || (paramList = e.getChildElements("param")) == null || paramList.size() < 2) continue;
                detail.append("Violated param-combo constraint of type \"");
                detail.append(typeName);
                detail.append("\" on parameters ");
                int paramCount = paramList.size();
                for (int j = 0; j < paramCount; ++j) {
                    DataElement e2 = (DataElement)paramList.get(j);
                    String paramName = e2.getAttribute("name");
                    if (paramName == null || paramName.trim().length() < 1) continue;
                    detail.append("\"");
                    detail.append(paramName);
                    detail.append("\"");
                    if (j == paramCount - 1) {
                        detail.append(". ");
                        continue;
                    }
                    if (j == paramCount - 2) {
                        detail.append(" and ");
                        continue;
                    }
                    detail.append(", ");
                }
            }
        }
        if (detail.getLength() >= 1) {
            detail.crop(detail.getLength() - 1);
            return detail.toString();
        }
        return null;
    }

    InvalidRequestException(XINSCallRequest request, TargetDescriptor target, long duration, XINSCallResultData resultData) throws IllegalArgumentException {
        super(request, target, duration, resultData, InvalidRequestException.determineDetail(resultData));
    }
}

