/*
 * Decompiled with CFR 0.152.
 */
package org.xins.client;

import java.io.UnsupportedEncodingException;
import org.xins.client.XINSCallException;
import org.xins.client.XINSCallRequest;
import org.xins.common.MandatoryArgumentChecker;
import org.xins.common.Utils;
import org.xins.common.service.TargetDescriptor;

public final class InvalidResultXINSCallException
extends XINSCallException {
    static /* synthetic */ Class class$org$xins$client$InvalidResultXINSCallException;

    static InvalidResultXINSCallException noDataReceived(XINSCallRequest request, TargetDescriptor target, long duration) throws IllegalArgumentException {
        MandatoryArgumentChecker.check((String)"request", (Object)((Object)request), (String)"target", (Object)target);
        if (duration < 0L) {
            throw new IllegalArgumentException("duration (" + duration + ") < 0");
        }
        String detail = "No HTTP response received.";
        Throwable cause = null;
        return new InvalidResultXINSCallException(request, target, duration, detail, cause);
    }

    static InvalidResultXINSCallException parseError(byte[] httpData, XINSCallRequest request, TargetDescriptor target, long duration, Throwable cause) throws IllegalArgumentException {
        String quote;
        MandatoryArgumentChecker.check((String)"httpData", (Object)httpData, (String)"request", (Object)((Object)request), (String)"target", (Object)target);
        if (httpData.length < 1) {
            throw new IllegalArgumentException("httpData.length == 0");
        }
        if (duration < 0L) {
            throw new IllegalArgumentException("duration (" + duration + ") < 0");
        }
        int quoteLength = Math.min(httpData.length, 512);
        try {
            quote = new String(httpData, 0, quoteLength, "US-ASCII");
        }
        catch (UnsupportedEncodingException exception) {
            throw Utils.logProgrammingError((String)(class$org$xins$client$InvalidResultXINSCallException == null ? (class$org$xins$client$InvalidResultXINSCallException = InvalidResultXINSCallException.class$("org.xins.client.InvalidResultXINSCallException")) : class$org$xins$client$InvalidResultXINSCallException).getName(), (String)"parseError", (String)"java.lang.String", (String)"<init>(byte[],int,int,java.lang.String)", null, (Throwable)cause);
        }
        String detail = "Failed to parse the HTTP response. The first " + quoteLength + " bytes are (in ASCII): \"" + quote + "\".";
        return new InvalidResultXINSCallException(request, target, duration, detail, cause);
    }

    private InvalidResultXINSCallException(XINSCallRequest request, TargetDescriptor target, long duration, String detail, Throwable cause) throws IllegalArgumentException {
        super("Invalid XINS call result", request, target, duration, detail, cause);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

