/*
 * Decompiled with CFR 0.152.
 */
package org.xins.client;

import org.xins.client.DataElement;
import org.xins.client.XINSCallException;
import org.xins.client.XINSCallRequest;
import org.xins.client.XINSCallResultData;
import org.xins.common.MandatoryArgumentChecker;
import org.xins.common.collections.PropertyReader;
import org.xins.common.service.TargetDescriptor;
import org.xins.common.spec.ErrorCodeSpec;

public class UnsuccessfulXINSCallException
extends XINSCallException
implements XINSCallResultData {
    private final XINSCallResultData _result;
    private ErrorCodeSpec.Type _type;

    private static final String determineDetail(XINSCallResultData result, String detail) throws IllegalArgumentException {
        MandatoryArgumentChecker.check((String)"result", (Object)result);
        String errorCode = result.getErrorCode();
        if (errorCode == null) {
            throw new IllegalArgumentException("result.getErrorCode() == null");
        }
        if (detail == null || detail.length() < 1) {
            return "Error code \"" + errorCode + "\".";
        }
        return "Error code \"" + errorCode + "\": " + detail;
    }

    UnsuccessfulXINSCallException(XINSCallRequest request, TargetDescriptor target, long duration, XINSCallResultData resultData, String detail) throws IllegalArgumentException {
        super("Unsuccessful XINS call result", request, target, duration, UnsuccessfulXINSCallException.determineDetail(resultData, detail), null);
        MandatoryArgumentChecker.check((String)"resultData", (Object)resultData);
        String errorCode = resultData.getErrorCode();
        if (errorCode == null) {
            throw new IllegalArgumentException("resultData.getErrorCode() == null");
        }
        this._result = resultData;
    }

    public final String getErrorCode() {
        return this._result.getErrorCode();
    }

    public final PropertyReader getParameters() {
        return this._result.getParameters();
    }

    public final String getParameter(String name) throws IllegalArgumentException {
        PropertyReader p = this.getParameters();
        if (p == null) {
            return null;
        }
        return p.get(name);
    }

    public final DataElement getDataElement() {
        return this._result.getDataElement();
    }

    void setType(ErrorCodeSpec.Type type) {
        this._type = type;
    }

    public final ErrorCodeSpec.Type getType() {
        return this._type;
    }
}

