/*
 * Decompiled with CFR 0.152.
 */
package org.xins.client;

import org.xins.client.Library;
import org.xins.common.MandatoryArgumentChecker;
import org.xins.common.http.HTTPCallConfig;
import org.xins.common.http.HTTPMethod;
import org.xins.common.service.CallConfig;
import org.xins.common.text.FastStringBuffer;
import org.xins.common.text.TextUtils;

public final class XINSCallConfig
extends CallConfig {
    private static int INSTANCE_COUNT;
    private static Object INSTANCE_COUNT_LOCK;
    private final int _instanceNumber;
    private HTTPCallConfig _httpCallConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XINSCallConfig() {
        Object object = INSTANCE_COUNT_LOCK;
        synchronized (object) {
            this._instanceNumber = ++INSTANCE_COUNT;
        }
        this._httpCallConfig = new HTTPCallConfig();
        String userAgent = "XINS/Java Client Framework " + Library.getVersion();
        this._httpCallConfig.setUserAgent(userAgent);
    }

    HTTPCallConfig getHTTPCallConfig() {
        return this._httpCallConfig;
    }

    public HTTPMethod getHTTPMethod() {
        return this._httpCallConfig.getMethod();
    }

    public void setHTTPMethod(HTTPMethod method) throws IllegalArgumentException {
        MandatoryArgumentChecker.check((String)"method", (Object)method);
        this._httpCallConfig.setMethod(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String describe() {
        HTTPMethod method;
        boolean failOverAllowed;
        Object object = this.getLock();
        synchronized (object) {
            failOverAllowed = this.isFailOverAllowed();
            method = this._httpCallConfig.getMethod();
        }
        FastStringBuffer buffer = new FastStringBuffer(51);
        buffer.append("XINS call config #");
        buffer.append(this._instanceNumber);
        buffer.append(" [failOverAllowed=");
        buffer.append(failOverAllowed);
        buffer.append("; method=");
        buffer.append(TextUtils.quote((String)method.toString()));
        buffer.append(']');
        return buffer.toString();
    }

    static {
        INSTANCE_COUNT_LOCK = new Object();
    }
}

