/*
 * Decompiled with CFR 0.152.
 */
package org.xins.client;

import java.util.Iterator;
import org.apache.log4j.NDC;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.xins.client.XINSCallConfig;
import org.xins.common.MandatoryArgumentChecker;
import org.xins.common.Utils;
import org.xins.common.collections.PropertyReader;
import org.xins.common.collections.PropertyReaderUtils;
import org.xins.common.collections.ProtectedPropertyReader;
import org.xins.common.http.HTTPCallConfig;
import org.xins.common.http.HTTPCallRequest;
import org.xins.common.http.HTTPMethod;
import org.xins.common.service.CallRequest;
import org.xins.common.text.FastStringBuffer;
import org.xins.common.text.TextUtils;
import org.xins.common.xml.Element;
import org.xins.common.xml.ElementSerializer;

public final class XINSCallRequest
extends CallRequest {
    private static final String CLASSNAME = (class$org$xins$client$XINSCallRequest == null ? (class$org$xins$client$XINSCallRequest = XINSCallRequest.class$("org.xins.client.XINSCallRequest")) : class$org$xins$client$XINSCallRequest).getName();
    private static final HTTPStatusCodeVerifier HTTP_STATUS_CODE_VERIFIER = new HTTPStatusCodeVerifier();
    private static final Perl5Compiler PATTERN_COMPILER = new Perl5Compiler();
    public static final String PARAMETER_NAME_PATTERN_STRING = "[a-zA-Z][a-zA-Z0-9_\\-\\.]*";
    private static final Pattern PARAMETER_NAME_PATTERN;
    private static final String CONTEXT_ID_HTTP_PARAMETER_NAME = "_context";
    private static int INSTANCE_COUNT;
    private static final Object SECRET_KEY;
    private final int _instanceNumber;
    private String _asString;
    private final String _functionName;
    private final ProtectedPropertyReader _parameters;
    private Element _dataSection;
    private final ProtectedPropertyReader _httpParams;
    private final Perl5Matcher _patternMatcher = new Perl5Matcher();
    static /* synthetic */ Class class$org$xins$client$XINSCallRequest;

    public XINSCallRequest(String functionName) throws IllegalArgumentException {
        this(functionName, null, null);
    }

    public XINSCallRequest(String functionName, PropertyReader parameters) throws IllegalArgumentException {
        this(functionName, parameters, null);
    }

    public XINSCallRequest(String functionName, PropertyReader parameters, Element dataSection) throws IllegalArgumentException {
        this._instanceNumber = ++INSTANCE_COUNT;
        MandatoryArgumentChecker.check((String)"functionName", (Object)functionName);
        this._functionName = functionName;
        this._parameters = new ProtectedPropertyReader(SECRET_KEY);
        this._httpParams = new ProtectedPropertyReader(SECRET_KEY);
        this.setParameters(parameters);
        this.setDataSection(dataSection);
    }

    public XINSCallRequest(String functionName, PropertyReader parameters, boolean failOverAllowed) throws IllegalArgumentException {
        this(functionName, parameters, failOverAllowed, null);
    }

    public XINSCallRequest(String functionName, PropertyReader parameters, boolean failOverAllowed, HTTPMethod method) throws IllegalArgumentException {
        this(functionName, parameters);
        XINSCallConfig callConfig = new XINSCallConfig();
        callConfig.setFailOverAllowed(failOverAllowed);
        if (method != null) {
            callConfig.setHTTPMethod(method);
        }
        this.setXINSCallConfig(callConfig);
    }

    public String describe() {
        if (this._asString == null) {
            FastStringBuffer buffer = new FastStringBuffer(208, "XINS HTTP request #");
            buffer.append(this._instanceNumber);
            buffer.append(" [config=");
            buffer.append(TextUtils.quote((Object)this.getCallConfig()));
            buffer.append("; function=\"");
            buffer.append(this._functionName);
            if (this._parameters == null || this._parameters.size() < 1) {
                buffer.append("\"; parameters=(null); contextID=");
            } else {
                buffer.append("\"; parameters=\"");
                PropertyReaderUtils.serialize((PropertyReader)this._parameters, (FastStringBuffer)buffer, (String)"-");
                buffer.append("\"; contextID=");
            }
            String contextID = this._httpParams.get(CONTEXT_ID_HTTP_PARAMETER_NAME);
            if (contextID == null || contextID.length() < 1) {
                buffer.append("(null)]");
            } else {
                buffer.append('\"');
                buffer.append(contextID);
                buffer.append("\"]");
            }
            this._asString = buffer.toString();
        }
        return this._asString;
    }

    public XINSCallConfig getXINSCallConfig() {
        return (XINSCallConfig)this.getCallConfig();
    }

    public void setXINSCallConfig(XINSCallConfig callConfig) {
        this.setCallConfig(callConfig);
    }

    public String getFunctionName() {
        return this._functionName;
    }

    private void initParameters() {
        this._parameters.clear(SECRET_KEY);
        this._httpParams.clear(SECRET_KEY);
        this._httpParams.set(SECRET_KEY, "_convention", "_xins-std");
        String contextID = NDC.peek();
        if (contextID != null) {
            this._httpParams.set(SECRET_KEY, CONTEXT_ID_HTTP_PARAMETER_NAME, contextID);
        }
        this._httpParams.set(SECRET_KEY, "_function", this._functionName);
        this._httpParams.set(SECRET_KEY, "function", this._functionName);
        this._asString = null;
    }

    public void setParameters(PropertyReader parameters) throws IllegalArgumentException {
        this.initParameters();
        if (parameters != null) {
            Iterator names = parameters.getNames();
            while (names.hasNext()) {
                String name = (String)names.next();
                String value = parameters.get(name);
                this.setParameter(name, value);
            }
        }
        this._httpParams.set(SECRET_KEY, "_function", this._functionName);
        this._httpParams.set(SECRET_KEY, "function", this._functionName);
        this._asString = null;
    }

    public void setParameter(String name, String value) throws IllegalArgumentException {
        MandatoryArgumentChecker.check((String)"name", (Object)name);
        if (!this._patternMatcher.matches(name, PARAMETER_NAME_PATTERN)) {
            FastStringBuffer buffer = new FastStringBuffer(121, "The parameter name \"");
            buffer.append(name);
            buffer.append("\" does not match the pattern \"");
            buffer.append(PARAMETER_NAME_PATTERN_STRING);
            buffer.append("\".");
            throw new IllegalArgumentException(buffer.toString());
        }
        if ("function".equals(name)) {
            throw new IllegalArgumentException("Parameter name \"function\" is reserved.");
        }
        this._parameters.set(SECRET_KEY, name, value);
        this._httpParams.set(SECRET_KEY, name, value);
    }

    public PropertyReader getParameters() {
        return this._parameters;
    }

    public String getParameter(String name) throws IllegalArgumentException {
        MandatoryArgumentChecker.check((String)"name", (Object)name);
        return this._parameters == null ? null : this._parameters.get(name);
    }

    public void setDataSection(Element dataSection) {
        this._dataSection = dataSection;
        if (dataSection == null) {
            this._httpParams.set(SECRET_KEY, "_data", null);
        } else {
            ElementSerializer serializer = new ElementSerializer();
            String xmlDataSection = serializer.serialize(dataSection);
            this._httpParams.set(SECRET_KEY, "_data", xmlDataSection);
        }
    }

    public Element getDataSection() {
        return this._dataSection;
    }

    public boolean isFailOverAllowed() {
        XINSCallConfig callConfig = this.getXINSCallConfig();
        if (callConfig == null) {
            return false;
        }
        return this.getXINSCallConfig().isFailOverAllowed();
    }

    HTTPCallRequest getHTTPCallRequest() {
        HTTPCallRequest httpRequest = new HTTPCallRequest((PropertyReader)this._httpParams, (org.xins.common.http.HTTPStatusCodeVerifier)HTTP_STATUS_CODE_VERIFIER);
        XINSCallConfig xinsConfig = this.getXINSCallConfig();
        if (xinsConfig != null) {
            HTTPCallConfig httpConfig = new HTTPCallConfig();
            httpConfig.setFailOverAllowed(xinsConfig.isFailOverAllowed());
            httpConfig.setMethod(xinsConfig.getHTTPMethod());
            httpRequest.setHTTPCallConfig(httpConfig);
        }
        return httpRequest;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SECRET_KEY = new Object();
        String THIS_METHOD = "<clinit>()";
        try {
            PARAMETER_NAME_PATTERN = PATTERN_COMPILER.compile(PARAMETER_NAME_PATTERN_STRING, 32768);
        }
        catch (MalformedPatternException mpe) {
            String DETAIL = "The pattern \"[a-zA-Z][a-zA-Z0-9_\\-\\.]*\" is malformed.";
            throw Utils.logProgrammingError((String)CLASSNAME, (String)"<clinit>()", (String)CLASSNAME, (String)"<clinit>()", (String)"The pattern \"[a-zA-Z][a-zA-Z0-9_\\-\\.]*\" is malformed.", (Throwable)mpe);
        }
    }

    private static final class HTTPStatusCodeVerifier
    implements org.xins.common.http.HTTPStatusCodeVerifier {
        private HTTPStatusCodeVerifier() {
        }

        public boolean isAcceptable(int code) {
            return code >= 200 && code <= 299;
        }
    }
}

