/*
 * Decompiled with CFR 0.152.
 */
package org.xins.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Stack;
import org.xins.client.DataElement;
import org.xins.client.Log;
import org.xins.client.XINSCallResultData;
import org.xins.common.MandatoryArgumentChecker;
import org.xins.common.Utils;
import org.xins.common.collections.PropertyReader;
import org.xins.common.collections.ProtectedPropertyReader;
import org.xins.common.text.FastStringBuffer;
import org.xins.common.text.ParseException;
import org.xins.common.text.TextUtils;
import org.xins.common.xml.SAXParserProvider;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XINSCallResultParser {
    private static final String CLASSNAME = (class$org$xins$client$XINSCallResultParser == null ? (class$org$xins$client$XINSCallResultParser = XINSCallResultParser.class$("org.xins.client.XINSCallResultParser")) : class$org$xins$client$XINSCallResultParser).getName();
    private static final String HANDLER_CLASSNAME = (class$org$xins$client$XINSCallResultParser$Handler == null ? (class$org$xins$client$XINSCallResultParser$Handler = XINSCallResultParser.class$("org.xins.client.XINSCallResultParser$Handler")) : class$org$xins$client$XINSCallResultParser$Handler).getName();
    private static final Object PROTECTION_KEY = new Object();
    private static final State ERROR = new State("ERROR");
    private static final State INITIAL = new State("INITIAL");
    private static final State AT_ROOT_LEVEL = new State("AT_ROOT_LEVEL");
    private static final State IN_IGNORABLE_ELEMENT = new State("IN_IGNORABLE_ELEMENT");
    private static final State IN_PARAM_ELEMENT = new State("IN_PARAM_ELEMENT");
    private static final State IN_DATA_SECTION = new State("IN_DATA_SECTION");
    private static final State FINISHED = new State("FINISHED");
    static /* synthetic */ Class class$org$xins$client$XINSCallResultParser;
    static /* synthetic */ Class class$org$xins$client$XINSCallResultParser$Handler;
    static /* synthetic */ Class class$org$xml$sax$Attributes;

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XINSCallResultData parse(byte[] xml) throws IllegalArgumentException, ParseException {
        String THIS_METHOD = "parse(byte[])";
        MandatoryArgumentChecker.check((String)"xml", (Object)xml);
        Handler handler = new Handler();
        ByteArrayInputStream stream = null;
        stream = new ByteArrayInputStream(xml);
        SAXParserProvider.get().parse((InputStream)stream, (DefaultHandler)handler);
        Object var10_5 = null;
        if (stream == null) return handler;
        try {
            stream.close();
            return handler;
        }
        catch (Throwable exception) {
            String SUBJECT_CLASS = stream.getClass().getName();
            String SUBJECT_METHOD = "close()";
            Utils.logProgrammingError((String)CLASSNAME, (String)"parse(byte[])", (String)SUBJECT_CLASS, (String)"close()", null, (Throwable)exception);
        }
        return handler;
        {
            catch (Throwable exception) {
                String detail = exception.getMessage();
                Log.log_2205(exception, detail);
                String message = "Unable to convert the specified string to XML.";
                if (detail == null || (detail = detail.trim()).length() <= 0) throw new ParseException(message, exception, detail);
                FastStringBuffer buffer = new FastStringBuffer(182, "Unable to convert the specified string to XML: ");
                buffer.append(detail);
                message = buffer.toString();
                throw new ParseException(message, exception, detail);
            }
        }
        catch (Throwable throwable) {
            Object var10_6 = null;
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (Throwable exception) {
                String SUBJECT_CLASS = stream.getClass().getName();
                String SUBJECT_METHOD = "close()";
                Utils.logProgrammingError((String)CLASSNAME, (String)"parse(byte[])", (String)SUBJECT_CLASS, (String)"close()", null, (Throwable)exception);
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class State {
        private final String _name;

        private State(String name) throws IllegalArgumentException {
            MandatoryArgumentChecker.check((String)"name", (Object)name);
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }

    private static class Handler
    extends DefaultHandler
    implements XINSCallResultData {
        private State _state = XINSCallResultParser.access$200();
        private String _errorCode;
        private ProtectedPropertyReader _parameters;
        private String _parameterName;
        private final FastStringBuffer _characters = new FastStringBuffer(145);
        private Stack _dataElementStack = new Stack();
        private int _level = -1;

        private Handler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws IllegalArgumentException, SAXException {
            String THIS_METHOD = "startElement(java.lang.String,java.lang.String,java.lang.String," + (class$org$xml$sax$Attributes == null ? (class$org$xml$sax$Attributes = XINSCallResultParser.class$("org.xml.sax.Attributes")) : class$org$xml$sax$Attributes).getName() + ')';
            State currentState = this._state;
            this._state = ERROR;
            namespaceURI = "".equals(namespaceURI) ? null : namespaceURI;
            String quotedNamespaceURI = TextUtils.quote((String)namespaceURI);
            MandatoryArgumentChecker.check((String)"localName", (Object)localName, (String)"atts", (Object)atts);
            ++this._level;
            if (currentState == ERROR) {
                String DETAIL = "_state=" + currentState + "; _level=" + this._level;
                throw Utils.logProgrammingError((String)HANDLER_CLASSNAME, (String)THIS_METHOD, (String)HANDLER_CLASSNAME, (String)THIS_METHOD, (String)DETAIL);
            }
            if (currentState == INITIAL) {
                if (this._level != 0) {
                    String DETAIL = "_state=" + currentState + "; _level=" + this._level;
                    throw Utils.logProgrammingError((String)HANDLER_CLASSNAME, (String)THIS_METHOD, (String)HANDLER_CLASSNAME, (String)THIS_METHOD, (String)DETAIL);
                }
                if (namespaceURI != null || !localName.equals("result")) {
                    Log.log_2200(namespaceURI, localName);
                    String DETAIL = "Root element is \"" + localName + "\" with namespace " + quotedNamespaceURI + " instead of \"result\" with namespace" + " (null).";
                    throw new SAXException(DETAIL);
                }
                String code1 = atts.getValue("errorcode");
                String code2 = atts.getValue("code");
                if (code1 == null || code1.length() == 0) {
                    code1 = null;
                }
                if (code2 == null || code2.length() == 0) {
                    code2 = null;
                }
                if (code1 != null && code2 == null) {
                    this._errorCode = code1;
                } else if (code1 == null && code2 != null) {
                    this._errorCode = code2;
                } else if (code1 == null) {
                    this._errorCode = null;
                } else if (code1.equals(code2)) {
                    this._errorCode = code1;
                } else {
                    String detail = "Found conflicting duplicate value for the error code, since attribute errorcode=\"" + code1 + "\", while attribute code=\"" + code2 + "\".";
                    throw new SAXException(detail);
                }
                this._state = AT_ROOT_LEVEL;
            } else if (currentState == AT_ROOT_LEVEL) {
                if (namespaceURI == null && "param".equals(localName)) {
                    this._parameterName = atts.getValue("name");
                    this._characters.clear();
                    this._state = IN_PARAM_ELEMENT;
                } else if (namespaceURI == null && "data".equals(localName)) {
                    if (this._dataElementStack.size() > 0) {
                        throw new SAXException("Found second data section.");
                    }
                    this._dataElementStack.push(new DataElement(null, "data"));
                    this._state = IN_DATA_SECTION;
                } else {
                    this._state = IN_IGNORABLE_ELEMENT;
                    Log.log_2206(namespaceURI, localName);
                }
            } else {
                if (currentState == IN_PARAM_ELEMENT) {
                    String detail = "Found \"" + localName + "\" element with namespace " + quotedNamespaceURI + " within \"param\" element.";
                    throw new SAXException(detail);
                }
                if (currentState == IN_DATA_SECTION) {
                    DataElement element = new DataElement(namespaceURI, localName);
                    for (int i = 0; i < atts.getLength(); ++i) {
                        String attrNamespaceURI = atts.getURI(i);
                        String attrLocalName = atts.getLocalName(i);
                        String attrValue = atts.getValue(i);
                        element.setAttribute(attrNamespaceURI, attrLocalName, attrValue);
                    }
                    this._dataElementStack.push(element);
                    this._characters.clear();
                    this._state = IN_DATA_SECTION;
                } else if (currentState == IN_IGNORABLE_ELEMENT) {
                    this._state = IN_IGNORABLE_ELEMENT;
                } else {
                    String DETAIL = "_state=" + currentState + "; _level=" + this._level;
                    throw Utils.logProgrammingError((String)HANDLER_CLASSNAME, (String)THIS_METHOD, (String)HANDLER_CLASSNAME, (String)THIS_METHOD, (String)DETAIL);
                }
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws IllegalArgumentException, SAXException {
            String THIS_METHOD = "endElement(java.lang.String,java.lang.String,java.lang.String)";
            State currentState = this._state;
            this._state = ERROR;
            namespaceURI = namespaceURI != null && "".equals(namespaceURI.trim()) ? null : namespaceURI;
            String quotedNamespaceURI = TextUtils.quote((String)namespaceURI);
            MandatoryArgumentChecker.check((String)"localName", (Object)localName);
            if (currentState == ERROR) {
                String DETAIL = "_state=" + currentState + "; _level=" + this._level;
                throw Utils.logProgrammingError((String)HANDLER_CLASSNAME, (String)"endElement(java.lang.String,java.lang.String,java.lang.String)", (String)HANDLER_CLASSNAME, (String)"endElement(java.lang.String,java.lang.String,java.lang.String)", (String)DETAIL);
            }
            if (currentState == AT_ROOT_LEVEL) {
                if (namespaceURI != null || !"result".equals(localName)) {
                    String DETAIL = "Expected end of element of type \"result\" with namespace (null) instead of \"" + localName + "\" with namespace " + quotedNamespaceURI + '.';
                    throw Utils.logProgrammingError((String)HANDLER_CLASSNAME, (String)"endElement(java.lang.String,java.lang.String,java.lang.String)", (String)HANDLER_CLASSNAME, (String)"endElement(java.lang.String,java.lang.String,java.lang.String)", (String)DETAIL);
                }
                this._state = FINISHED;
            } else if (currentState == IN_IGNORABLE_ELEMENT) {
                this._state = this._level == 1 ? AT_ROOT_LEVEL : IN_IGNORABLE_ELEMENT;
            } else if (currentState == IN_DATA_SECTION) {
                DataElement child = (DataElement)this._dataElementStack.pop();
                if (this._dataElementStack.size() == 0) {
                    if (namespaceURI != null || !"data".equals(localName)) {
                        String DETAIL = "Expected end of element of type \"data\" with namespace (null) instead of \"" + localName + "\" with namespace " + quotedNamespaceURI + '.';
                        throw Utils.logProgrammingError((String)HANDLER_CLASSNAME, (String)"endElement(java.lang.String,java.lang.String,java.lang.String)", (String)HANDLER_CLASSNAME, (String)"endElement(java.lang.String,java.lang.String,java.lang.String)", (String)DETAIL);
                    }
                    this._dataElementStack.push(child);
                    this._state = AT_ROOT_LEVEL;
                } else {
                    if (this._characters != null && this._characters.getLength() > 0) {
                        child.setText(this._characters.toString());
                    }
                    DataElement parent = (DataElement)this._dataElementStack.peek();
                    parent.addChild(child);
                    this._state = IN_DATA_SECTION;
                }
            } else if (currentState == IN_PARAM_ELEMENT) {
                boolean noValue;
                if (namespaceURI != null || !"param".equals(localName)) {
                    String DETAIL = "Expected end of element of type \"param\" with namespace (null) instead of \"" + localName + "\" with namespace " + quotedNamespaceURI + '.';
                    throw Utils.logProgrammingError((String)HANDLER_CLASSNAME, (String)"endElement(java.lang.String,java.lang.String,java.lang.String)", (String)HANDLER_CLASSNAME, (String)"endElement(java.lang.String,java.lang.String,java.lang.String)", (String)DETAIL);
                }
                String name = this._parameterName;
                String value = this._characters.toString();
                boolean noName = name == null || name.length() < 1;
                boolean bl = noValue = value == null || value.length() < 1;
                if (noName && noValue) {
                    Log.log_2201();
                } else if (noName) {
                    Log.log_2202(value);
                } else if (noValue) {
                    Log.log_2203(name);
                } else {
                    Log.log_2204(name, value);
                    if (this._parameters == null) {
                        this._parameters = new ProtectedPropertyReader(PROTECTION_KEY);
                    } else {
                        String existingValue = this._parameters.get(name);
                        if (existingValue != null && !existingValue.equals(value)) {
                            String DETAIL = "Found conflicting duplicate value for output parameter \"" + name + "\". Initial value is \"" + existingValue + "\". New value is \"" + value + "\".";
                            throw new SAXException(DETAIL);
                        }
                    }
                    this._parameters.set(PROTECTION_KEY, name, value);
                }
                this._parameterName = null;
                this._state = AT_ROOT_LEVEL;
                this._characters.clear();
            } else {
                String DETAIL = "Unrecognized state: " + currentState + ". Programming error suspected.";
                throw Utils.logProgrammingError((String)HANDLER_CLASSNAME, (String)"endElement(java.lang.String,java.lang.String,java.lang.String)", (String)HANDLER_CLASSNAME, (String)"endElement(java.lang.String,java.lang.String,java.lang.String)", (String)DETAIL);
            }
            --this._level;
            this._characters.clear();
        }

        public void characters(char[] ch, int start, int length) throws IndexOutOfBoundsException, SAXException {
            String text;
            State currentState = this._state;
            this._state = ERROR;
            if (currentState != IN_PARAM_ELEMENT && currentState != IN_DATA_SECTION && currentState != IN_IGNORABLE_ELEMENT && (text = new String(ch, start, length)).trim().length() > 0) {
                String detail = "Found character content \"" + text + "\" in state " + currentState + '.';
                throw new SAXException(detail);
            }
            if (this._characters != null) {
                this._characters.append(ch, start, length);
            }
            this._state = currentState;
        }

        private void assertFinished() throws IllegalStateException {
            if (this._state != FINISHED) {
                String THIS_METHOD = "assertFinished()";
                String SUBJECT_METHOD = Utils.getCallingMethod();
                String DETAIL = "State is " + this._state + " instead of " + FINISHED + '.';
                Utils.logProgrammingError((String)HANDLER_CLASSNAME, (String)"assertFinished()", (String)HANDLER_CLASSNAME, (String)SUBJECT_METHOD, (String)DETAIL);
                throw new IllegalStateException(DETAIL);
            }
        }

        public String getErrorCode() throws IllegalStateException {
            this.assertFinished();
            return this._errorCode;
        }

        public PropertyReader getParameters() throws IllegalStateException {
            this.assertFinished();
            return this._parameters;
        }

        public DataElement getDataElement() throws IllegalStateException {
            this.assertFinished();
            if (this._dataElementStack.isEmpty()) {
                return null;
            }
            return (DataElement)this._dataElementStack.peek();
        }
    }
}

