/*
 * Decompiled with CFR 0.152.
 */
package org.xins.client;

import java.util.HashMap;
import java.util.Iterator;
import org.xins.client.AbstractCAPI;
import org.xins.client.AbstractCAPIErrorCodeException;
import org.xins.client.DisabledFunctionException;
import org.xins.client.FileServiceCaller;
import org.xins.client.InternalErrorException;
import org.xins.client.InvalidRequestException;
import org.xins.client.InvalidResultXINSCallException;
import org.xins.client.Log;
import org.xins.client.UnacceptableErrorCodeXINSCallException;
import org.xins.client.UnsuccessfulXINSCallException;
import org.xins.client.XINSCallConfig;
import org.xins.client.XINSCallException;
import org.xins.client.XINSCallRequest;
import org.xins.client.XINSCallResult;
import org.xins.client.XINSCallResultData;
import org.xins.client.XINSCallResultParser;
import org.xins.common.MandatoryArgumentChecker;
import org.xins.common.Utils;
import org.xins.common.collections.PropertyReader;
import org.xins.common.collections.PropertyReaderUtils;
import org.xins.common.http.HTTPCallConfig;
import org.xins.common.http.HTTPCallException;
import org.xins.common.http.HTTPCallRequest;
import org.xins.common.http.HTTPCallResult;
import org.xins.common.http.HTTPServiceCaller;
import org.xins.common.http.StatusCodeHTTPCallException;
import org.xins.common.service.CallConfig;
import org.xins.common.service.CallException;
import org.xins.common.service.CallExceptionList;
import org.xins.common.service.CallRequest;
import org.xins.common.service.CallResult;
import org.xins.common.service.ConnectionRefusedCallException;
import org.xins.common.service.ConnectionTimeOutCallException;
import org.xins.common.service.Descriptor;
import org.xins.common.service.GenericCallException;
import org.xins.common.service.IOCallException;
import org.xins.common.service.ServiceCaller;
import org.xins.common.service.SocketTimeOutCallException;
import org.xins.common.service.TargetDescriptor;
import org.xins.common.service.TotalTimeOutCallException;
import org.xins.common.service.UnexpectedExceptionCallException;
import org.xins.common.service.UnknownHostCallException;
import org.xins.common.service.UnsupportedProtocolException;
import org.xins.common.spec.ErrorCodeSpec;
import org.xins.common.text.FastStringBuffer;
import org.xins.common.text.ParseException;
import org.xins.common.text.TextUtils;
import org.xins.common.xml.Element;
import org.xins.logdoc.AbstractLogdocSerializable;
import org.xins.logdoc.ExceptionUtils;
import org.xins.logdoc.LogdocSerializable;

public final class XINSServiceCaller
extends ServiceCaller {
    private static final String CLASSNAME = (class$org$xins$client$XINSServiceCaller == null ? (class$org$xins$client$XINSServiceCaller = XINSServiceCaller.class$("org.xins.client.XINSServiceCaller")) : class$org$xins$client$XINSServiceCaller).getName();
    private final XINSCallResultParser _parser = new XINSCallResultParser();
    private AbstractCAPI _capi;
    private HashMap _serviceCallers;
    static /* synthetic */ Class class$org$xins$client$XINSServiceCaller;
    static /* synthetic */ Class class$org$xins$client$XINSCallRequest;
    static /* synthetic */ Class class$org$xins$client$XINSCallConfig;
    static /* synthetic */ Class class$org$xins$common$service$ServiceCaller;
    static /* synthetic */ Class class$org$xins$common$service$CallRequest;
    static /* synthetic */ Class class$org$xins$common$service$CallConfig;
    static /* synthetic */ Class class$org$xins$common$service$TargetDescriptor;
    static /* synthetic */ Class class$org$xins$common$http$HTTPServiceCaller;
    static /* synthetic */ Class class$org$xins$common$http$HTTPCallRequest;
    static /* synthetic */ Class class$org$xins$common$http$HTTPCallConfig;

    public XINSServiceCaller(Descriptor descriptor, XINSCallConfig callConfig) throws IllegalArgumentException, UnsupportedProtocolException {
        super(descriptor, (CallConfig)callConfig);
    }

    public XINSServiceCaller(Descriptor descriptor) throws IllegalArgumentException, UnsupportedProtocolException {
        this(descriptor, null);
    }

    public XINSServiceCaller() {
        this(null, null);
    }

    protected boolean isProtocolSupportedImpl(String protocol) {
        return "http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol) || "file".equalsIgnoreCase(protocol);
    }

    public void setDescriptor(Descriptor descriptor) {
        super.setDescriptor(descriptor);
        if (this._serviceCallers == null) {
            this._serviceCallers = new HashMap();
        }
        if (descriptor != null) {
            Iterator targets = descriptor.iterateTargets();
            while (targets.hasNext()) {
                Object serviceCaller;
                TargetDescriptor nextTarget = (TargetDescriptor)targets.next();
                String protocol = nextTarget.getProtocol();
                if ("http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol)) {
                    serviceCaller = new HTTPServiceCaller((Descriptor)nextTarget);
                    this._serviceCallers.put(nextTarget, serviceCaller);
                    continue;
                }
                if (!"file".equalsIgnoreCase(protocol)) continue;
                serviceCaller = new FileServiceCaller((Descriptor)nextTarget);
                this._serviceCallers.put(nextTarget, serviceCaller);
            }
        } else {
            this._serviceCallers.clear();
        }
    }

    void setCAPI(AbstractCAPI capi) {
        this._capi = capi;
    }

    protected CallConfig getDefaultCallConfig() {
        return new XINSCallConfig();
    }

    protected final void setXINSCallConfig(XINSCallConfig config) throws IllegalArgumentException {
        super.setCallConfig((CallConfig)config);
    }

    public final XINSCallConfig getXINSCallConfig() {
        return (XINSCallConfig)this.getCallConfig();
    }

    public XINSCallResult call(XINSCallRequest request, XINSCallConfig callConfig) throws IllegalArgumentException, GenericCallException, HTTPCallException, XINSCallException {
        XINSCallResult result;
        long start = System.currentTimeMillis();
        try {
            result = (XINSCallResult)this.doCall(request, callConfig);
        }
        catch (Throwable exception) {
            if (!(exception instanceof UnsuccessfulXINSCallException) || ((UnsuccessfulXINSCallException)((Object)exception)).getType() != ErrorCodeSpec.FUNCTIONAL) {
                long duration = System.currentTimeMillis() - start;
                PropertyReader p = request.getParameters();
                Element dataSection = request.getDataSection();
                String s = dataSection != null ? "_data=" + dataSection.toString() : null;
                LogdocSerializable params = PropertyReaderUtils.serialize((PropertyReader)p, (String)"(null)", (String)"&", s);
                ExceptionFormatter chain = new ExceptionFormatter(exception);
                Log.log_2113(request.getFunctionName(), params, duration, (LogdocSerializable)chain);
            }
            if (exception instanceof GenericCallException) {
                throw (GenericCallException)exception;
            }
            if (exception instanceof HTTPCallException) {
                throw (HTTPCallException)exception;
            }
            if (exception instanceof XINSCallException) {
                throw (XINSCallException)((Object)exception);
            }
            String THIS_METHOD = "call(" + (class$org$xins$client$XINSCallRequest == null ? (class$org$xins$client$XINSCallRequest = XINSServiceCaller.class$("org.xins.client.XINSCallRequest")) : class$org$xins$client$XINSCallRequest).getName() + ',' + (class$org$xins$client$XINSCallConfig == null ? (class$org$xins$client$XINSCallConfig = XINSServiceCaller.class$("org.xins.client.XINSCallConfig")) : class$org$xins$client$XINSCallConfig).getName() + ')';
            String SUBJECT_CLASS = (class$org$xins$common$service$ServiceCaller == null ? (class$org$xins$common$service$ServiceCaller = XINSServiceCaller.class$("org.xins.common.service.ServiceCaller")) : class$org$xins$common$service$ServiceCaller).getName();
            String SUBJECT_METHOD = "doCall(" + (class$org$xins$common$service$CallRequest == null ? (class$org$xins$common$service$CallRequest = XINSServiceCaller.class$("org.xins.common.service.CallRequest")) : class$org$xins$common$service$CallRequest).getName() + ',' + (class$org$xins$common$service$CallConfig == null ? (class$org$xins$common$service$CallConfig = XINSServiceCaller.class$("org.xins.common.service.CallConfig")) : class$org$xins$common$service$CallConfig).getName() + ')';
            throw Utils.logProgrammingError((String)CLASSNAME, (String)THIS_METHOD, (String)SUBJECT_CLASS, (String)SUBJECT_METHOD, null, (Throwable)exception);
        }
        return result;
    }

    public XINSCallResult call(XINSCallRequest request) throws IllegalArgumentException, GenericCallException, HTTPCallException, XINSCallException {
        return this.call(request, null);
    }

    public Object doCallImpl(CallRequest request, CallConfig callConfig, TargetDescriptor target) throws IllegalArgumentException, ClassCastException, GenericCallException, HTTPCallException, XINSCallException {
        XINSCallResultData resultData;
        HTTPCallResult httpResult;
        String METHODNAME = "doCallImpl(" + (class$org$xins$common$service$CallRequest == null ? (class$org$xins$common$service$CallRequest = XINSServiceCaller.class$("org.xins.common.service.CallRequest")) : class$org$xins$common$service$CallRequest).getName() + ',' + (class$org$xins$common$service$TargetDescriptor == null ? (class$org$xins$common$service$TargetDescriptor = XINSServiceCaller.class$("org.xins.common.service.TargetDescriptor")) : class$org$xins$common$service$TargetDescriptor).getName() + ')';
        MandatoryArgumentChecker.check((String)"request", (Object)request, (String)"callConfig", (Object)callConfig, (String)"target", (Object)target);
        XINSCallRequest xinsRequest = (XINSCallRequest)request;
        XINSCallConfig xinsConfig = (XINSCallConfig)callConfig;
        String url = target.getURL();
        String function = xinsRequest.getFunctionName();
        PropertyReader p = xinsRequest.getParameters();
        String dataSection = null;
        if (xinsRequest.getDataSection() != null) {
            dataSection = "_data=" + xinsRequest.getDataSection().toString();
        }
        LogdocSerializable params = PropertyReaderUtils.serialize((PropertyReader)p, (String)"", (String)"&", dataSection);
        int totalTimeOut = target.getTotalTimeOut();
        int connectionTimeOut = target.getConnectionTimeOut();
        int socketTimeOut = target.getSocketTimeOut();
        Log.log_2100(url, function, params, totalTimeOut, connectionTimeOut, socketTimeOut);
        HTTPCallRequest httpRequest = xinsRequest.getHTTPCallRequest();
        HTTPCallConfig httpConfig = xinsConfig.getHTTPCallConfig();
        long start = System.currentTimeMillis();
        String SUBJECT_CLASS = (class$org$xins$common$http$HTTPServiceCaller == null ? (class$org$xins$common$http$HTTPServiceCaller = XINSServiceCaller.class$("org.xins.common.http.HTTPServiceCaller")) : class$org$xins$common$http$HTTPServiceCaller).getName();
        String SUBJECT_METHOD = "call(" + (class$org$xins$common$http$HTTPCallRequest == null ? (class$org$xins$common$http$HTTPCallRequest = XINSServiceCaller.class$("org.xins.common.http.HTTPCallRequest")) : class$org$xins$common$http$HTTPCallRequest).getName() + ',' + (class$org$xins$common$http$HTTPCallConfig == null ? (class$org$xins$common$http$HTTPCallConfig = XINSServiceCaller.class$("org.xins.common.http.HTTPCallConfig")) : class$org$xins$common$http$HTTPCallConfig).getName() + ',' + (class$org$xins$common$service$TargetDescriptor == null ? (class$org$xins$common$service$TargetDescriptor = XINSServiceCaller.class$("org.xins.common.service.TargetDescriptor")) : class$org$xins$common$service$TargetDescriptor).getName() + ')';
        try {
            ServiceCaller serviceCaller = (ServiceCaller)this._serviceCallers.get(target);
            httpResult = (HTTPCallResult)serviceCaller.doCallImpl((CallRequest)httpRequest, (CallConfig)httpConfig, target);
        }
        catch (GenericCallException exception) {
            long duration = exception.getDuration();
            if (exception instanceof UnknownHostCallException) {
                Log.log_2102(url, function, params, duration);
            } else if (exception instanceof ConnectionRefusedCallException) {
                Log.log_2103(url, function, params, duration);
            } else if (exception instanceof ConnectionTimeOutCallException) {
                Log.log_2104(url, function, params, duration, connectionTimeOut);
            } else if (exception instanceof SocketTimeOutCallException) {
                Log.log_2105(url, function, params, duration, socketTimeOut);
            } else if (exception instanceof TotalTimeOutCallException) {
                Log.log_2106(url, function, params, duration, totalTimeOut);
            } else if (exception instanceof IOCallException) {
                Log.log_2109(exception, url, function, params, duration);
            } else if (exception instanceof UnexpectedExceptionCallException) {
                Log.log_2111(ExceptionUtils.getCause((Throwable)exception), url, function, params, duration);
            } else {
                String DETAIL = "Unrecognized GenericCallException subclass " + ((Object)((Object)exception)).getClass().getName() + '.';
                Utils.logProgrammingError((String)CLASSNAME, (String)METHODNAME, (String)SUBJECT_CLASS, (String)SUBJECT_METHOD, (String)DETAIL);
            }
            throw exception;
        }
        catch (HTTPCallException exception) {
            long duration = exception.getDuration();
            if (exception instanceof StatusCodeHTTPCallException) {
                int code = ((StatusCodeHTTPCallException)exception).getStatusCode();
                Log.log_2108(url, function, params, duration, code);
            } else {
                String DETAIL = "Unrecognized HTTPCallException subclass " + ((Object)((Object)exception)).getClass().getName() + '.';
                Utils.logProgrammingError((String)CLASSNAME, (String)METHODNAME, (String)SUBJECT_CLASS, (String)SUBJECT_METHOD, (String)DETAIL);
            }
            throw exception;
        }
        catch (Throwable exception) {
            long duration = System.currentTimeMillis() - start;
            Utils.logProgrammingError((String)CLASSNAME, (String)METHODNAME, (String)SUBJECT_CLASS, (String)SUBJECT_METHOD, null, (Throwable)exception);
            FastStringBuffer message = new FastStringBuffer(190);
            message.append(SUBJECT_CLASS);
            message.append('.');
            message.append(SUBJECT_METHOD);
            message.append(" threw unexpected ");
            message.append(exception.getClass().getName());
            message.append(". Message: ");
            message.append(TextUtils.quote((String)exception.getMessage()));
            message.append('.');
            Log.log_2111(exception, url, function, params, duration);
            throw new UnexpectedExceptionCallException(request, target, duration, message.toString(), exception);
        }
        long duration = httpResult.getDuration();
        byte[] httpData = httpResult.getData();
        if (httpData == null || httpData.length == 0) {
            Log.log_2110(url, function, params, duration, "No data received.");
            throw InvalidResultXINSCallException.noDataReceived(xinsRequest, target, duration);
        }
        try {
            resultData = this._parser.parse(httpData);
        }
        catch (ParseException e) {
            String detail = e.getDetail();
            String message = detail != null && detail.trim().length() > 0 ? "Failed to parse result: " + detail.trim() : "Failed to parse result.";
            Log.log_2110(url, function, params, duration, message);
            throw InvalidResultXINSCallException.parseError(httpData, xinsRequest, target, duration, e);
        }
        String errorCode = resultData.getErrorCode();
        if (errorCode != null) {
            boolean functionalError = false;
            ErrorCodeSpec.Type type = null;
            try {
                if (this._capi != null) {
                    type = this._capi.getAPISpecification().getFunction(function).getErrorCode(errorCode).getType();
                    functionalError = type == ErrorCodeSpec.FUNCTIONAL;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (functionalError) {
                Log.log_2115(url, function, params, duration, errorCode);
            } else {
                Log.log_2112(url, function, params, duration, errorCode);
            }
            if (errorCode.charAt(0) == '_') {
                if (errorCode.equals("_DisabledFunction")) {
                    throw new DisabledFunctionException(xinsRequest, target, duration, resultData);
                }
                if (errorCode.equals("_InternalError") || errorCode.equals("_InvalidResponse")) {
                    throw new InternalErrorException(xinsRequest, target, duration, resultData);
                }
                if (errorCode.equals("_InvalidRequest")) {
                    throw new InvalidRequestException(xinsRequest, target, duration, resultData);
                }
                throw new UnacceptableErrorCodeXINSCallException(xinsRequest, target, duration, resultData);
            }
            if (this._capi == null) {
                throw new UnsuccessfulXINSCallException(xinsRequest, target, duration, resultData, null);
            }
            AbstractCAPIErrorCodeException ex = this._capi.createErrorCodeException(xinsRequest, target, duration, resultData);
            if (ex != null) {
                ex.setType(type);
                throw ex;
            }
            String ver = this._capi.getXINSVersion();
            if (ver.startsWith("0.") || ver.startsWith("1.0.") || ver.startsWith("1.1.")) {
                throw new UnsuccessfulXINSCallException(xinsRequest, target, duration, resultData, null);
            }
            throw new UnacceptableErrorCodeXINSCallException(xinsRequest, target, duration, resultData);
        }
        Log.log_2101(url, function, params, duration);
        return resultData;
    }

    protected CallResult createCallResult(CallRequest request, TargetDescriptor succeededTarget, long duration, CallExceptionList exceptions, Object result) throws ClassCastException {
        XINSCallResult r = new XINSCallResult((XINSCallRequest)request, succeededTarget, duration, exceptions, (XINSCallResultData)result);
        return r;
    }

    protected boolean shouldFailOver(CallRequest request, CallConfig callConfig, CallExceptionList exceptions) {
        String s;
        int code;
        CallException exception = exceptions.last();
        boolean should = super.shouldFailOver(request, callConfig, exceptions) ? true : (exception instanceof StatusCodeHTTPCallException ? (code = ((StatusCodeHTTPCallException)exception).getStatusCode()) < 200 || code > 299 : (exception instanceof UnsuccessfulXINSCallException ? "_InvalidRequest".equals(s = ((UnsuccessfulXINSCallException)exception).getErrorCode()) || "_DisabledFunction".equals(s) : false));
        return should;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ExceptionFormatter
    extends AbstractLogdocSerializable {
        private Throwable _first;

        private ExceptionFormatter(Throwable first) {
            this._first = first;
        }

        protected String initialize() {
            return this._first.getMessage();
        }
    }
}

