/*
 * Decompiled with CFR 0.152.
 */
package org.xins.client.async;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.xins.client.AbstractCAPI;
import org.xins.client.AbstractCAPICallRequest;
import org.xins.client.async.CallCAPIThread;
import org.xins.client.async.CallFailedEvent;
import org.xins.client.async.CallListener;
import org.xins.client.async.CallSucceededEvent;

public class AsynchronousCall {
    private List _listeners = new ArrayList();

    public void addCallListener(CallListener listener) {
        this._listeners.add(listener);
    }

    public void removeCallListener(CallListener listener) {
        this._listeners.remove(listener);
    }

    public void call(AbstractCAPI capi, AbstractCAPICallRequest request) {
        CallNotifyThread thread = new CallNotifyThread(capi, request, this._listeners);
        thread.start();
    }

    private static class CallNotifyThread
    extends CallCAPIThread {
        private final List _listeners;

        CallNotifyThread(AbstractCAPI capi, AbstractCAPICallRequest request, List listeners) {
            super(capi, request);
            this._listeners = Collections.unmodifiableList(listeners);
        }

        public void run() {
            super.run();
            if (this.getException() == null) {
                CallSucceededEvent event = new CallSucceededEvent(this.getCAPI(), this.getRequest(), this.getDuration(), this.getResult());
                Iterator itListeners = this._listeners.iterator();
                while (itListeners.hasNext()) {
                    CallListener listener = (CallListener)itListeners.next();
                    listener.callSucceeded(event);
                }
            } else {
                CallFailedEvent event = new CallFailedEvent(this.getCAPI(), this.getRequest(), this.getDuration(), this.getException());
                Iterator itListeners = this._listeners.iterator();
                while (itListeners.hasNext()) {
                    CallListener listener = (CallListener)itListeners.next();
                    listener.callFailed(event);
                }
            }
        }
    }
}

