/*
 * Decompiled with CFR 0.152.
 */
package org.xins.client.async;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.xins.client.AbstractCAPI;
import org.xins.client.AbstractCAPICallRequest;
import org.xins.client.AbstractCAPICallResult;
import org.xins.common.service.CallException;

public class CallCAPIThread
extends Thread {
    private AbstractCAPI _capi;
    private AbstractCAPICallRequest _request;
    private long _duration = -1L;
    private AbstractCAPICallResult _result;
    private Exception _exception;

    public CallCAPIThread(AbstractCAPI capi, AbstractCAPICallRequest request) {
        this._capi = capi;
        this._request = request;
    }

    public void run() {
        long startTime = System.currentTimeMillis();
        try {
            String functionName = "call" + this._request.functionName();
            Class[] callArgumentsClass = new Class[]{this._request.getClass()};
            Object[] callArguments = new Object[]{this._request};
            Method callMethod = this._capi.getClass().getMethod(functionName, callArgumentsClass);
            this._result = (AbstractCAPICallResult)callMethod.invoke((Object)this._capi, callArguments);
            this._duration = this._result.duration();
        }
        catch (InvocationTargetException itex) {
            this._exception = (Exception)itex.getTargetException();
            this._duration = this._exception instanceof CallException ? ((CallException)this._exception).getDuration() : System.currentTimeMillis() - startTime;
        }
        catch (Exception ex) {
            this._exception = ex;
            this._duration = -1L;
        }
    }

    public AbstractCAPI getCAPI() {
        return this._capi;
    }

    public AbstractCAPICallRequest getRequest() {
        return this._request;
    }

    public AbstractCAPICallResult getResult() {
        return this._result;
    }

    public Exception getException() {
        return this._exception;
    }

    public long getDuration() {
        return this._duration;
    }
}

