/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.AbstractConnection;
import org.xsocket.ClosedConnectionException;
import org.xsocket.IBlockingConnection;
import org.xsocket.util.TextUtils;

public final class BlockingConnection
extends AbstractConnection
implements IBlockingConnection {
    private static final Logger LOG = Logger.getLogger(BlockingConnection.class.getName());
    public static final int DEFAULT_PREALLOCATION_SIZE = 1024;
    private SocketChannel channel = null;
    private int preallocationSize = 1024;
    private ByteBuffer preallocatedBuffer = null;

    public BlockingConnection(String hostname, int port) throws IOException {
        this(SocketChannel.open(new InetSocketAddress(hostname, port)));
    }

    public BlockingConnection(SocketChannel channel) throws IOException {
        this(channel, 1024);
    }

    public BlockingConnection(SocketChannel channel, int receivebufferPreallocationSize) throws IOException {
        if (channel == null) {
            throw new NullPointerException("parameter channel is not set");
        }
        this.channel = channel;
        this.preallocationSize = receivebufferPreallocationSize;
        channel.configureBlocking(true);
    }

    protected SocketChannel getAssignedSocketChannel() {
        return this.channel;
    }

    public ByteBuffer[] receiveRecord(String delimiter) throws IOException {
        AbstractConnection.ByteBufferArrayChannel channel = new AbstractConnection.ByteBufferArrayChannel();
        while (true) {
            try {
                this.getReceiveQueue().readRecord(delimiter, channel);
                return channel.getContent();
            }
            catch (BufferUnderflowException bue) {
                this.getReceiveQueue().append(this.readPhysical());
                continue;
            }
            break;
        }
    }

    public String receiveWord(String delimiter, String encoding) throws IOException {
        while (true) {
            try {
                AbstractConnection.ByteBufferArrayChannel channel = new AbstractConnection.ByteBufferArrayChannel();
                this.getReceiveQueue().readRecord(delimiter, channel);
                return TextUtils.toString(channel.getContent(), encoding);
            }
            catch (BufferUnderflowException bue) {
                this.getReceiveQueue().append(this.readPhysical());
                continue;
            }
            break;
        }
    }

    public String receiveWord(String delimiter) throws IOException {
        return this.receiveWord(delimiter, this.getDefaultEncoding());
    }

    public byte receiveByte() throws IOException, BufferUnderflowException {
        byte b = 0;
        boolean found = false;
        do {
            try {
                b = this.getReceiveQueue().readByte();
                found = true;
            }
            catch (BufferUnderflowException bue) {
                this.getReceiveQueue().append(this.readPhysical());
            }
        } while (!found);
        return b;
    }

    public double receiveDouble() throws IOException, BufferUnderflowException {
        double d = 0.0;
        boolean found = false;
        do {
            try {
                d = this.getReceiveQueue().readDouble();
                found = true;
            }
            catch (BufferUnderflowException bue) {
                this.getReceiveQueue().append(this.readPhysical());
            }
        } while (!found);
        return d;
    }

    public int receiveInt() throws IOException, BufferUnderflowException {
        int i = 0;
        boolean found = false;
        do {
            try {
                i = this.getReceiveQueue().readInt();
                found = true;
            }
            catch (BufferUnderflowException bue) {
                this.getReceiveQueue().append(this.readPhysical());
            }
        } while (!found);
        return i;
    }

    public long receiveLong() throws IOException, BufferUnderflowException {
        long l = 0L;
        boolean found = false;
        do {
            try {
                l = this.getReceiveQueue().readLong();
                found = true;
            }
            catch (BufferUnderflowException bue) {
                this.getReceiveQueue().append(this.readPhysical());
            }
        } while (!found);
        return l;
    }

    public synchronized long write(ByteBuffer[] buffers) throws ClosedConnectionException, IOException {
        long written = 0L;
        for (ByteBuffer buffer : buffers) {
            written += (long)(buffer.limit() - buffer.position());
            this.writePhysical(buffers);
        }
        return written;
    }

    protected ByteBuffer acquireMemory() {
        if (this.preallocatedBuffer == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("allocate new physical memory (new size: " + TextUtils.printFormatedBytesSize(this.preallocationSize) + ")");
            }
            this.preallocatedBuffer = ByteBuffer.allocate(this.preallocationSize);
        }
        ByteBuffer result = this.preallocatedBuffer;
        this.preallocatedBuffer = null;
        return result;
    }

    protected void recycleMemory(ByteBuffer buffer) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("free buffer " + buffer + " has been put back");
        }
        this.preallocatedBuffer = buffer;
    }
}

