/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.util.TextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ByteBufferParser {
    private static final Logger LOG = Logger.getLogger(ByteBufferParser.class.getName());

    ByteBufferParser() {
    }

    public Index find(LinkedList<ByteBuffer> bufferQueue, byte[] delimiter) {
        return this.find(bufferQueue, new Index(delimiter));
    }

    public Index find(LinkedList<ByteBuffer> bufferQueue, Index index) {
        block0: for (int bufNr = index.numberOfScannedBuffers; bufNr < bufferQueue.size(); ++bufNr) {
            ByteBuffer buffer = bufferQueue.get(bufNr);
            if (buffer == null) continue;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("pre index " + index.toString());
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("check " + TextUtils.toByteString(buffer.duplicate()));
            }
            int savedPos = buffer.position();
            int savedLimit = buffer.limit();
            int pos = 0;
            while (buffer.hasRemaining()) {
                boolean found = index.check(buffer, bufNr, pos);
                if (found) {
                    buffer.position(savedPos);
                    buffer.limit(savedLimit);
                    break block0;
                }
                ++pos;
            }
            buffer.position(savedPos);
            buffer.limit(savedLimit);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("found=" + index.isDelimiterFound() + " post index " + index.toString());
        }
        return index;
    }

    public void extract(LinkedList<ByteBuffer> bufferQueue, Index index, WritableByteChannel outChannel) throws IOException {
        assert (index.isValid) : "Index is invalid";
        if (!index.isDelimiterFound()) {
            return;
        }
        for (int i = 0; i < index.startBuffer; ++i) {
            outChannel.write(bufferQueue.removeFirst());
        }
        ByteBuffer startBuffer = bufferQueue.removeFirst();
        int savedLimit = startBuffer.limit();
        startBuffer.position(0).limit(index.startBufferPos);
        ByteBuffer leftPart = startBuffer.slice();
        if (leftPart.limit() > 0) {
            outChannel.write(leftPart);
        }
        if (index.startBufferPos + index.delimiterLength != savedLimit) {
            if (index.startBufferPos + index.delimiterLength < savedLimit) {
                startBuffer.limit(savedLimit);
                startBuffer.position(index.startBufferPos + index.delimiter.length);
                ByteBuffer rightPart = startBuffer.slice();
                bufferQueue.addFirst(rightPart);
            } else if (index.startBufferPos + index.delimiterLength > savedLimit) {
                int remainingTerminatorLength = index.delimiterLength - (savedLimit - index.startBufferPos);
                do {
                    ByteBuffer buffer;
                    int bufferLength;
                    if (remainingTerminatorLength >= (bufferLength = (buffer = bufferQueue.removeFirst()).limit() - buffer.position())) {
                        remainingTerminatorLength -= bufferLength;
                        continue;
                    }
                    buffer.position(remainingTerminatorLength);
                    ByteBuffer rightPart = buffer.slice();
                    bufferQueue.addFirst(rightPart);
                    remainingTerminatorLength = 0;
                } while (remainingTerminatorLength > 0);
            }
        }
        index.isValid = false;
    }

    public void extractAvailable(LinkedList<ByteBuffer> bufferQueue, Index index, WritableByteChannel outChannel) throws IOException {
        assert (index.isValid) : "Index is invalid";
        if (index.found) {
            this.extract(bufferQueue, index, outChannel);
        } else {
            if (index.startBuffer != -1) {
                for (int i = 0; i < index.startBuffer; ++i) {
                    outChannel.write(bufferQueue.removeFirst());
                }
                ByteBuffer startBuffer = bufferQueue.removeFirst();
                int savedLimit = startBuffer.limit();
                startBuffer.position(0).limit(index.startBufferPos);
                ByteBuffer leftPart = startBuffer.slice();
                if (leftPart.limit() > 0) {
                    outChannel.write(leftPart);
                }
                if (index.startBufferPos < savedLimit) {
                    startBuffer.limit(savedLimit);
                    startBuffer.position(index.startBufferPos);
                    ByteBuffer rightPart = startBuffer.slice();
                    bufferQueue.addFirst(rightPart);
                }
            } else {
                while (!bufferQueue.isEmpty()) {
                    outChannel.write(bufferQueue.removeFirst());
                }
            }
            index.isValid = false;
        }
    }

    static final class Index {
        public static final int NULL = -1;
        private int startBuffer = -1;
        private int startBufferPos = -1;
        private boolean isValid = true;
        private boolean found = false;
        private byte[] delimiter = null;
        private int delimiterLength = 0;
        private int delimiterPos = 0;
        private int numberOfScannedBuffers = 0;

        Index(byte[] delimiter) {
            this.delimiter = delimiter;
            this.delimiterLength = delimiter.length;
        }

        private boolean check(ByteBuffer buffer, int bufferNumber, int currentPosition) {
            this.numberOfScannedBuffers = bufferNumber + 1;
            byte b = buffer.get();
            if (this.delimiterPos > 0) {
                if (b == this.delimiter[this.delimiterPos]) {
                    if (this.delimiterPos + 1 == this.delimiterLength) {
                        this.found = true;
                        return true;
                    }
                    ++this.delimiterPos;
                } else {
                    this.delimiterPos = 0;
                    this.startBuffer = -1;
                    this.startBufferPos = -1;
                }
            }
            if (this.delimiterPos == 0 && b == this.delimiter[this.delimiterPos]) {
                this.startBuffer = bufferNumber;
                this.startBufferPos = currentPosition;
                ++this.delimiterPos;
            }
            return false;
        }

        public boolean isDelimiterFound() {
            return this.found;
        }

        public boolean isDataAvailable() {
            return this.startBuffer != 0 || this.startBufferPos != 0;
        }

        public String toString() {
            return "delimiter=" + TextUtils.toByteString(this.delimiter) + " (pos=" + this.delimiterPos + ")" + " handledBuffers=" + this.numberOfScannedBuffers + " delimiter Start (buf=" + this.startBuffer + ", pos=" + this.startBufferPos + ")" + " found=" + this.found;
        }
    }
}

