/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DirectMemoryManager {
    private static final Logger LOG = Logger.getLogger(DirectMemoryManager.class.getName());
    private int preallocationSize = 4096;
    private ByteBuffer buffer = null;

    DirectMemoryManager() {
    }

    public void setPreallocationSize(int size) {
        this.preallocationSize = size;
    }

    public ByteBuffer acquireMemory() {
        return this.acquireMemory(1);
    }

    public ByteBuffer acquireMemory(int minBufferSize) {
        if (this.buffer == null) {
            this.buffer = this.newBuffer(this.preallocationSize);
        } else if (this.buffer.limit() < minBufferSize) {
            int allocationSize = this.preallocationSize;
            if (allocationSize < minBufferSize) {
                allocationSize = minBufferSize * 10;
            }
            this.buffer = this.newBuffer(allocationSize);
        }
        ByteBuffer buf = this.buffer;
        this.buffer = null;
        return buf;
    }

    public ByteBuffer newBuffer(int size) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("allocate new physical memory (size: " + size + ")");
        }
        return ByteBuffer.allocateDirect(size);
    }

    public void recycleMemory(ByteBuffer buf) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("free buffer " + this.buffer + " has been put back");
        }
        this.buffer = buf;
    }

    public ByteBuffer extractAndRecycleMemory(ByteBuffer buffer) {
        if (buffer.limit() == buffer.capacity()) {
            return buffer;
        }
        int savedLimit = buffer.limit();
        ByteBuffer slicedPart = buffer.slice();
        buffer.position(savedLimit);
        buffer.limit(buffer.capacity());
        ByteBuffer unused = buffer.slice();
        this.recycleMemory(unused);
        return slicedPart;
    }
}

