/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.xsocket.server.DirectMemoryManager;
import org.xsocket.server.IDispatcher;
import org.xsocket.server.INonBlockingConnection;
import org.xsocket.server.InternalHandler;
import org.xsocket.server.NonBlockingConnection;
import org.xsocket.server.WorkerPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Dispatcher
implements IDispatcher {
    private static final Logger LOG = Logger.getLogger(Dispatcher.class.getName());
    private boolean isRunning = true;
    private static ThreadLocal<DirectMemoryManager> memoryManager = new ThreadLocal();
    private String name = null;
    private String domain = null;
    private Selector selector = null;
    private final List<NonBlockingConnection> newConnections = Collections.synchronizedList(new ArrayList());
    private int preallocationSize = 1024;
    private WorkerPool workerPool = null;
    private int numberOfConnectionTimeouts = 0;
    private int numberOfIdleTimeouts = 0;
    private TimeoutWatchdog watchdog = new TimeoutWatchdog();
    private long timeoutCheckPeriod = 30000L;
    private InternalHandler handler = null;
    private ObjectName mbeanName = null;
    private long handledConnections = 0L;

    Dispatcher(int preallocationSize, WorkerPool workerPool, String domain, String name) {
        this.preallocationSize = preallocationSize;
        this.workerPool = workerPool;
        this.domain = domain;
        this.name = name;
    }

    @Override
    public final void setHandler(InternalHandler hdl) {
        this.handler = hdl;
        if (this.handler != null) {
            this.handler.setWorkerPool(this.workerPool);
        }
    }

    public final void acceptNewConnection(NonBlockingConnection connection) throws IOException {
        this.newConnections.add(connection);
        this.wakeup();
    }

    private void wakeup() {
        this.selector.wakeup();
    }

    private void init() {
        LOG.fine("opening selector to accept data");
        try {
            this.selector = Selector.open();
        }
        catch (IOException ioe) {
            String text = "exception occured while opening selector. Reason: " + ioe.toString();
            LOG.severe(text);
            throw new RuntimeException(text, ioe);
        }
        LOG.fine("starting timeout watchdog");
        this.watchdog.setPriority(1);
        this.watchdog.setName(this.name + "#" + "watchdog");
        this.watchdog.start();
        try {
            StandardMBean mbean = new StandardMBean(this, IDispatcher.class);
            this.mbeanName = new ObjectName(this.domain + ":type=Dispatcher,name=" + this.name);
            ManagementFactory.getPlatformMBeanServer().registerMBean(mbean, this.mbeanName);
        }
        catch (Exception mbe) {
            LOG.warning("error " + mbe.toString() + " occured while registering mbean");
        }
    }

    @Override
    public void shutdown() {
        if (this.isRunning) {
            NonBlockingConnection connection;
            this.isRunning = false;
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.mbeanName);
            }
            catch (Exception mbe) {
                LOG.warning("error " + mbe.toString() + " occured while unregistering mbean");
            }
            LOG.fine("closing connections");
            if (this.selector != null) {
                for (SelectionKey sk : this.selector.keys()) {
                    try {
                        connection = this.getAssignedConnection(sk);
                        connection.close();
                    }
                    catch (Exception ignore) {}
                }
            }
            LOG.fine("stopping timeout watchdog");
            this.watchdog.shutdown();
            LOG.fine("closing open connections");
            for (SelectionKey sk : this.selector.keys()) {
                try {
                    connection = this.getAssignedConnection(sk);
                    connection.close();
                }
                catch (Exception exception) {}
            }
            if (this.selector != null) {
                block13: {
                    try {
                        this.selector.close();
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block13;
                        LOG.fine("error occured by close selector within tearDown " + ioe.toString());
                    }
                }
                this.selector = null;
            }
        }
    }

    private NonBlockingConnection getAssignedConnection(SelectionKey sk) throws IOException {
        NonBlockingConnection connection = (NonBlockingConnection)sk.attachment();
        return connection;
    }

    @Override
    public final void run() {
        this.init();
        while (this.isRunning) {
            try {
                this.processing();
            }
            catch (Throwable e) {
                LOG.warning("exception occured while handling keys. Reason " + e.toString());
            }
        }
    }

    private void processing() throws IOException {
        Dispatcher.getMemoryManager().setPreallocationSize(this.preallocationSize);
        int n = this.selector.select();
        if (n > 0) {
            Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
            Iterator<SelectionKey> it = selectedKeys.iterator();
            while (it.hasNext()) {
                NonBlockingConnection connection;
                SelectionKey sk;
                block12: {
                    sk = it.next();
                    it.remove();
                    connection = this.getAssignedConnection(sk);
                    if (sk.isValid() && sk.isReadable()) {
                        try {
                            if (connection.isOpen()) {
                                connection.handleNonBlockingRead();
                            }
                        }
                        catch (Throwable e) {
                            if (connection == null) break block12;
                            if (LOG.isLoggable(Level.FINER)) {
                                LOG.finer("exception occured while reading data. Reason " + e.toString() + "\nclosing connection " + connection.toCompactString());
                            }
                            connection.close();
                        }
                    }
                }
                if (!sk.isValid() || !sk.isWritable()) continue;
                try {
                    connection.updateSelectionKeyOps(1);
                    if (!connection.hasDataToSend()) continue;
                    connection.handleNonBlockingWrite();
                }
                catch (Throwable e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("error occured while sending. " + e.toString());
                    }
                    connection.close();
                }
            }
        }
        while (!this.newConnections.isEmpty()) {
            do {
                this.handleNewConnections(this.newConnections.remove(0));
            } while (!this.newConnections.isEmpty());
        }
    }

    private void handleNewConnections(NonBlockingConnection connection) {
        try {
            ++this.handledConnections;
            connection.registerSelector(this.selector, 1);
            InternalHandler hdl = (InternalHandler)this.handler.clone();
            connection.init(hdl);
        }
        catch (Throwable e) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("exception occured while accepting connection. Reason " + e.toString() + "\nclosing connection " + connection.toCompactString());
            }
            connection.close();
        }
    }

    @Override
    public final int getNumberOfOpenConnections() {
        return this.selector.keys().size();
    }

    @Override
    public List<String> getOpenConnections() {
        ArrayList<String> result = new ArrayList<String>();
        for (SelectionKey key : this.selector.keys()) {
            result.add(((INonBlockingConnection)key.attachment()).toString());
        }
        return result;
    }

    @Override
    public final long getNumberOfHandledConnections() {
        return this.handledConnections;
    }

    public void setReceiveBufferPreallocationSize(int size) {
        this.preallocationSize = size;
    }

    @Override
    public int getReceiveBufferPreallocationSize() {
        return this.preallocationSize;
    }

    @Override
    public int getNumberOfConnectionTimeout() {
        return this.numberOfConnectionTimeouts;
    }

    @Override
    public int getNumberOfIdleTimeout() {
        return this.numberOfIdleTimeouts;
    }

    @Override
    public void setTimeoutCheckPeriod(long period) {
        this.timeoutCheckPeriod = period;
    }

    @Override
    public long getTimeoutCheckPeriod() {
        return this.timeoutCheckPeriod;
    }

    static DirectMemoryManager getMemoryManager() {
        DirectMemoryManager mm = memoryManager.get();
        if (mm == null) {
            mm = new DirectMemoryManager();
            memoryManager.set(mm);
        }
        return mm;
    }

    private class TimeoutWatchdog
    extends Thread {
        private boolean isRunning = true;

        private TimeoutWatchdog() {
        }

        public void run() {
            while (this.isRunning) {
                this.check();
                try {
                    Thread.sleep(Dispatcher.this.timeoutCheckPeriod);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        void shutdown() {
            this.isRunning = false;
            this.interrupt();
        }

        private void check() {
            long currentTime = System.currentTimeMillis();
            try {
                SelectionKey[] selKeys;
                Set<SelectionKey> keySet = Dispatcher.this.selector.keys();
                for (SelectionKey key : selKeys = keySet.toArray(new SelectionKey[keySet.size()])) {
                    NonBlockingConnection connection = (NonBlockingConnection)key.attachment();
                    if (connection.getConnectionTimeout() != Long.MAX_VALUE && currentTime > connection.getConnectionOpenedTime() + connection.getConnectionTimeout()) {
                        connection.handleConnectionTimeout();
                        Dispatcher.this.numberOfConnectionTimeouts++;
                    }
                    if (connection.getIdleTimeout() == Long.MAX_VALUE || currentTime <= connection.getLastReceivingTime() + connection.getIdleTimeout()) continue;
                    connection.handleIdleTimeout();
                    Dispatcher.this.numberOfIdleTimeouts++;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

