/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.xsocket.ClosedConnectionException;
import org.xsocket.server.DirectMemoryManager;
import org.xsocket.server.Dispatcher;
import org.xsocket.server.InternalHandler;
import org.xsocket.server.NonBlockingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NonBlockingSSLConnection
extends NonBlockingConnection {
    private static final Logger LOG = Logger.getLogger(NonBlockingSSLConnection.class.getName());
    private SSLEngine sslEngine = null;
    private boolean isHandshaking = true;
    private int minPacketBufferSize = 0;
    private int minAppBufferSize = 0;
    private boolean connectionOpenEvent = false;

    public boolean isEstablished() {
        return !this.isHandshaking;
    }

    public NonBlockingSSLConnection(SocketChannel channel, String id, SSLContext sslContext) throws IOException {
        super(channel, id);
        this.sslEngine = sslContext.createSSLEngine();
        this.minPacketBufferSize = this.sslEngine.getSession().getPacketBufferSize();
        this.minAppBufferSize = this.sslEngine.getSession().getApplicationBufferSize();
    }

    @Override
    public void init(InternalHandler handler) throws IOException {
        this.setHandler(handler);
        this.sslEngine.setUseClientMode(false);
        this.sslEngine.beginHandshake();
    }

    @Override
    public void handleNonBlockingRead() throws ClosedConnectionException, IOException {
        int appBytesReceived = 0;
        ByteBuffer inNetData = this.readPhysical();
        List<ByteBuffer> inAppDataList = this.unwrap(inNetData);
        for (ByteBuffer inAppData : inAppDataList) {
            if (inAppData.limit() <= 0) continue;
            appBytesReceived += this.getReceiveQueue().append(inAppData);
        }
        if (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            this.handleNonBlockingWrite();
        }
        if (this.connectionOpenEvent) {
            this.connectionOpenEvent = false;
            this.getAssignedHandler().onConnect(this);
        }
        if (appBytesReceived > 0) {
            this.getAssignedHandler().onData(this);
        }
    }

    @Override
    public void handleNonBlockingWrite() throws ClosedConnectionException, IOException {
        LinkedList<ByteBuffer> outAppDataList = this.getSendQueue().drain();
        int size = outAppDataList.size();
        int i = 0;
        do {
            ByteBuffer outAppData = null;
            outAppData = size > i ? (ByteBuffer)outAppDataList.get(i) : ByteBuffer.allocateDirect(0);
            List<ByteBuffer> outNetDataList = this.wrap(outAppData);
            for (ByteBuffer outNetData : outNetDataList) {
                this.getSendQueue().append(outNetData);
            }
        } while (++i < size);
        super.handleNonBlockingWrite();
    }

    private List<ByteBuffer> unwrap(ByteBuffer inNetData) throws SSLException, ClosedConnectionException {
        ArrayList<ByteBuffer> inAppDataList = new ArrayList<ByteBuffer>();
        DirectMemoryManager mm = Dispatcher.getMemoryManager();
        boolean repeat = false;
        int minSize = this.minAppBufferSize;
        do {
            repeat = false;
            SSLEngineResult engineResult = null;
            ByteBuffer inAppData = mm.acquireMemory(minSize);
            engineResult = this.sslEngine.unwrap(inNetData, inAppData);
            LOG.fine(engineResult.toString());
            if (engineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                mm.recycleMemory(inAppData);
                repeat = true;
                minSize += minSize;
                continue;
            }
            if (engineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("ssl connection is closed. closing connection");
                }
                mm.recycleMemory(inAppData);
                ClosedConnectionException cce = new ClosedConnectionException("Couldn't unwrap, because connection is closed");
                LOG.throwing(this.getClass().getName(), "unwrap", cce);
                throw cce;
            }
            if (engineResult.getStatus() == SSLEngineResult.Status.OK) {
                if (inNetData.position() < inNetData.limit()) {
                    inNetData = inNetData.slice();
                }
                inAppData.flip();
                inAppData = mm.extractAndRecycleMemory(inAppData);
                inAppDataList.add(inAppData);
            }
            if (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                Runnable task = null;
                while ((task = this.sslEngine.getDelegatedTask()) != null) {
                    task.run();
                }
                LOG.fine(this.sslEngine.getHandshakeStatus().toString());
            }
            if (this.sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || !inNetData.hasRemaining()) continue;
            repeat = true;
        } while (repeat);
        return inAppDataList;
    }

    private List<ByteBuffer> wrap(ByteBuffer outAppData) throws SSLException, ClosedConnectionException {
        ArrayList<ByteBuffer> outNetDataList = new ArrayList<ByteBuffer>();
        DirectMemoryManager mm = Dispatcher.getMemoryManager();
        boolean repeat = false;
        int minSize = this.minPacketBufferSize;
        do {
            repeat = false;
            SSLEngineResult engineResult = null;
            ByteBuffer outNetData = mm.acquireMemory(minSize);
            engineResult = this.sslEngine.wrap(outAppData, outNetData);
            LOG.fine(engineResult.toString());
            if (engineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                mm.recycleMemory(outNetData);
                repeat = true;
                minSize += minSize;
                continue;
            }
            if (engineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("ssl connection is closed. closing connection");
                }
                mm.recycleMemory(outNetData);
                ClosedConnectionException cce = new ClosedConnectionException("Couldn't unwrap, because connection is closed");
                LOG.throwing(this.getClass().getName(), "wrap", cce);
                throw cce;
            }
            if (engineResult.getStatus() == SSLEngineResult.Status.OK) {
                if (outAppData.position() < outAppData.limit()) {
                    outAppData = outAppData.slice();
                }
                outNetData.flip();
                outNetData = mm.extractAndRecycleMemory(outNetData);
                outNetDataList.add(outNetData);
                if (engineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                    this.isHandshaking = false;
                    this.connectionOpenEvent = true;
                    break;
                }
            }
            if (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                Runnable task = null;
                while ((task = this.sslEngine.getDelegatedTask()) != null) {
                    task.run();
                }
                LOG.fine(this.sslEngine.getHandshakeStatus().toString());
            }
            if (this.sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_WRAP) continue;
            repeat = true;
        } while (repeat);
        return outNetDataList;
    }

    @Override
    public synchronized void close() {
        this.sslEngine.closeOutbound();
        super.close();
    }
}

