/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server.handler.chain;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.server.IConnectHandler;
import org.xsocket.server.IConnectionScoped;
import org.xsocket.server.IDataHandler;
import org.xsocket.server.IHandler;
import org.xsocket.server.INonBlockingConnection;
import org.xsocket.server.ITimeoutHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Chain
implements IConnectHandler,
IDataHandler,
ITimeoutHandler,
IConnectionScoped {
    private static final Logger LOG = Logger.getLogger(Chain.class.getName());
    private IHandler[] handlers = new IHandler[0];
    private Integer[] connectionScopedIndex = new Integer[0];
    private Integer[] connectHandlerChain = new Integer[0];
    private Integer[] dataHandlerChain = new Integer[0];
    private Integer[] timeoutHandlerChain = new Integer[0];
    private List<Chain> enclosingChains = new ArrayList<Chain>();

    public Chain() {
    }

    public Chain(List<IHandler> hdls) {
        for (IHandler hdl : hdls) {
            this.addLast(hdl);
        }
    }

    public void addLast(IHandler handler) {
        int pos = this.handlers.length;
        this.handlers = Chain.incArray(this.handlers, handler);
        if (handler instanceof IConnectHandler) {
            this.connectHandlerChain = Chain.incArray(this.connectHandlerChain, pos);
        }
        if (handler instanceof IDataHandler) {
            this.dataHandlerChain = Chain.incArray(this.dataHandlerChain, pos);
        }
        if (handler instanceof ITimeoutHandler) {
            this.timeoutHandlerChain = Chain.incArray(this.timeoutHandlerChain, pos);
        }
        if (handler instanceof Chain) {
            ((Chain)handler).addEnclosingChain(this);
        }
        if (handler instanceof IConnectionScoped) {
            this.updateScope(pos, true);
        } else {
            this.updateScope(pos, false);
        }
    }

    private void addEnclosingChain(Chain enclosingChain) {
        if (this.enclosingChains == null) {
            this.enclosingChains = new ArrayList<Chain>();
        }
        this.enclosingChains.add(enclosingChain);
    }

    private void updateScope(IHandler handler, boolean isConnectionScoped) {
        for (int i = 0; i < this.handlers.length; ++i) {
            if (this.handlers[i] != handler) continue;
            this.updateScope(i, isConnectionScoped);
            return;
        }
    }

    private void updateScope(int pos, boolean isConnectionScoped) {
        if (isConnectionScoped) {
            this.connectionScopedIndex = Chain.incArray(this.connectionScopedIndex, pos);
            if (this.enclosingChains != null) {
                for (Chain chain : this.enclosingChains) {
                    chain.updateScope(this, true);
                }
            }
        }
    }

    @Override
    public boolean onConnect(INonBlockingConnection connection) throws IOException {
        for (Integer pos : this.connectHandlerChain) {
            boolean result = ((IConnectHandler)this.handlers[pos]).onConnect(connection);
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onData(INonBlockingConnection connection) throws IOException {
        for (Integer pos : this.dataHandlerChain) {
            boolean result = ((IDataHandler)this.handlers[pos]).onData(connection);
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onConnectionTimeout(INonBlockingConnection connection) throws IOException {
        for (Integer pos : this.timeoutHandlerChain) {
            boolean result = ((ITimeoutHandler)this.handlers[pos]).onConnectionTimeout(connection);
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onIdleTimeout(INonBlockingConnection connection) throws IOException {
        for (Integer pos : this.timeoutHandlerChain) {
            boolean result = ((ITimeoutHandler)this.handlers[pos]).onIdleTimeout(connection);
            if (!result) continue;
            return true;
        }
        return false;
    }

    IHandler getHandler(int pos) {
        return this.handlers[pos];
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (this.connectionScopedIndex.length > 0) {
            Chain clone = (Chain)super.clone();
            clone.handlers = (IHandler[])this.handlers.clone();
            for (int i = 0; i < this.connectionScopedIndex.length; ++i) {
                int position = this.connectionScopedIndex[i];
                clone.handlers[position] = (IHandler)((IConnectionScoped)((Object)this.handlers[position])).clone();
            }
            return clone;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest(this.getClass().getSimpleName() + " doesn't contain connection-specific handlers. return current instance as clone");
        }
        return this;
    }

    private static <T> T[] incArray(T[] original, T newElement) {
        T[] newArray = Chain.copyOf(original, original.length + 1, original.getClass());
        newArray[original.length] = newElement;
        return newArray;
    }

    private static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

