/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server.handler.command;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.xsocket.server.handler.command.CommandName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandLoader<T> {
    private static final Logger LOG = Logger.getLogger(CommandLoader.class.getName());
    private Map<String, T> commands = new HashMap<String, T>();
    private String pckgname = null;
    private Class clazz = null;

    public CommandLoader(String pckgname, Class clazz) {
        this.pckgname = pckgname;
        this.clazz = clazz;
    }

    public Map<String, T> getCommands() {
        return this.commands;
    }

    public T getCommand(String name) {
        return this.commands.get(name);
    }

    public final void loadCommands() {
        HashMap<String, T> newCommands = new HashMap<String, T>();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.info("load commands (instance of " + this.clazz.getSimpleName() + ") for package " + this.pckgname);
        }
        List<URL> pckgUrls = this.retrievePackageUrls();
        for (URL pckgUrl : pckgUrls) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.info("scanning " + pckgUrl);
            }
            this.retrieveClasses(pckgUrl, newCommands);
        }
        this.commands = newCommands;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("commands loaded:");
            for (String cmd : this.commands.keySet()) {
                LOG.fine(cmd);
            }
        }
    }

    private List<URL> retrievePackageUrls() {
        ArrayList<URL> directories = new ArrayList<URL>();
        ClassLoader cld = Thread.currentThread().getContextClassLoader();
        if (cld == null) {
            LOG.warning("Can't get class loader to load commands");
        } else {
            try {
                String name = this.pckgname;
                name = name.replace('.', '/');
                Enumeration<URL> resources = cld.getResources(name);
                while (resources.hasMoreElements()) {
                    directories.add(resources.nextElement());
                }
            }
            catch (IOException ioe) {
                LOG.warning("error occured by accesing package file to load commands of " + this.pckgname);
            }
        }
        return directories;
    }

    private void retrieveClasses(URL url, Map<String, T> cmds) {
        try {
            String resource = URLDecoder.decode(url.getPath(), "UTF-8");
            File directory = new File(resource);
            if (directory.exists()) {
                String[] files;
                for (String file : files = directory.list()) {
                    if (!file.endsWith(".class")) continue;
                    this.addInstanceIfCommand(this.pckgname + '.' + file.substring(0, file.length() - 6), cmds);
                }
            } else {
                JarURLConnection con = (JarURLConnection)url.openConnection();
                String starts = con.getEntryName();
                Enumeration<JarEntry> entriesEnum = con.getJarFile().entries();
                while (entriesEnum.hasMoreElements()) {
                    ZipEntry entry = entriesEnum.nextElement();
                    String entryname = entry.getName();
                    if (!entryname.startsWith(starts) || entryname.lastIndexOf(47) > starts.length() || !entryname.endsWith(".class")) continue;
                    String classname = entryname.substring(0, entryname.length() - 6);
                    if (classname.startsWith("/")) {
                        classname = classname.substring(1);
                    }
                    classname = classname.replace('/', '.');
                    this.addInstanceIfCommand(classname, cmds);
                }
            }
        }
        catch (IOException ioe) {
            LOG.warning("couldn't retrieve classes of " + url + ". Reason: " + ioe);
        }
    }

    private void addInstanceIfCommand(String classname, Map<String, T> cmds) {
        block4: {
            try {
                Class<?> clazzToCheck = Class.forName(classname);
                if (this.clazz.isAssignableFrom(clazzToCheck)) {
                    Object cmd = clazzToCheck.newInstance();
                    String name = cmd.getClass().getAnnotation(CommandName.class).value();
                    if (cmds.containsKey(name)) {
                        LOG.warning("command " + name + " already loaded. Overload existing command");
                    }
                    cmds.put(name, cmd);
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINEST)) break block4;
                LOG.finest("exception occured while load " + classname + ". Reason: " + e.toString());
            }
        }
    }
}

