/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.HeaderFilter;
import org.zalando.logbook.HttpLogFormatter;
import org.zalando.logbook.HttpLogWriter;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.LogbookFactory;
import org.zalando.logbook.QueryFilter;
import org.zalando.logbook.RawHttpRequest;
import org.zalando.logbook.RawRequestFilter;
import org.zalando.logbook.RawResponseFilter;
import org.zalando.logbook.RequestFilter;
import org.zalando.logbook.ResponseFilter;

@API(status=API.Status.INTERNAL)
public final class LogbookCreator {
    private LogbookCreator() {
    }

    private static Logbook create(@Nullable Predicate<RawHttpRequest> condition, List<RawRequestFilter> rawRequestFilters, List<RawResponseFilter> rawResponseFilters, List<QueryFilter> queryFilters, List<HeaderFilter> headerFilters, List<BodyFilter> bodyFilters, List<RequestFilter> requestFilters, List<ResponseFilter> responseFilters, @Nullable HttpLogFormatter formatter, @Nullable HttpLogWriter writer) {
        RawRequestFilter rawRequestFilter = rawRequestFilters.stream().reduce(RawRequestFilter::merge).orElse(null);
        RawResponseFilter rawResponseFilter = rawResponseFilters.stream().reduce(RawResponseFilter::merge).orElse(null);
        QueryFilter queryFilter = queryFilters.stream().reduce(QueryFilter::merge).orElse(null);
        HeaderFilter headerFilter = headerFilters.stream().reduce(HeaderFilter::merge).orElse(null);
        BodyFilter bodyFilter = bodyFilters.stream().reduce(BodyFilter::merge).orElse(null);
        RequestFilter requestFilter = requestFilters.stream().reduce(RequestFilter::merge).orElse(null);
        ResponseFilter responseFilter = responseFilters.stream().reduce(ResponseFilter::merge).orElse(null);
        LogbookFactory factory = LogbookFactory.INSTANCE;
        return factory.create(condition, rawRequestFilter, rawResponseFilter, queryFilter, headerFilter, bodyFilter, requestFilter, responseFilter, formatter, writer);
    }

    public static Builder builder() {
        return new Builder();
    }

    @API(status=API.Status.STABLE)
    public static final class Builder {
        private Predicate<RawHttpRequest> condition;
        private ArrayList<RawRequestFilter> rawRequestFilters;
        private ArrayList<RawResponseFilter> rawResponseFilters;
        private ArrayList<QueryFilter> queryFilters;
        private ArrayList<HeaderFilter> headerFilters;
        private ArrayList<BodyFilter> bodyFilters;
        private ArrayList<RequestFilter> requestFilters;
        private ArrayList<ResponseFilter> responseFilters;
        private HttpLogFormatter formatter;
        private HttpLogWriter writer;

        Builder() {
        }

        public Builder condition(Predicate<RawHttpRequest> condition) {
            this.condition = condition;
            return this;
        }

        public Builder rawRequestFilter(RawRequestFilter rawRequestFilter) {
            if (this.rawRequestFilters == null) {
                this.rawRequestFilters = new ArrayList();
            }
            this.rawRequestFilters.add(rawRequestFilter);
            return this;
        }

        public Builder rawRequestFilters(Collection<? extends RawRequestFilter> rawRequestFilters) {
            if (this.rawRequestFilters == null) {
                this.rawRequestFilters = new ArrayList();
            }
            this.rawRequestFilters.addAll(rawRequestFilters);
            return this;
        }

        public Builder clearRawRequestFilters() {
            if (this.rawRequestFilters != null) {
                this.rawRequestFilters.clear();
            }
            return this;
        }

        public Builder rawResponseFilter(RawResponseFilter rawResponseFilter) {
            if (this.rawResponseFilters == null) {
                this.rawResponseFilters = new ArrayList();
            }
            this.rawResponseFilters.add(rawResponseFilter);
            return this;
        }

        public Builder rawResponseFilters(Collection<? extends RawResponseFilter> rawResponseFilters) {
            if (this.rawResponseFilters == null) {
                this.rawResponseFilters = new ArrayList();
            }
            this.rawResponseFilters.addAll(rawResponseFilters);
            return this;
        }

        public Builder clearRawResponseFilters() {
            if (this.rawResponseFilters != null) {
                this.rawResponseFilters.clear();
            }
            return this;
        }

        public Builder queryFilter(QueryFilter queryFilter) {
            if (this.queryFilters == null) {
                this.queryFilters = new ArrayList();
            }
            this.queryFilters.add(queryFilter);
            return this;
        }

        public Builder queryFilters(Collection<? extends QueryFilter> queryFilters) {
            if (this.queryFilters == null) {
                this.queryFilters = new ArrayList();
            }
            this.queryFilters.addAll(queryFilters);
            return this;
        }

        public Builder clearQueryFilters() {
            if (this.queryFilters != null) {
                this.queryFilters.clear();
            }
            return this;
        }

        public Builder headerFilter(HeaderFilter headerFilter) {
            if (this.headerFilters == null) {
                this.headerFilters = new ArrayList();
            }
            this.headerFilters.add(headerFilter);
            return this;
        }

        public Builder headerFilters(Collection<? extends HeaderFilter> headerFilters) {
            if (this.headerFilters == null) {
                this.headerFilters = new ArrayList();
            }
            this.headerFilters.addAll(headerFilters);
            return this;
        }

        public Builder clearHeaderFilters() {
            if (this.headerFilters != null) {
                this.headerFilters.clear();
            }
            return this;
        }

        public Builder bodyFilter(BodyFilter bodyFilter) {
            if (this.bodyFilters == null) {
                this.bodyFilters = new ArrayList();
            }
            this.bodyFilters.add(bodyFilter);
            return this;
        }

        public Builder bodyFilters(Collection<? extends BodyFilter> bodyFilters) {
            if (this.bodyFilters == null) {
                this.bodyFilters = new ArrayList();
            }
            this.bodyFilters.addAll(bodyFilters);
            return this;
        }

        public Builder clearBodyFilters() {
            if (this.bodyFilters != null) {
                this.bodyFilters.clear();
            }
            return this;
        }

        public Builder requestFilter(RequestFilter requestFilter) {
            if (this.requestFilters == null) {
                this.requestFilters = new ArrayList();
            }
            this.requestFilters.add(requestFilter);
            return this;
        }

        public Builder requestFilters(Collection<? extends RequestFilter> requestFilters) {
            if (this.requestFilters == null) {
                this.requestFilters = new ArrayList();
            }
            this.requestFilters.addAll(requestFilters);
            return this;
        }

        public Builder clearRequestFilters() {
            if (this.requestFilters != null) {
                this.requestFilters.clear();
            }
            return this;
        }

        public Builder responseFilter(ResponseFilter responseFilter) {
            if (this.responseFilters == null) {
                this.responseFilters = new ArrayList();
            }
            this.responseFilters.add(responseFilter);
            return this;
        }

        public Builder responseFilters(Collection<? extends ResponseFilter> responseFilters) {
            if (this.responseFilters == null) {
                this.responseFilters = new ArrayList();
            }
            this.responseFilters.addAll(responseFilters);
            return this;
        }

        public Builder clearResponseFilters() {
            if (this.responseFilters != null) {
                this.responseFilters.clear();
            }
            return this;
        }

        public Builder formatter(HttpLogFormatter formatter) {
            this.formatter = formatter;
            return this;
        }

        public Builder writer(HttpLogWriter writer) {
            this.writer = writer;
            return this;
        }

        public Logbook build() {
            List<Object> responseFilters;
            List<Object> requestFilters;
            List<Object> bodyFilters;
            List<Object> headerFilters;
            List<Object> queryFilters;
            List<Object> rawResponseFilters;
            List<Object> rawRequestFilters;
            switch (this.rawRequestFilters == null ? 0 : this.rawRequestFilters.size()) {
                case 0: {
                    rawRequestFilters = Collections.emptyList();
                    break;
                }
                case 1: {
                    rawRequestFilters = Collections.singletonList(this.rawRequestFilters.get(0));
                    break;
                }
                default: {
                    rawRequestFilters = Collections.unmodifiableList(new ArrayList<RawRequestFilter>(this.rawRequestFilters));
                }
            }
            switch (this.rawResponseFilters == null ? 0 : this.rawResponseFilters.size()) {
                case 0: {
                    rawResponseFilters = Collections.emptyList();
                    break;
                }
                case 1: {
                    rawResponseFilters = Collections.singletonList(this.rawResponseFilters.get(0));
                    break;
                }
                default: {
                    rawResponseFilters = Collections.unmodifiableList(new ArrayList<RawResponseFilter>(this.rawResponseFilters));
                }
            }
            switch (this.queryFilters == null ? 0 : this.queryFilters.size()) {
                case 0: {
                    queryFilters = Collections.emptyList();
                    break;
                }
                case 1: {
                    queryFilters = Collections.singletonList(this.queryFilters.get(0));
                    break;
                }
                default: {
                    queryFilters = Collections.unmodifiableList(new ArrayList<QueryFilter>(this.queryFilters));
                }
            }
            switch (this.headerFilters == null ? 0 : this.headerFilters.size()) {
                case 0: {
                    headerFilters = Collections.emptyList();
                    break;
                }
                case 1: {
                    headerFilters = Collections.singletonList(this.headerFilters.get(0));
                    break;
                }
                default: {
                    headerFilters = Collections.unmodifiableList(new ArrayList<HeaderFilter>(this.headerFilters));
                }
            }
            switch (this.bodyFilters == null ? 0 : this.bodyFilters.size()) {
                case 0: {
                    bodyFilters = Collections.emptyList();
                    break;
                }
                case 1: {
                    bodyFilters = Collections.singletonList(this.bodyFilters.get(0));
                    break;
                }
                default: {
                    bodyFilters = Collections.unmodifiableList(new ArrayList<BodyFilter>(this.bodyFilters));
                }
            }
            switch (this.requestFilters == null ? 0 : this.requestFilters.size()) {
                case 0: {
                    requestFilters = Collections.emptyList();
                    break;
                }
                case 1: {
                    requestFilters = Collections.singletonList(this.requestFilters.get(0));
                    break;
                }
                default: {
                    requestFilters = Collections.unmodifiableList(new ArrayList<RequestFilter>(this.requestFilters));
                }
            }
            switch (this.responseFilters == null ? 0 : this.responseFilters.size()) {
                case 0: {
                    responseFilters = Collections.emptyList();
                    break;
                }
                case 1: {
                    responseFilters = Collections.singletonList(this.responseFilters.get(0));
                    break;
                }
                default: {
                    responseFilters = Collections.unmodifiableList(new ArrayList<ResponseFilter>(this.responseFilters));
                }
            }
            return LogbookCreator.create(this.condition, rawRequestFilters, rawResponseFilters, queryFilters, headerFilters, bodyFilters, requestFilters, responseFilters, this.formatter, this.writer);
        }

        public String toString() {
            return "LogbookCreator.Builder(condition=" + this.condition + ", rawRequestFilters=" + this.rawRequestFilters + ", rawResponseFilters=" + this.rawResponseFilters + ", queryFilters=" + this.queryFilters + ", headerFilters=" + this.headerFilters + ", bodyFilters=" + this.bodyFilters + ", requestFilters=" + this.requestFilters + ", responseFilters=" + this.responseFilters + ", formatter=" + this.formatter + ", writer=" + this.writer + ")";
        }
    }
}

