/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.common;

import java.util.Arrays;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.zalando.logbook.common.PatternLike;

public final class MediaTypeQuery {
    private static final Pattern WILDCARD = Pattern.compile("\\*");

    private MediaTypeQuery() {
    }

    public static Predicate<String> compile(String query, String ... queries) {
        return Arrays.stream(queries).map(MediaTypeQuery::compile).reduce(MediaTypeQuery.compile(query), Predicate::or);
    }

    private static Predicate<String> compile(String query) {
        int slash = query.indexOf(47);
        int semicolon = query.indexOf(59);
        int end = semicolon == -1 ? query.length() : semicolon;
        String type = query.substring(0, slash).trim();
        String subType = query.substring(slash + 1, end).trim();
        String first = PatternLike.toPattern(WILDCARD, type, ".*?");
        String second = PatternLike.toPattern(WILDCARD, subType, ".*?");
        Pattern pattern = Pattern.compile(first + '/' + second + "(;.*)?");
        return input -> input != null && pattern.matcher((CharSequence)input).matches();
    }
}

