/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.apiguardian.api.API;
import org.zalando.logbook.Correlator;
import org.zalando.logbook.RawHttpResponse;
import org.zalando.logbook.httpclient.Attributes;
import org.zalando.logbook.httpclient.ForwardingHttpAsyncResponseConsumer;
import org.zalando.logbook.httpclient.RemoteResponse;

@API(status=API.Status.EXPERIMENTAL)
public final class LogbookHttpAsyncResponseConsumer<T>
extends ForwardingHttpAsyncResponseConsumer<T> {
    private final HttpAsyncResponseConsumer<T> consumer;
    private HttpResponse response;

    public LogbookHttpAsyncResponseConsumer(HttpAsyncResponseConsumer<T> consumer) {
        this.consumer = consumer;
    }

    @Override
    protected HttpAsyncResponseConsumer<T> delegate() {
        return this.consumer;
    }

    @Override
    public void responseReceived(HttpResponse response) throws IOException, HttpException {
        this.response = response;
        this.delegate().responseReceived(response);
    }

    @Override
    public void responseCompleted(HttpContext context) {
        this.findCorrelator(context).ifPresent(correlator -> {
            try {
                correlator.write((RawHttpResponse)new RemoteResponse(this.response));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        this.delegate().responseCompleted(context);
    }

    private Optional<Correlator> findCorrelator(HttpContext context) {
        return Optional.ofNullable(context.getAttribute(Attributes.CORRELATOR)).map(Correlator.class::cast);
    }
}

