/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.web.advice.network;

import net.jodah.failsafe.CircuitBreakerOpenException;
import org.apiguardian.api.API;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.spring.web.advice.AdviceTrait;

@API(status=API.Status.EXPERIMENTAL)
public interface CircuitBreakerOpenAdviceTrait
extends AdviceTrait {
    @API(status=API.Status.INTERNAL)
    @ExceptionHandler
    default public ResponseEntity<Problem> handleCircuitBreakerOpen(CircuitBreakerOpenException exception, NativeWebRequest request) {
        long delay = exception.getCircuitBreaker().getRemainingDelay().getSeconds();
        HttpHeaders headers = this.retryAfter(delay);
        return this.create((StatusType)Status.SERVICE_UNAVAILABLE, (Throwable)exception, request, headers);
    }

    default public HttpHeaders retryAfter(long delay) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Retry-After", String.valueOf(delay));
        return headers;
    }
}

