/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet;

import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.util.Locales;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.Servlets;

public class Charsets {
    private static final Log log = Log.lookup(Charsets.class);
    private static final String ATTR_SETUP = "org.zkoss.web.charset.setup";
    private static final String _uriCharset;
    private static final String PX_PREFERRED_LOCALE = "px_preferred_locale";

    public static final String getURICharset() {
        return _uriCharset;
    }

    public static final Object setup(HttpSession sess, ServletRequest request, ServletResponse response, String charset) {
        Locale locale;
        block12: {
            String v;
            if (Charsets.hasSetup(request)) {
                return Objects.UNKNOWN;
            }
            locale = Charsets.getPreferredLocale(sess, request);
            response.setLocale(locale);
            if (charset != null && charset.length() > 0) {
                try {
                    if (Servlets.isServlet24()) {
                        response.setCharacterEncoding(charset);
                    } else {
                        response.setContentType(";charset=" + charset);
                    }
                }
                catch (Throwable ex) {
                    try {
                        v = response.getCharacterEncoding();
                        if (!Objects.equals((Object)v, (Object)charset)) {
                            log.warningBriefly("Unable to set response's charset: " + charset + " (current=" + v + ')', ex);
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
            if (request.getCharacterEncoding() == null) {
                charset = response.getCharacterEncoding();
                try {
                    request.setCharacterEncoding(charset);
                }
                catch (Throwable ex) {
                    v = request.getCharacterEncoding();
                    if (Objects.equals((Object)v, (Object)charset)) break block12;
                    log.warning("Unable to set request's charset: " + charset + " (current=" + v + "): " + Exceptions.getMessage((Throwable)ex));
                }
            }
        }
        Charsets.markSetup(request, true);
        return Locales.setThreadLocal((Locale)locale);
    }

    public static final Object setup(ServletRequest request, ServletResponse response, String charset) {
        return Charsets.setup(Charsets.getSession(request), request, response, charset);
    }

    private static final HttpSession getSession(ServletRequest request) {
        return request instanceof HttpServletRequest ? ((HttpServletRequest)request).getSession(false) : null;
    }

    public static final void cleanup(ServletRequest request, Object old) {
        if (old != Objects.UNKNOWN) {
            Locales.setThreadLocal((Locale)((Locale)old));
            Charsets.markSetup(request, false);
        }
    }

    public static final boolean hasSetup(ServletRequest request) {
        return request.getAttribute(ATTR_SETUP) != null;
    }

    public static final void markSetup(ServletRequest request, boolean setup) {
        if (setup) {
            request.setAttribute(ATTR_SETUP, (Object)Boolean.TRUE);
        } else {
            request.removeAttribute(ATTR_SETUP);
        }
    }

    public static final Locale getPreferredLocale(HttpSession sess, ServletRequest request) {
        Locale l;
        if (sess != null) {
            String s;
            Object v = sess.getAttribute("org.zkoss.web.preferred.locale");
            if (v == null) {
                v = sess.getAttribute(PX_PREFERRED_LOCALE);
            }
            if (v != null) {
                if (v instanceof Locale) {
                    return (Locale)v;
                }
                Charsets.logLocaleError(v);
            }
            if ((v = sess.getServletContext().getAttribute("org.zkoss.web.preferred.locale")) == null) {
                v = sess.getServletContext().getAttribute(PX_PREFERRED_LOCALE);
            }
            if (v != null) {
                if (v instanceof Locale) {
                    return (Locale)v;
                }
                Charsets.logLocaleError(v);
            }
            if ((s = Library.getProperty((String)"org.zkoss.web.preferred.locale")) != null) {
                return Locales.getLocale((String)s);
            }
        }
        return (l = request.getLocale()) != null ? l : Locale.getDefault();
    }

    private static void logLocaleError(Object v) {
        log.warning("org.zkoss.web.preferred.locale ignored. Locale is required, not " + v.getClass());
    }

    public static final Locale getPreferredLocale(ServletRequest request) {
        return Charsets.getPreferredLocale(Charsets.getSession(request), request);
    }

    public static final void setPreferredLocale(HttpSession hsess, Locale locale) {
        if (locale != null) {
            hsess.setAttribute("org.zkoss.web.preferred.locale", (Object)locale);
        } else {
            hsess.removeAttribute("org.zkoss.web.preferred.locale");
            hsess.removeAttribute(PX_PREFERRED_LOCALE);
        }
    }

    public static final void setPreferredLocale(ServletContext ctx, Locale locale) {
        if (locale != null) {
            ctx.setAttribute("org.zkoss.web.preferred.locale", (Object)locale);
        } else {
            ctx.removeAttribute("org.zkoss.web.preferred.locale");
            ctx.removeAttribute(PX_PREFERRED_LOCALE);
        }
    }

    static {
        String cs = Library.getProperty((String)"org.zkoss.web.uri.charset");
        if (cs == null || cs.length() == 0) {
            cs = "UTF-8";
        }
        _uriCharset = cs;
    }
}

