/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zhtml.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.xml.XMLs;
import org.zkoss.zhtml.impl.PageRenderer;
import org.zkoss.zhtml.impl.TagRenderContext;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.DynamicPropertied;
import org.zkoss.zk.ui.ext.RawId;
import org.zkoss.zk.ui.ext.render.DirectContent;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.HtmlPageRenders;

public class AbstractTag
extends AbstractComponent
implements DynamicPropertied,
RawId {
    protected String _tagnm;
    private Map _props;

    protected AbstractTag(String tagname) {
        if (tagname == null || tagname.length() == 0) {
            throw new IllegalArgumentException("A tag name is required");
        }
        this._tagnm = tagname;
    }

    protected AbstractTag() {
    }

    public String getSclass() {
        return (String)this.getDynamicProperty("class");
    }

    public void setSclass(String sclass) {
        this.setDynamicProperty("class", sclass);
    }

    public String getStyle() {
        return (String)this.getDynamicProperty("style");
    }

    public void setStyle(String style) {
        this.setDynamicProperty("style", style);
    }

    public String getTag() {
        return this._tagnm;
    }

    public boolean hasDynamicProperty(String name) {
        return ComponentsCtrl.isReservedAttribute((String)name);
    }

    public Object getDynamicProperty(String name) {
        return this._props != null ? this._props.get(name) : null;
    }

    public void setDynamicProperty(String name, Object value) throws WrongValueException {
        if (name == null) {
            throw new WrongValueException("name is required");
        }
        if (!this.hasDynamicProperty(name)) {
            throw new WrongValueException("Attribute not allowed: " + name + "\nSpecify the ZK namespace if you want to use special ZK attributes");
        }
        String sval = Objects.toString((Object)value);
        if ("style".equals(name)) {
            sval = this.filterStyle(sval);
            this.setDynaProp(name, sval);
        } else {
            this.setDynaProp(name, value);
        }
        this.smartUpdate("dynamicProperty", new String[]{name, sval});
    }

    private String filterStyle(String style) {
        int j;
        if (style != null && (j = HTMLs.getSubstyleIndex((String)style, (String)"display")) >= 0) {
            super.setVisible(!"none".equals(HTMLs.getSubstyleValue((String)style, (int)j)));
            return style;
        }
        if (!this.isVisible()) {
            int len;
            int n = len = style != null ? style.length() : 0;
            if (len == 0) {
                return "display:none;";
            }
            if (style.charAt(len - 1) != ';') {
                style = style + ';';
            }
            style = style + "display:none;";
        }
        return style;
    }

    private void setDynaProp(String name, Object value) {
        if (value == null) {
            if (this._props != null) {
                this._props.remove(name);
            }
        } else {
            if (this._props == null) {
                this._props = new LinkedHashMap();
            }
            this._props.put(name, value);
        }
    }

    protected boolean shallHideId() {
        return false;
    }

    public boolean setVisible(boolean visible) {
        boolean old = super.setVisible(visible);
        if (old != visible) {
            String style = this.getStyle();
            if (visible) {
                String val;
                int j;
                if (style != null && (j = HTMLs.getSubstyleIndex((String)style, (String)"display")) >= 0 && "none".equals(val = HTMLs.getSubstyleValue((String)style, (int)j))) {
                    String newstyle = style.substring(0, j);
                    int k = style.indexOf(59, j + 7);
                    if (k >= 0) {
                        newstyle = newstyle + style.substring(k + 1);
                    }
                    this.setDynaProp("style", newstyle);
                }
            } else if (style == null) {
                this.setDynaProp("style", "display:none;");
            } else {
                int j = HTMLs.getSubstyleIndex((String)style, (String)"display");
                if (j >= 0) {
                    String val = HTMLs.getSubstyleValue((String)style, (int)j);
                    if (!"none".equals(val)) {
                        String newstyle = style.substring(0, j) + "display:none;";
                        int k = style.indexOf(59, j + 7);
                        if (k >= 0) {
                            newstyle = newstyle + style.substring(k + 1);
                        }
                        this.setDynaProp("style", newstyle);
                    }
                } else {
                    int len = style.length();
                    String newstyle = len > 0 && style.charAt(len - 1) != ';' ? style + ';' : style;
                    this.setDynaProp("style", style + "display:none;");
                }
            }
        }
        return old;
    }

    public String getWidgetClass() {
        return "zhtml.Widget";
    }

    public void redraw(Writer out) throws IOException {
        if (this._tagnm == null) {
            throw new UiException("The tag name is not initialized yet");
        }
        Execution exec = Executions.getCurrent();
        if (exec == null || exec.isAsyncUpdate(null) || !HtmlPageRenders.isDirectContent((Execution)exec)) {
            super.redraw(out);
            return;
        }
        TagRenderContext rc = PageRenderer.getTagRenderContext(exec);
        boolean rcRequired = rc == null;
        Object ret = null;
        if (rcRequired) {
            ret = PageRenderer.beforeRenderTag(exec);
            rc = PageRenderer.getTagRenderContext(exec);
        }
        out.write(this.getPrologHalf(false));
        rc.renderBegin((Component)this, this.getClientEvents(), false);
        this.redrawChildrenDirectly(rc, exec, out);
        out.write(this.getEpilogHalf());
        rc.renderEnd((Component)this);
        if (rcRequired) {
            out.write(rc.complete());
            PageRenderer.afterRenderTag(exec, ret);
        }
    }

    protected void redrawChildrenDirectly(TagRenderContext rc, Execution exec, Writer out) throws IOException {
        Component child = this.getFirstChild();
        while (child != null) {
            Component next = child.getNextSibling();
            if (((ComponentCtrl)child).getExtraCtrl() instanceof DirectContent) {
                ((ComponentCtrl)child).redraw(out);
            } else {
                HtmlPageRenders.setDirectContent((Execution)exec, (boolean)false);
                rc.renderBegin(child, null, true);
                HtmlPageRenders.outStandalone((Execution)exec, (Component)child, (Writer)out);
                rc.renderEnd(child);
                HtmlPageRenders.setDirectContent((Execution)exec, (boolean)true);
            }
            child = next;
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "prolog", this.getPrologHalf(false));
        this.render(renderer, "epilog", this.getEpilogHalf());
    }

    String getPrologHalf(boolean hideUuidIfNoId) {
        StringBuffer sb = new StringBuffer(128).append('<').append(this._tagnm);
        if (!hideUuidIfNoId && !this.shallHideId() || this.getId().length() > 0) {
            sb.append(" id=\"").append(this.getUuid()).append('\"');
        }
        if (this._props != null) {
            Iterator it = this._props.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                sb.append(' ').append(me.getKey()).append("=\"").append(XMLs.encodeAttribute((String)Objects.toString(me.getValue()))).append('\"');
            }
        }
        if (!this.isChildable()) {
            sb.append('/');
        }
        return sb.append('>').toString();
    }

    String getEpilogHalf() {
        return this.isChildable() ? "</" + this._tagnm + '>' : "";
    }

    protected boolean isChildable() {
        return !HTMLs.isOrphanTag((String)this._tagnm);
    }

    public Object clone() {
        AbstractTag clone = (AbstractTag)((Object)super.clone());
        if (clone._props != null) {
            clone._props = new LinkedHashMap(clone._props);
        }
        return clone;
    }

    public String toString() {
        return "[" + this._tagnm + ' ' + super.toString() + ']';
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    static {
        AbstractTag.addClientEvent((Class)AbstractTag.class, (String)"onClick", (int)0);
    }

    protected class ExtraCtrl
    implements DirectContent {
        protected ExtraCtrl() {
        }
    }
}

