/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.bind.AnnotateBinder;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.Validator;
import org.zkoss.bind.annotation.AfterCompose;
import org.zkoss.bind.impl.AbstractAnnotatedMethodInvoker;
import org.zkoss.bind.impl.AnnotationUtil;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.ValidationMessagesImpl;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.ValidationMessages;
import org.zkoss.lang.Strings;
import org.zkoss.util.CacheMap;
import org.zkoss.util.IllegalSyntaxException;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ComposerExt;
import org.zkoss.zk.ui.util.ConventionWires;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindComposer<T extends Component>
implements Composer<T>,
ComposerExt<T>,
Serializable {
    private static final long serialVersionUID = 1463169907348730644L;
    private static final Log _log = Log.lookup(BindComposer.class);
    private static final String VM_ID = "$VM_ID$";
    private static final String BINDER_ID = "$BINDER_ID$";
    private Object _viewModel;
    private AnnotateBinder _binder;
    private final Map<String, Converter> _converters;
    private final Map<String, Validator> _validators;
    private final BindEvaluatorX evalx;
    private static final String ID_ANNO = "id";
    private static final String INIT_ANNO = "init";
    private static final String VALUE_ANNO_ATTR = "value";
    private static final String COMPOSER_NAME_ATTR = "composerName";
    private static final String VIEW_MODEL_ATTR = "viewModel";
    private static final String BINDER_ATTR = "binder";
    private static final String VALIDATION_MESSAGES_ATTR = "validationMessages";
    private static final String QUEUE_NAME_ANNO_ATTR = "queueName";
    private static final String QUEUE_SCOPE_ANNO_ATTR = "queueScope";
    private static final Map<Class<?>, List<Method>> _afterComposeMethodCache = new CacheMap(600, 1800000);

    public BindComposer() {
        this.setViewModel(this);
        this._converters = new HashMap<String, Converter>(8);
        this._validators = new HashMap<String, Validator>(8);
        this.evalx = BindEvaluatorXUtil.createEvaluator(null);
    }

    public Binder getBinder() {
        return this._binder;
    }

    public void setViewModel(Object viewModel) {
        this._viewModel = viewModel;
        if (this._binder != null) {
            this._binder.setViewModel(this._viewModel);
        }
    }

    public Object getViewModel() {
        return this._viewModel;
    }

    public Converter getConverter(String name) {
        Converter conv = this._converters.get(name);
        return conv;
    }

    public Validator getValidator(String name) {
        Validator validator = this._validators.get(name);
        return validator;
    }

    public void addConverter(String name, Converter converter) {
        this._converters.put(name, converter);
    }

    public void addValidator(String name, Validator validator) {
        this._validators.put(name, validator);
    }

    public ComponentInfo doBeforeCompose(Page page, Component parent, ComponentInfo compInfo) throws Exception {
        return compInfo;
    }

    public void doBeforeComposeChildren(Component comp) throws Exception {
        this._viewModel = this.initViewModel(this.evalx, comp);
        this._binder = this.initBinder(this.evalx, comp);
        ValidationMessages _vmsgs = this.initValidationMessages(this.evalx, comp, this._binder);
        Selectors.wireVariables((Component)comp, (Object)this._viewModel, (List)Selectors.newVariableResolvers(this._viewModel.getClass(), null));
        if (_vmsgs != null) {
            this._binder.setValidationMessages(_vmsgs);
        }
        BinderKeeper keeper = BinderKeeper.getInstance(comp);
        keeper.book(this._binder, comp);
        this._binder.init(comp, this._viewModel, this.getViewModelInitArgs(this.evalx, comp));
        ConventionWires.wireController((Component)comp, (Object)this);
    }

    public void doAfterCompose(T comp) throws Exception {
        this._binder.initAnnotatedBindings();
        new AbstractAnnotatedMethodInvoker<AfterCompose>(AfterCompose.class, _afterComposeMethodCache){

            @Override
            protected boolean shouldLookupSuperclass(AfterCompose annotation) {
                return annotation.superclass();
            }
        }.invokeMethod(this._binder, this.getViewModelInitArgs(this.evalx, (Component)comp));
        BinderKeeper keeper = BinderKeeper.getInstance(comp);
        if (keeper.isRootBinder(this._binder)) {
            keeper.loadComponentForAllBinders();
        }
    }

    private Map<String, Object> getViewModelInitArgs(BindEvaluatorX evalx, Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Collection anncol = compCtrl.getAnnotations(VIEW_MODEL_ATTR, INIT_ANNO);
        if (anncol.size() == 0) {
            return null;
        }
        Annotation ann = (Annotation)anncol.iterator().next();
        Map attrs = ann.getAttributes();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : attrs.entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if (VALUE_ANNO_ATTR.equals(tag)) continue;
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        return args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
    }

    private Object initViewModel(BindEvaluatorX evalx, Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation idanno = compCtrl.getAnnotation(VIEW_MODEL_ATTR, ID_ANNO);
        Annotation initanno = compCtrl.getAnnotation(VIEW_MODEL_ATTR, INIT_ANNO);
        String vmname = null;
        Object vm = null;
        if (idanno == null && initanno == null) {
            return this._viewModel;
        }
        if (idanno == null) {
            throw new IllegalSyntaxException("you have to use @id to assign the name of view model for " + comp);
        }
        if (initanno == null) {
            throw new IllegalSyntaxException("you have to use @init to assign the view model for " + comp);
        }
        vmname = BindEvaluatorXUtil.eval(evalx, comp, AnnotationUtil.testString(idanno.getAttributeValues(VALUE_ANNO_ATTR), comp, VALUE_ANNO_ATTR, ID_ANNO), String.class);
        vm = BindEvaluatorXUtil.eval(evalx, comp, AnnotationUtil.testString(initanno.getAttributeValues(VALUE_ANNO_ATTR), comp, VALUE_ANNO_ATTR, INIT_ANNO), Object.class);
        if (Strings.isEmpty((String)vmname)) {
            throw new UiException("name of view model is empty");
        }
        try {
            if (vm instanceof String) {
                vm = comp.getPage().resolveClass((String)vm);
            }
            if (vm instanceof Class) {
                vm = ((Class)vm).newInstance();
            }
        }
        catch (Exception e) {
            throw new UiException(e.getMessage(), (Throwable)e);
        }
        if (vm == null) {
            throw new UiException("view model of '" + vmname + "' is null");
        }
        if (vm.getClass().isPrimitive()) {
            throw new UiException("view model '" + vmname + "' is a primitive type, is " + vm);
        }
        comp.setAttribute(vmname, vm);
        comp.setAttribute(VM_ID, (Object)vmname);
        return vm;
    }

    private AnnotateBinder initBinder(BindEvaluatorX evalx, Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation idanno = compCtrl.getAnnotation(BINDER_ATTR, ID_ANNO);
        Annotation initanno = compCtrl.getAnnotation(BINDER_ATTR, INIT_ANNO);
        Object binder = null;
        String bname = null;
        bname = idanno != null ? BindEvaluatorXUtil.eval(evalx, comp, AnnotationUtil.testString(idanno.getAttributeValues(VALUE_ANNO_ATTR), comp, VALUE_ANNO_ATTR, ID_ANNO), String.class) : BINDER_ATTR;
        if (Strings.isEmpty((String)bname)) {
            throw new UiException("name of binder is empty");
        }
        if (initanno != null) {
            binder = AnnotationUtil.testString(initanno.getAttributeValues(VALUE_ANNO_ATTR), comp, VALUE_ANNO_ATTR, INIT_ANNO);
            String name = AnnotationUtil.testString(initanno.getAttributeValues(QUEUE_NAME_ANNO_ATTR), comp, QUEUE_NAME_ANNO_ATTR, INIT_ANNO);
            String scope = AnnotationUtil.testString(initanno.getAttributeValues(QUEUE_SCOPE_ANNO_ATTR), comp, QUEUE_SCOPE_ANNO_ATTR, INIT_ANNO);
            if (binder != null) {
                if (name != null) {
                    _log.warning("queueName is not available if you use custom binder");
                }
                if (scope != null) {
                    _log.warning("queueScope is not available if you use custom binder");
                }
                binder = BindEvaluatorXUtil.eval(evalx, comp, (String)binder, Object.class);
                try {
                    if (binder instanceof String) {
                        binder = comp.getPage().resolveClass((String)binder);
                    }
                    if (binder instanceof Class) {
                        binder = ((Class)binder).newInstance();
                    }
                }
                catch (Exception e) {
                    throw new UiException(e.getMessage(), (Throwable)e);
                }
                if (!(binder instanceof AnnotateBinder)) {
                    throw new UiException("evaluated binder is not a binder is " + binder);
                }
            } else {
                if (name != null && (name = BindEvaluatorXUtil.eval(evalx, comp, name, String.class)) == null) {
                    _log.warning("evaluated queue name is null, use default name. expression is " + name);
                }
                if (scope != null && (scope = BindEvaluatorXUtil.eval(evalx, comp, scope, String.class)) == null) {
                    _log.warning("evaluated queue scope is null, use default scope. expression is " + scope);
                }
                binder = new AnnotateBinder(name, scope);
            }
        } else {
            binder = new AnnotateBinder();
        }
        comp.setAttribute(bname, binder);
        comp.setAttribute(BINDER_ID, (Object)bname);
        return (AnnotateBinder)binder;
    }

    private ValidationMessages initValidationMessages(BindEvaluatorX evalx, Component comp, Binder binder) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation idanno = compCtrl.getAnnotation(VALIDATION_MESSAGES_ATTR, ID_ANNO);
        Annotation initanno = compCtrl.getAnnotation(VALIDATION_MESSAGES_ATTR, INIT_ANNO);
        Object vmessages = null;
        String vname = null;
        if (idanno == null) {
            return null;
        }
        vname = BindEvaluatorXUtil.eval(evalx, comp, AnnotationUtil.testString(idanno.getAttributeValues(VALUE_ANNO_ATTR), comp, VALUE_ANNO_ATTR, ID_ANNO), String.class);
        if (Strings.isEmpty((String)vname)) {
            throw new UiException("name of ValidationMessages is empty");
        }
        if (initanno != null) {
            vmessages = BindEvaluatorXUtil.eval(evalx, comp, AnnotationUtil.testString(initanno.getAttributeValues(VALUE_ANNO_ATTR), comp, VALUE_ANNO_ATTR, INIT_ANNO), Object.class);
            try {
                if (vmessages instanceof String) {
                    vmessages = comp.getPage().resolveClass((String)vmessages);
                }
                if (vmessages instanceof Class) {
                    vmessages = ((Class)vmessages).newInstance();
                }
            }
            catch (Exception e) {
                throw new UiException(e.getMessage(), (Throwable)e);
            }
            if (!(vmessages instanceof ValidationMessages)) {
                throw new UiException("evaluated validationMessages is not a ValidationMessages is " + vmessages);
            }
        } else {
            vmessages = new ValidationMessagesImpl();
        }
        comp.setAttribute(vname, vmessages);
        return (ValidationMessages)vmessages;
    }

    public boolean doCatch(Throwable ex) throws Exception {
        return false;
    }

    public void doFinally() throws Exception {
    }

    public void notifyChange(Object bean, String property) {
        this.getBinder().notifyChange(bean, property);
    }

    private static class BinderKeeper {
        private static final String KEY_BINDER_KEEPER = "$BinderKeeper$";
        private final LinkedList<Loader> _queue;
        private Component _host;

        static BinderKeeper getInstance(Component comp) {
            BinderKeeper keeper = (BinderKeeper)comp.getAttribute(KEY_BINDER_KEEPER, true);
            if (keeper == null) {
                keeper = new BinderKeeper(comp);
                comp.setAttribute(KEY_BINDER_KEEPER, (Object)keeper);
            }
            return keeper;
        }

        public BinderKeeper(Component comp) {
            this._host = comp;
            this._queue = new LinkedList();
            Events.postEvent((String)"onRootBinderHostDone", (Component)comp, null);
            comp.addEventListener("onRootBinderHostDone", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    BinderKeeper.this._host.removeEventListener("onRootBinderHostDone", (EventListener)this);
                    BinderKeeper keeper = (BinderKeeper)BinderKeeper.this._host.getAttribute(BinderKeeper.KEY_BINDER_KEEPER);
                    if (keeper != null) {
                        BinderKeeper.this._host.removeAttribute(BinderKeeper.KEY_BINDER_KEEPER);
                    }
                }
            });
        }

        public void book(Binder binder, Component comp) {
            this._queue.add(new Loader(binder, comp));
        }

        public boolean isRootBinder(Binder binder) {
            return this._queue.getFirst().binder == binder;
        }

        public void loadComponentForAllBinders() {
            this._host.removeAttribute(KEY_BINDER_KEEPER);
            for (Loader loader : this._queue) {
                loader.load();
            }
        }

        private static class Loader {
            Binder binder;
            Component comp;

            public Loader(Binder _binder, Component comp) {
                this.binder = _binder;
                this.comp = comp;
            }

            public void load() {
                this.binder.loadComponent(this.comp, true);
            }
        }
    }
}

