/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Form;
import org.zkoss.bind.FormExt;
import org.zkoss.bind.impl.FormBindingImpl;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.ConditionType;
import org.zkoss.bind.sys.LoadFormBinding;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.xel.ExpressionX;
import org.zkoss.xel.ValueReference;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFormBindingImpl
extends FormBindingImpl
implements LoadFormBinding {
    private static final long serialVersionUID = 1463169907348730644L;
    private int _len;
    private Set<String> _doneDependsOn = new HashSet<String>(4);

    public LoadFormBindingImpl(Binder binder, Component comp, String formId, String loadExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs) {
        super(binder, comp, formId, loadExpr, conditionType, command, bindingArgs);
    }

    @Override
    public void load(BindContext ctx) {
        Binder binder = this.getBinder();
        BindEvaluatorX eval = binder.getEvaluatorX();
        Component comp = this.getComponent();
        Object bean = eval.getValue(ctx, comp, this._accessInfo.getProperty());
        ValueReference valref = eval.getValueReference(ctx, comp, this._accessInfo.getProperty());
        if (valref != null && valref.getBase() instanceof Form || bean instanceof Form) {
            throw new UiException("doesn't support to load a nested form , formId " + this.getFormId());
        }
        Form form = this.getFormBean();
        boolean activating = ((BinderCtrl)((Object)this.getBinder())).isActivating();
        if (form instanceof FormExt) {
            FormExt fex = (FormExt)((Object)form);
            comp.setAttribute("$LOAD_FORM_EXPR$", (Object)this.getPropertyString());
            final String fomrid = this.getFormId();
            LinkedList<String> fields = new LinkedList<String>(fex.getLoadFieldNames());
            Collections.sort(fields, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if ((o1 = BindELContext.appendFields(fomrid, o1)).indexOf(o2 = BindELContext.appendFields(fomrid, o2)) > 0) {
                        return 1;
                    }
                    if (o2.indexOf(o1) > 0) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (String field : fields) {
                ExpressionX expr = this.getFieldExpression(eval, field);
                if (expr == null) continue;
                Object value = eval.getValue(ctx, comp, expr);
                if (activating) continue;
                ExpressionX formExpr = this.getFormExpression(eval, field);
                eval.setValue(null, comp, formExpr, value);
            }
            if (activating) {
                return;
            }
            fex.resetDirty();
        }
        if (activating) {
            return;
        }
        binder.notifyChange(form, ".");
        if (form instanceof FormExt) {
            binder.notifyChange(((FormExt)((Object)form)).getStatus(), ".");
        }
    }

    public void setSeriesLength(int len) {
        this._len = len;
    }

    public int getSeriesLength() {
        return this._len;
    }

    public void addDependsOnTrackings(List<String> srcpath, String basepath, String[] props) {
        if (srcpath != null) {
            String src = BindELContext.pathToString(srcpath);
            if (this._doneDependsOn.contains(src)) {
                return;
            }
            this._doneDependsOn.add(src);
        }
        for (String prop : props) {
            BindELContext.addDependsOnTracking(this, srcpath, basepath, prop);
        }
    }
}

