/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Phase;
import org.zkoss.bind.Property;
import org.zkoss.bind.impl.AbstractBindingHandler;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.BinderImpl;
import org.zkoss.bind.impl.BindingKey;
import org.zkoss.bind.impl.InitPropertyBindingImpl;
import org.zkoss.bind.impl.ValidationContextImpl;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.InitPropertyBinding;
import org.zkoss.bind.sys.LoadPropertyBinding;
import org.zkoss.bind.sys.PropertyBinding;
import org.zkoss.bind.sys.SavePropertyBinding;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyBindingHandler
extends AbstractBindingHandler {
    private static final long serialVersionUID = 1L;
    private static final Log _log = Log.lookup(PropertyBindingHandler.class);
    private final Map<BindingKey, List<InitPropertyBinding>> _initBindings = new HashMap<BindingKey, List<InitPropertyBinding>>();
    private final Map<BindingKey, List<LoadPropertyBinding>> _loadPromptBindings = new HashMap<BindingKey, List<LoadPropertyBinding>>();
    private final Map<BindingKey, List<LoadPropertyBinding>> _loadEventBindings = new HashMap<BindingKey, List<LoadPropertyBinding>>();
    private final Map<BindingKey, List<SavePropertyBinding>> _saveEventBindings = new HashMap<BindingKey, List<SavePropertyBinding>>();
    private final Map<String, List<LoadPropertyBinding>> _loadAfterBindings = new HashMap<String, List<LoadPropertyBinding>>();
    private final Map<String, List<SavePropertyBinding>> _saveAfterBindings = new HashMap<String, List<SavePropertyBinding>>();
    private final Map<String, List<LoadPropertyBinding>> _loadBeforeBindings = new HashMap<String, List<LoadPropertyBinding>>();
    private final Map<String, List<SavePropertyBinding>> _saveBeforeBindings = new HashMap<String, List<SavePropertyBinding>>();

    PropertyBindingHandler() {
    }

    void addLoadEventBinding(Component comp, BindingKey bkey, LoadPropertyBinding binding) {
        List<LoadPropertyBinding> bindings = this._loadEventBindings.get(bkey);
        if (bindings == null) {
            bindings = new ArrayList<LoadPropertyBinding>();
            this._loadEventBindings.put(bkey, bindings);
        }
        bindings.add(binding);
    }

    void addLoadPromptBinding(Component comp, BindingKey bkey, LoadPropertyBinding binding) {
        List<LoadPropertyBinding> bindings = this._loadPromptBindings.get(bkey);
        if (bindings == null) {
            bindings = new ArrayList<LoadPropertyBinding>();
            this._loadPromptBindings.put(bkey, bindings);
        }
        bindings.add(binding);
    }

    void addInitBinding(BindingKey bkey, InitPropertyBinding binding) {
        List<InitPropertyBinding> bindings = this._initBindings.get(bkey);
        if (bindings == null) {
            bindings = new ArrayList<InitPropertyBinding>();
            this._initBindings.put(bkey, bindings);
        }
        bindings.add(binding);
    }

    void addLoadBeforeBinding(String command, LoadPropertyBinding binding) {
        List<LoadPropertyBinding> bindings = this._loadBeforeBindings.get(command);
        if (bindings == null) {
            bindings = new ArrayList<LoadPropertyBinding>();
            this._loadBeforeBindings.put(command, bindings);
        }
        bindings.add(binding);
    }

    void addLoadAfterBinding(String command, LoadPropertyBinding binding) {
        List<LoadPropertyBinding> bindings = this._loadAfterBindings.get(command);
        if (bindings == null) {
            bindings = new ArrayList<LoadPropertyBinding>();
            this._loadAfterBindings.put(command, bindings);
        }
        bindings.add(binding);
    }

    void addSavePromptBinding(Component comp, BindingKey bkey, SavePropertyBinding binding) {
        List<SavePropertyBinding> bindings = this._saveEventBindings.get(bkey);
        if (bindings == null) {
            bindings = new ArrayList<SavePropertyBinding>();
            this._saveEventBindings.put(bkey, bindings);
        }
        bindings.add(binding);
    }

    void addSaveBeforeBinding(String command, SavePropertyBinding binding) {
        List<SavePropertyBinding> bindings = this._saveBeforeBindings.get(command);
        if (bindings == null) {
            bindings = new ArrayList<SavePropertyBinding>();
            this._saveBeforeBindings.put(command, bindings);
        }
        bindings.add(binding);
    }

    void addSaveAfterBinding(String command, SavePropertyBinding binding) {
        List<SavePropertyBinding> bindings = this._saveAfterBindings.get(command);
        if (bindings == null) {
            bindings = new ArrayList<SavePropertyBinding>();
            this._saveAfterBindings.put(command, bindings);
        }
        bindings.add(binding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveBinding(Component comp, SavePropertyBinding binding, String command, Event evt, Set<Property> notifys) {
        BindContext ctx = BindContextUtil.newBindContext(this._binder, binding, true, command, binding.getComponent(), evt);
        BindContextUtil.setConverterArgs(this._binder, binding.getComponent(), ctx, binding);
        BindContextUtil.setValidatorArgs(this._binder, binding.getComponent(), ctx, binding);
        try {
            if (_log.debugable()) {
                _log.debug("doSavePropertyBinding:binding.save() comp=[%s],binding=[%s],command=[%s],evt=[%s],notifys=[%s]", new Object[]{comp, binding, command, evt, notifys});
            }
            this.doPrePhase(Phase.SAVE_BINDING, ctx);
            binding.save(ctx);
        }
        finally {
            this.doPostPhase(Phase.SAVE_BINDING, ctx);
        }
        Set<Property> xnotifys = PropertyBindingHandler.getNotifys(ctx);
        if (xnotifys != null) {
            notifys.addAll(xnotifys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadBinding(Component comp, LoadPropertyBinding binding, String command) {
        BindContext ctx = BindContextUtil.newBindContext(this._binder, binding, false, command, binding.getComponent(), null);
        BindContextUtil.setConverterArgs(this._binder, binding.getComponent(), ctx, binding);
        if (binding instanceof InitPropertyBindingImpl) {
            ctx.setAttribute("$IGNORE_TRACKER$", Boolean.TRUE);
        }
        try {
            if (_log.debugable()) {
                _log.debug("doLoadPropertyBinding:binding.load(),component=[%s],binding=[%s],context=[%s],command=[%s]", new Object[]{comp, binding, ctx, command});
            }
            this.doPrePhase(Phase.LOAD_BINDING, ctx);
            binding.load(ctx);
            if (((BinderImpl)binding.getBinder()).hasValidator(binding.getComponent(), binding.getFieldName())) {
                this.clearValidationMessages(binding.getBinder(), binding.getComponent(), binding.getFieldName());
            }
        }
        finally {
            this.doPostPhase(Phase.LOAD_BINDING, ctx);
        }
    }

    void doLoadEvent(BindingKey bkey, Component comp, String evtnm) {
        List<LoadPropertyBinding> bindings = this._loadEventBindings.get(bkey);
        if (bindings != null) {
            for (LoadPropertyBinding binding : bindings) {
                this.doLoadBinding(comp, binding, null);
            }
        }
    }

    boolean doSaveEvent(BindingKey bkey, Component comp, Event evt, Set<Property> notifys) {
        List<SavePropertyBinding> bindings = this._saveEventBindings.get(bkey);
        if (bindings != null) {
            boolean valid = true;
            for (SavePropertyBinding binding : bindings) {
                valid &= this.doValidateSaveEvent(comp, binding, evt, notifys);
            }
            if (!valid) {
                return false;
            }
            for (SavePropertyBinding binding : bindings) {
                this.doSaveBinding(comp, binding, null, evt, notifys);
            }
        }
        return true;
    }

    private boolean doValidateSaveEvent(Component comp, SavePropertyBinding binding, Event evt, Set<Property> notifys) {
        if (binding.hasValidator()) {
            BindContext ctx = BindContextUtil.newBindContext(this._binder, binding, true, null, binding.getComponent(), evt);
            BindContextUtil.setConverterArgs(this._binder, binding.getComponent(), ctx, binding);
            BindContextUtil.setValidatorArgs(this._binder, binding.getComponent(), ctx, binding);
            try {
                Set<Property> xnotifys;
                this.doPrePhase(Phase.VALIDATE, ctx);
                Property p = binding.getValidate(ctx);
                if (_log.debugable()) {
                    _log.debug("doValidateSaveEvent comp=[%s],binding=[%s],evt=[%s],validate=[%s]", new Object[]{comp, binding, evt, p});
                }
                if (p == null) {
                    throw new UiException("no main property for save-binding " + binding);
                }
                if (((BinderImpl)binding.getBinder()).hasValidator(binding.getComponent(), binding.getFieldName())) {
                    this.clearValidationMessages(binding.getBinder(), binding.getComponent(), binding.getFieldName());
                }
                ValidationContextImpl vctx = new ValidationContextImpl(null, p, this.toCollectedProperties(p), ctx, true);
                binding.validate(vctx);
                boolean valid = vctx.isValid();
                if (_log.debugable()) {
                    _log.debug("doValidateSaveEvent result=[%s]", new Object[]{valid});
                }
                if ((xnotifys = PropertyBindingHandler.getNotifys(ctx)) != null) {
                    notifys.addAll(xnotifys);
                }
                boolean bl = valid;
                return bl;
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
            finally {
                this.doPostPhase(Phase.VALIDATE, ctx);
            }
        }
        return true;
    }

    Map<String, Property[]> toCollectedProperties(Property validate) {
        HashSet<Property> cp = new HashSet<Property>();
        cp.add(validate);
        return this.toCollectedProperties(cp);
    }

    Map<String, Property[]> toCollectedProperties(Set<Property> validates) {
        if (validates == null || validates.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, ArrayList<Property>> temp = new HashMap<String, ArrayList<Property>>(validates.size());
        for (Property p : validates) {
            ArrayList<Property> l = (ArrayList<Property>)temp.get(p.getProperty());
            if (l == null) {
                l = new ArrayList<Property>();
                temp.put(p.getProperty(), l);
            }
            l.add(p);
        }
        HashMap<String, Property[]> collected = new HashMap<String, Property[]>(temp.size());
        for (Map.Entry e : temp.entrySet()) {
            collected.put((String)e.getKey(), ((List)e.getValue()).toArray(new Property[((List)e.getValue()).size()]));
        }
        return collected;
    }

    List<LoadPropertyBinding> getLoadPromptBindings(BindingKey bkey) {
        return this._loadPromptBindings.get(bkey);
    }

    Map<String, List<SavePropertyBinding>> getSaveAfterBindings() {
        return this._saveAfterBindings;
    }

    Map<String, List<SavePropertyBinding>> getSaveBeforeBindings() {
        return this._saveBeforeBindings;
    }

    Map<BindingKey, List<SavePropertyBinding>> getSaveEventBindings() {
        return this._saveEventBindings;
    }

    void doSaveBefore(Component comp, String command, Event evt, Set<Property> notifys) {
        List<SavePropertyBinding> bindings = this._saveBeforeBindings.get(command);
        if (bindings != null) {
            for (SavePropertyBinding binding : bindings) {
                this.doSaveBinding(comp, binding, command, evt, notifys);
            }
        }
    }

    void doSaveAfter(Component comp, String command, Event evt, Set<Property> notifys) {
        List<SavePropertyBinding> bindings = this._saveAfterBindings.get(command);
        if (bindings != null) {
            for (SavePropertyBinding binding : bindings) {
                this.doSaveBinding(comp, binding, command, evt, notifys);
            }
        }
    }

    void doLoadBefore(Component comp, String command) {
        List<LoadPropertyBinding> bindings = this._loadBeforeBindings.get(command);
        if (bindings != null) {
            for (LoadPropertyBinding binding : bindings) {
                this.doLoadBinding(comp, binding, command);
            }
        }
    }

    void doLoadAfter(Component comp, String command) {
        List<LoadPropertyBinding> bindings = this._loadAfterBindings.get(command);
        if (bindings != null) {
            for (LoadPropertyBinding binding : bindings) {
                this.doLoadBinding(comp, binding, command);
            }
        }
    }

    void removeBindings(BindingKey bkey, Set<Binding> removed) {
        List<PropertyBinding> bindingx = this._initBindings.remove(bkey);
        if (bindingx != null) {
            removed.addAll(bindingx);
        }
        if ((bindingx = this._loadPromptBindings.remove(bkey)) != null) {
            removed.addAll(bindingx);
        }
        if ((bindingx = this._loadEventBindings.remove(bkey)) != null) {
            removed.addAll(bindingx);
        }
        if ((bindingx = this._saveEventBindings.remove(bkey)) != null) {
            removed.addAll(bindingx);
        }
    }

    void removeBindings(Collection<Binding> removes) {
        for (List<LoadPropertyBinding> list : this._loadAfterBindings.values()) {
            list.removeAll(removes);
        }
        for (List<PropertyBinding> list : this._saveAfterBindings.values()) {
            list.removeAll(removes);
        }
        for (List<PropertyBinding> list : this._loadBeforeBindings.values()) {
            list.removeAll(removes);
        }
        for (List<PropertyBinding> list : this._saveBeforeBindings.values()) {
            list.removeAll(removes);
        }
    }

    void doLoad(Component comp, BindingKey bkey) {
        List<LoadPropertyBinding> propBindings = this._loadPromptBindings.get(bkey);
        if (propBindings != null) {
            for (LoadPropertyBinding binding : propBindings) {
                this.doLoadBinding(comp, binding, null);
            }
        }
    }

    void doInit(Component comp, BindingKey bkey) {
        List<InitPropertyBinding> initBindings = this._initBindings.get(bkey);
        if (initBindings != null) {
            for (InitPropertyBinding binding : initBindings) {
                this.doLoadBinding(comp, binding, null);
            }
        }
    }
}

