/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.databind;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zkplus.databind.BindingGroupsListModel;
import org.zkoss.zkplus.databind.BindingListModel;
import org.zkoss.zkplus.databind.BindingListModelArray;
import org.zkoss.zkplus.databind.BindingListModelList;
import org.zkoss.zkplus.databind.BindingListModelMap;
import org.zkoss.zkplus.databind.BindingListModelSet;
import org.zkoss.zkplus.databind.TypeConverter;
import org.zkoss.zul.GroupsModel;

public class ListModelConverter
implements TypeConverter,
Serializable {
    private static final long serialVersionUID = 200808191433L;

    public Object coerceToUi(Object val, Component comp) {
        if (val == null) {
            val = new ArrayList();
        }
        boolean distinct = ListModelConverter.isDistinct(comp);
        if (val instanceof BindingListModel) {
            return val;
        }
        if (val instanceof Set) {
            return new BindingListModelSet((Set)((Object)val), true);
        }
        if (val instanceof List) {
            return new BindingListModelList(val, true, distinct);
        }
        if (val instanceof Map) {
            return new BindingListModelMap((Map)((Object)val), true);
        }
        if (val instanceof Object[]) {
            return new BindingListModelArray((Object[])val, true, distinct);
        }
        if (val instanceof Class && Enum.class.isAssignableFrom((Class)((Object)val))) {
            return new BindingListModelArray(((Class)((Object)val)).getEnumConstants(), true);
        }
        if (val instanceof GroupsModel) {
            return new BindingGroupsListModel((GroupsModel)val);
        }
        throw new UiException("Expects java.util.Set, java.util.List, java.util.Map, Object[], Enum Class, GroupsModel, or BindingListModel only. " + val.getClass());
    }

    static boolean isDistinct(Component comp) {
        String distinctstr;
        Map args = (Map)comp.getAttribute("bindingArgs");
        boolean distinct = true;
        if (args != null && (distinctstr = (String)args.get("distinct")) != null) {
            distinct = Boolean.valueOf(distinctstr);
        }
        return distinct;
    }

    public Object coerceToBean(Object val, Component comp) {
        if (val == null) {
            throw new NullPointerException("val");
        }
        if (val instanceof BindingListModelSet) {
            return ((BindingListModelSet)val).getInnerSet();
        }
        if (val instanceof BindingListModelList) {
            return ((BindingListModelList)val).getInnerList();
        }
        if (val instanceof BindingListModelMap) {
            return ((BindingListModelMap)val).getInnerMap();
        }
        if (val instanceof BindingListModelArray) {
            return ((BindingListModelArray)val).getInnerArray();
        }
        if (val instanceof BindingListModel) {
            return val;
        }
        throw new UiException("Expects BindingListModelSet, BindingListModelList, BindingListModelMap, or BindingListModel only." + val.getClass());
    }
}

