/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.embed;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.lang.Library;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.GenericRichlet;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.I18Ns;
import org.zkoss.zk.ui.http.Utils;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.impl.RequestInfoImpl;
import org.zkoss.zk.ui.metainfo.PageDefinitions;
import org.zkoss.zk.ui.sys.HtmlPageRenders;
import org.zkoss.zk.ui.sys.RequestInfo;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;

public class Renders {
    public static final void render(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, Component comp, String path, Writer out) throws ServletException, IOException {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        Renders.render(ctx, request, response, (Richlet)new EmbedRichlet(comp), path, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void render(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, Richlet richlet, String path, Writer out) throws ServletException, IOException {
        WebManager webman;
        if (path == null) {
            path = Https.getThisServletPath((ServletRequest)request);
        }
        if ((webman = WebManager.getWebManagerIfAny((ServletContext)ctx)) == null) {
            String ATTR = "org.zkoss.zkplus.embed.updateURI";
            String updateURI = Library.getProperty((String)"org.zkoss.zkplus.embed.updateURI");
            updateURI = updateURI == null ? "/zkau" : Utils.checkUpdateURI((String)updateURI, (String)"org.zkoss.zkplus.embed.updateURI");
            webman = new WebManager(ctx, updateURI);
        }
        Session sess = WebManager.getSession((ServletContext)ctx, (HttpServletRequest)request);
        WebApp wapp = sess.getWebApp();
        WebAppCtrl wappc = (WebAppCtrl)wapp;
        Object old = I18Ns.setup((Session)sess, (ServletRequest)request, (ServletResponse)response, (String)wapp.getConfiguration().getResponseCharset());
        ExecutionImpl exec = null;
        try {
            Desktop desktop = webman.getDesktop(sess, (ServletRequest)request, (ServletResponse)response, path, true);
            if (desktop == null) {
                return;
            }
            RequestInfoImpl ri = new RequestInfoImpl(wapp, sess, desktop, (Object)request, PageDefinitions.getLocator((WebApp)wapp, (String)path));
            sess.setAttribute("org.zkoss.zk.gae.fix", (Object)new Integer(0));
            ((SessionCtrl)sess).notifyClientRequest(true);
            UiFactory uf = wappc.getUiFactory();
            Page page = WebManager.newPage((UiFactory)uf, (RequestInfo)ri, (Richlet)richlet, (ServletResponse)response, (String)path);
            exec = new ExecutionImpl(ctx, request, response, desktop, page);
            exec.setAttribute("org.zkoss.zk.ui.page.redrawCtrl", (Object)"page");
            exec.setAttribute("org.zkoss.zk.ui.page.renderer", (Object)new PageRenderer((Execution)exec));
            wappc.getUiEngine().execNewPage((Execution)exec, richlet, page, out);
        }
        finally {
            I18Ns.cleanup((ServletRequest)request, (Object)old);
            if (exec != null) {
                exec.removeAttribute("org.zkoss.zk.ui.page.redrawCtrl");
                exec.removeAttribute("org.zkoss.zk.ui.page.renderer");
            }
        }
    }

    public static class PageRenderer
    implements org.zkoss.zk.ui.sys.PageRenderer {
        private final Execution _exec;

        public PageRenderer() {
            this(Executions.getCurrent());
        }

        public PageRenderer(Execution exec) {
            this._exec = exec;
        }

        public void render(Page page, Writer out) throws IOException {
            Desktop desktop = this._exec.getDesktop();
            out.write(HtmlPageRenders.outLangStyleSheets((Execution)this._exec, null, null));
            out.write(HtmlPageRenders.outLangJavaScripts((Execution)this._exec, null, null));
            out.write("<script type=\"text/javascript\">zkpb('");
            out.write(page.getUuid());
            out.write("','");
            out.write(desktop.getId());
            out.write("','");
            out.write(this.getContextURI());
            out.write("','");
            out.write(desktop.getUpdateURI(null));
            out.write("','");
            out.write(desktop.getRequestPath());
            out.write(39);
            String style = page.getStyle();
            if (style != null && style.length() > 0) {
                out.write(",{style:'");
                out.write(style);
                out.write("'}");
            }
            out.write(");zkpe();</script>\n");
            for (Component root = page.getFirstRoot(); root != null; root = root.getNextSibling()) {
                HtmlPageRenders.outStandalone((Execution)this._exec, (Component)root, (Writer)out);
            }
        }

        private String getContextURI() {
            if (this._exec != null) {
                String s = this._exec.encodeURL("/");
                int j = s.lastIndexOf(47);
                return j >= 0 ? s.substring(0, j) + s.substring(j + 1) : s;
            }
            return "";
        }
    }

    private static class EmbedRichlet
    extends GenericRichlet {
        private final Component _comp;

        private EmbedRichlet(Component comp) {
            this._comp = comp;
        }

        public void service(Page page) {
            this._comp.setPage(page);
        }
    }
}

