/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.spring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.XelException;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zkplus.spring.SpringUtil;

public class DelegatingVariableResolver
implements VariableResolver {
    protected List _variableResolvers = new ArrayList();

    public DelegatingVariableResolver() {
        Execution exec = Executions.getCurrent();
        String classes = null;
        if (exec != null) {
            classes = exec.getDesktop().getWebApp().getConfiguration().getPreference("org.zkoss.spring.VariableResolver", null);
        }
        if (classes == null) {
            classes = Library.getProperty((String)"org.zkoss.spring.VariableResolver.class");
        }
        if (classes != null) {
            String[] vrClss = classes.split(",");
            for (int i = 0; i < vrClss.length; ++i) {
                try {
                    Object o = Classes.newInstanceByThread((String)vrClss[i]);
                    if (this._variableResolvers.contains(o)) continue;
                    this._variableResolvers.add(o);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        } else {
            this._variableResolvers.add(new DefaultDelegatingVariableResolver());
        }
    }

    public Object resolveVariable(String name) {
        Object o = null;
        Iterator iterator = this._variableResolvers.iterator();
        while (iterator.hasNext()) {
            VariableResolver resolver = (VariableResolver)iterator.next();
            o = resolver.resolveVariable(name);
            if (o == null) continue;
            return o;
        }
        return o;
    }

    public int hashCode() {
        return Objects.hashCode((Object)this._variableResolvers);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof DelegatingVariableResolver && Objects.equals((Object)this._variableResolvers, (Object)((DelegatingVariableResolver)obj)._variableResolvers);
    }

    private static class DefaultDelegatingVariableResolver
    implements VariableResolver {
        private ApplicationContext _ctx;

        private DefaultDelegatingVariableResolver() {
        }

        private ApplicationContext getApplicationContext() {
            if (this._ctx != null) {
                return this._ctx;
            }
            this._ctx = SpringUtil.getApplicationContext();
            return this._ctx;
        }

        public Object resolveVariable(String name) throws XelException {
            if ("springContext".equals(name)) {
                return this.getApplicationContext();
            }
            return SpringUtil.getBean(name);
        }

        public int hashCode() {
            return Objects.hashCode(this.getClass());
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof DefaultDelegatingVariableResolver && this.getClass() == obj.getClass();
        }
    }
}

