/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.theme;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.util.ThemeProvider;
import org.zkoss.zkplus.theme.Themes;
import org.zkoss.zul.Messagebox;

public class StandardThemeProvider
implements ThemeProvider {
    public static final String DEFAULT_WCS = "~./zul/css/zk.wcs";
    public static final String DEFAULT_MSGBOX_TEMPLATE_URI = "~./zul/html/messagebox.zul";

    public Collection getThemeURIs(Execution exec, List uris) {
        String suffix = StandardThemeProvider.getThemeFileSuffix();
        if (Strings.isEmpty((String)suffix)) {
            Messagebox.setTemplate((String)DEFAULT_MSGBOX_TEMPLATE_URI);
            return uris;
        }
        if (StandardThemeProvider.isUsingDefaultTemplate(suffix)) {
            Messagebox.setTemplate((String)StandardThemeProvider.getThemeMsgBoxURI(suffix));
        }
        uris.add(StandardThemeProvider.getExtCSS(suffix));
        uris.add(StandardThemeProvider.getNormCSS(suffix));
        this.bypassURI(uris, suffix);
        return uris;
    }

    private static String getThemeFileSuffix() {
        String suffix = Themes.getCurrentTheme();
        return "classicblue".equals(suffix) ? null : suffix;
    }

    private static String getExtCSS(String suffix) {
        return "~./zul/css/ext." + suffix + ".css.dsp";
    }

    private static String getNormCSS(String suffix) {
        return "~./zul/css/norm." + suffix + ".css.dsp";
    }

    private static String getThemeMsgBoxURI(String suffix) {
        return "~./zul/html/messagebox." + suffix + ".zul";
    }

    private static boolean isUsingDefaultTemplate(String suffix) {
        return StandardThemeProvider.getThemeMsgBoxURI(suffix).equals(Messagebox.getTemplate()) || DEFAULT_MSGBOX_TEMPLATE_URI.equals(Messagebox.getTemplate());
    }

    private void bypassURI(List uris, String suffix) {
        ListIterator<String> it = uris.listIterator();
        while (it.hasNext()) {
            String uri = (String)it.next();
            if (!uri.startsWith(DEFAULT_WCS)) continue;
            it.set(ThemeProvider.Aide.injectURI((String)uri, (String)suffix));
            break;
        }
    }

    public int getWCSCacheControl(Execution exec, String uri) {
        return 8760;
    }

    public String beforeWCS(Execution exec, String uri) {
        return uri;
    }

    public String beforeWidgetCSS(Execution exec, String uri) {
        String suffix = StandardThemeProvider.getThemeFileSuffix();
        if (Strings.isEmpty((String)suffix)) {
            return uri;
        }
        if (uri.startsWith("~./js/zul/") || uri.startsWith("~./js/zkex/") || uri.startsWith("~./js/zkmax/")) {
            return uri.replaceFirst(".css.dsp", StandardThemeProvider.getWidgetCSSName(suffix));
        }
        return uri;
    }

    private static String getWidgetCSSName(String suffix) {
        return "." + suffix + ".css.dsp";
    }
}

