/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.liferay;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zkoss.lang.Library;
import org.zkoss.lang.Strings;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.sys.PageRenderPatch;
import org.zkoss.zk.ui.sys.RequestInfo;

public class JQueryRenderPatch
implements PageRenderPatch {
    private static final Log log = Log.lookup(JQueryRenderPatch.class);
    public static final String JQUERY_PATCH = "org.zkoss.zkplus.liferary.jQueryPatch";
    private int _delay = -1;

    public JQueryRenderPatch() {
        String val = Library.getProperty((String)JQUERY_PATCH);
        try {
            this._delay = Integer.parseInt(val);
        }
        catch (Throwable ex) {
            log.warning("Ignored delay time specified in org.zkoss.zkplus.liferary.jQueryPatch: " + val);
        }
    }

    public int getDelay() {
        return this._delay;
    }

    public void setDelay(int delay) {
        this._delay = delay;
    }

    public Writer beforeRender(RequestInfo reqInfo) {
        return this._delay >= 0 ? new StringWriter() : null;
    }

    public void patchRender(RequestInfo reqInfo, Page page, Writer result, Writer out) throws IOException {
        String extid = page.getUuid() + "-ext";
        String[] html = this.processHtml(((StringWriter)result).toString());
        out.write(html[0]);
        out.write("<div id=\"");
        out.write(extid);
        out.write("\"></div><script>setTimeout(function(){\njQuery('#");
        out.write(extid);
        out.write("').append('");
        out.write(Strings.escape((String)html[1], (String)"'\n\r\t\f\\/!"));
        out.write("');},");
        out.write("" + this.getBrowserDelay());
        out.write(");</script>");
    }

    protected String getBrowserDelay() {
        return "" + this._delay;
    }

    protected String[] processHtml(String html) {
        boolean isAppendCSS = false;
        StringBuffer script = new StringBuffer("<script>function _zkCSS(uri){var e=document.createElement(\"LINK\");e.rel=\"stylesheet\";e.type=\"text/css\";e.href=uri;document.getElementsByTagName(\"HEAD\")[0].appendChild(e);};");
        Pattern p = Pattern.compile("<link[^>]+href=[\"']?([^'\"> ]+)[\"']?[^>]*>");
        StringBuffer buffer = new StringBuffer();
        int parseStart = 0;
        int scriptStart = 0;
        int scriptEnd = 0;
        scriptStart = html.indexOf("<script");
        while (scriptStart != -1) {
            if (parseStart < scriptStart) {
                Matcher m = p.matcher(html.substring(parseStart, scriptStart));
                while (m.find()) {
                    isAppendCSS = true;
                    String uri = m.group(1);
                    script.append("_zkCSS('" + uri + "');");
                    m.appendReplacement(buffer, "");
                }
                m.appendTail(buffer);
            }
            if ((scriptEnd = html.indexOf("</script>", scriptStart)) == -1) break;
            buffer.append(html.subSequence(scriptStart, scriptEnd += "</script>".length()));
            scriptStart = html.indexOf("<script", scriptEnd);
            if (scriptStart != -1) {
                parseStart = scriptEnd;
                continue;
            }
            buffer.append(html.substring(scriptEnd, html.length()));
            break;
        }
        String[] ret = new String[]{"", html};
        if (isAppendCSS) {
            script.append("</script>");
            ret[0] = script.toString();
            ret[1] = buffer.toString();
        }
        return ret;
    }
}

